/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevisionManager;
import org.eclipse.emf.cdo.view.CDORevisionPrefetchingPolicy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDORevisionPrefetchingPolicyImpl
implements CDORevisionPrefetchingPolicy {
    private int chunkSize;

    public CDORevisionPrefetchingPolicyImpl(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    @Override
    public List<CDOID> loadAhead(CDORevisionManager revisionManager, CDOBranchPoint branchPoint, EObject eObject, EStructuralFeature feature, CDOList list, int accessIndex, CDOID accessID) {
        if (this.chunkSize > 1 && !revisionManager.containsRevision(accessID, branchPoint)) {
            int fromIndex = accessIndex;
            int toIndex = Math.min(accessIndex + this.chunkSize, list.size()) - 1;
            HashSet<CDOID> notRegistered = new HashSet<CDOID>();
            int i = fromIndex;
            while (i <= toIndex) {
                CDOID idElement;
                Object element = list.get(i);
                if (!(!(element instanceof CDOID) || (idElement = (CDOID)element).isTemporary() || idElement.isExternal() || revisionManager.containsRevision(idElement, branchPoint) || notRegistered.contains(idElement))) {
                    notRegistered.add(idElement);
                }
                ++i;
            }
            return new ArrayList<CDOID>(notRegistered);
        }
        return Collections.emptyList();
    }
}

