/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.revision.CDOList;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.delta.CDOAddFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOClearFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOContainerFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOListFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOMoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDORemoveFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOSetFeatureDelta;
import org.eclipse.emf.cdo.common.revision.delta.CDOUnsetFeatureDelta;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOClassInfo;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionDelta;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.util.CommitIntegrityException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.net4j.util.CheckUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitIntegrityCheck {
    private InternalCDOTransaction transaction;
    private Style style;
    private Set<CDOID> newIDs;
    private Set<CDOID> dirtyIDs;
    private Set<CDOID> detachedIDs;
    private Set<CDOObject> missingObjects = new HashSet<CDOObject>();
    private StringBuilder exceptionMessage = new StringBuilder();

    public CommitIntegrityCheck(InternalCDOTransaction.InternalCDOCommitContext commitContext) {
        this(commitContext, Style.EXCEPTION_FAST);
    }

    public CommitIntegrityCheck(InternalCDOTransaction.InternalCDOCommitContext commitContext, Style style) {
        this.transaction = commitContext.getTransaction();
        CheckUtil.checkArg((Object)((Object)style), (String)"style");
        this.style = style;
        this.newIDs = commitContext.getNewObjects().keySet();
        this.dirtyIDs = commitContext.getDirtyObjects().keySet();
        this.detachedIDs = commitContext.getDetachedObjects().keySet();
    }

    public void check() throws CommitIntegrityException {
        for (CDOID newID : this.newIDs) {
            CDOObject newObject = this.transaction.getObject(newID);
            this.checkContainerIncluded(newObject, "new");
            this.checkCurrentRefTargetsIncluded(newObject, "new");
        }
        for (CDOID detachedID : this.detachedIDs) {
            CDOObject detachedObject = this.transaction.getObject(detachedID);
            this.checkFormerContainerIncluded(detachedObject);
            this.checkFormerBidiRefTargetsIncluded(detachedObject, "detached");
        }
        for (CDOID dirtyID : this.dirtyIDs) {
            CDOObject dirtyObject = this.transaction.getObject(dirtyID);
            this.analyzeRevisionDelta((InternalCDOObject)dirtyObject);
        }
        if (!this.missingObjects.isEmpty() && this.style == Style.EXCEPTION) {
            throw this.createException();
        }
    }

    public Set<? extends EObject> getMissingObjects() {
        return this.missingObjects;
    }

    private CDOID getContainerOrResourceID(InternalCDORevision revision) {
        CDOID containerOrResourceID = null;
        Object idOrObject = revision.getContainerID();
        if (idOrObject != null) {
            containerOrResourceID = (CDOID)this.transaction.convertObjectToID(idOrObject);
        }
        if (CDOIDUtil.isNull(containerOrResourceID)) {
            containerOrResourceID = revision.getResourceID();
        }
        return containerOrResourceID;
    }

    private void analyzeRevisionDelta(InternalCDOObject dirtyObject) throws CommitIntegrityException {
        InternalCDORevision cleanRev = this.transaction.getCleanRevisions().get(dirtyObject);
        CheckUtil.checkNull((Object)cleanRev, (String)("Could not obtain clean revision for dirty object " + dirtyObject));
        InternalCDOClassInfo classInfo = dirtyObject.cdoClassInfo();
        InternalCDORevision dirtyRev = dirtyObject.cdoRevision();
        InternalCDORevisionDelta revisionDelta = dirtyRev.compare((CDORevision)cleanRev);
        for (CDOFeatureDelta featureDelta : revisionDelta.getFeatureDeltas()) {
            EStructuralFeature feature = featureDelta.getFeature();
            if (feature == CDOContainerFeatureDelta.CONTAINER_FEATURE) {
                CDOID cleanResourceID;
                CDOID currentResourceID;
                CDOID cleanContainerID;
                CDOID currentContainerID = (CDOID)this.transaction.convertObjectToID(dirtyRev.getContainerID());
                if (!CDOIDUtil.equals((CDOID)currentContainerID, (CDOID)(cleanContainerID = (CDOID)this.transaction.convertObjectToID(cleanRev.getContainerID())))) {
                    if (currentContainerID != CDOID.NULL) {
                        this.checkIncluded(currentContainerID, "container of moved", (CDOObject)dirtyObject);
                    }
                    if (cleanContainerID != CDOID.NULL) {
                        this.checkIncluded(cleanContainerID, "former container of moved", (CDOObject)dirtyObject);
                    }
                }
                if (CDOIDUtil.equals((CDOID)(currentResourceID = dirtyRev.getResourceID()), (CDOID)(cleanResourceID = cleanRev.getResourceID()))) continue;
                if (currentResourceID != CDOID.NULL) {
                    this.checkIncluded(currentResourceID, "resource of moved", (CDOObject)dirtyObject);
                }
                if (cleanResourceID == CDOID.NULL) continue;
                this.checkIncluded(cleanResourceID, "former resource of moved", (CDOObject)dirtyObject);
                continue;
            }
            if (!(feature instanceof EReference)) continue;
            if (featureDelta instanceof CDOListFeatureDelta) {
                boolean hasPersistentOpposite = classInfo.hasPersistentOpposite(feature);
                for (CDOFeatureDelta innerFeatDelta : ((CDOListFeatureDelta)featureDelta).getListChanges()) {
                    this.checkFeatureDelta(innerFeatDelta, hasPersistentOpposite, dirtyObject);
                }
                continue;
            }
            boolean hasPersistentOpposite = classInfo.hasPersistentOpposite(feature);
            this.checkFeatureDelta(featureDelta, hasPersistentOpposite, dirtyObject);
        }
    }

    private void checkIncluded(Object idOrObject, String msg, CDOObject o) throws CommitIntegrityException {
        CDOID id;
        if ((idOrObject = this.transaction.convertObjectToID(idOrObject)) instanceof CDOID && !(id = (CDOID)idOrObject).isNull()) {
            this.checkIncluded(id, msg, o);
        }
    }

    private void checkFeatureDelta(CDOFeatureDelta featureDelta, boolean hasPersistentOpposite, CDOObject dirtyObject) throws CommitIntegrityException {
        boolean containmentOrWithOpposite;
        EReference ref = (EReference)featureDelta.getFeature();
        boolean bl = containmentOrWithOpposite = ref.isContainment() || hasPersistentOpposite;
        if (featureDelta instanceof CDOAddFeatureDelta) {
            Object idOrObject = ((CDOAddFeatureDelta)featureDelta).getValue();
            if (containmentOrWithOpposite || this.isNew(idOrObject)) {
                this.checkIncluded(idOrObject, "added child / refTarget of", dirtyObject);
            }
        } else if (featureDelta instanceof CDOSetFeatureDelta) {
            Object newIDOrObject;
            Object oldIDOrObject = ((CDOSetFeatureDelta)featureDelta).getOldValue();
            CDOID oldID = (CDOID)this.transaction.convertObjectToID(oldIDOrObject);
            if (!CDOIDUtil.isNull((CDOID)oldID) && containmentOrWithOpposite) {
                this.checkIncluded(oldID, "removed / former child / refTarget of", dirtyObject);
            }
            if ((newIDOrObject = ((CDOSetFeatureDelta)featureDelta).getValue()) != null) {
                newIDOrObject = this.transaction.convertObjectToID(newIDOrObject);
                if (containmentOrWithOpposite || this.isNew(newIDOrObject)) {
                    this.checkIncluded(newIDOrObject, "new child / refTarget of", dirtyObject);
                }
            }
        } else if (containmentOrWithOpposite) {
            if (featureDelta instanceof CDORemoveFeatureDelta) {
                Object idOrObject = ((CDORemoveFeatureDelta)featureDelta).getValue();
                CDOID id = (CDOID)this.transaction.convertObjectToID(idOrObject);
                this.checkIncluded(id, "removed child / refTarget of", dirtyObject);
            } else if (featureDelta instanceof CDOClearFeatureDelta) {
                EStructuralFeature feat = ((CDOClearFeatureDelta)featureDelta).getFeature();
                InternalCDORevision cleanRev = this.transaction.getCleanRevisions().get(dirtyObject);
                int n = cleanRev.size(feat);
                int i = 0;
                while (i < n) {
                    Object idOrObject = cleanRev.get(feat, i);
                    CDOID id = (CDOID)this.transaction.convertObjectToID(idOrObject);
                    this.checkIncluded(id, "removed child / refTarget of", dirtyObject);
                    ++i;
                }
            } else if (featureDelta instanceof CDOUnsetFeatureDelta) {
                EStructuralFeature feat = ((CDOUnsetFeatureDelta)featureDelta).getFeature();
                InternalCDORevision cleanRev = this.transaction.getCleanRevisions().get(dirtyObject);
                Object idOrObject = cleanRev.getValue(feat);
                CDOID id = (CDOID)this.transaction.convertObjectToID(idOrObject);
                this.checkIncluded(id, "removed child / refTarget of", dirtyObject);
            } else if (!(featureDelta instanceof CDOMoveFeatureDelta)) {
                throw new IllegalArgumentException("Unexpected delta type: " + featureDelta.getClass().getSimpleName());
            }
        }
    }

    private boolean isNew(Object idOrObject) {
        CDOObject object = null;
        if (idOrObject instanceof CDOObject) {
            object = (CDOObject)idOrObject;
        } else if (idOrObject instanceof EObject) {
            object = CDOUtil.getCDOObject((EObject)idOrObject);
        } else if (idOrObject instanceof CDOID) {
            object = this.transaction.getObject((CDOID)idOrObject);
        }
        if (object != null) {
            return object.cdoState() == CDOState.NEW;
        }
        return false;
    }

    private void checkIncluded(CDOID id, String msg, CDOObject o) throws CommitIntegrityException {
        if (id.isNull()) {
            throw new IllegalArgumentException("CDOID must not be NULL");
        }
        if (!(this.dirtyIDs.contains(id) || this.detachedIDs.contains(id) || this.newIDs.contains(id))) {
            CDOObject missingObject = this.transaction.getObject(id);
            if (missingObject == null) {
                throw new IllegalStateException("Could not find object for CDOID " + id);
            }
            this.missingObjects.add(missingObject);
            if (this.exceptionMessage.length() > 0) {
                this.exceptionMessage.append('\n');
            }
            String m = String.format("The %s object %s needs to be included in the commit but isn't", msg, o);
            this.exceptionMessage.append(m);
            if (this.style == Style.EXCEPTION_FAST) {
                throw this.createException();
            }
        }
    }

    private CommitIntegrityException createException() {
        return new CommitIntegrityException(this.exceptionMessage.toString(), this.missingObjects);
    }

    private void checkContainerIncluded(CDOObject object, String msgFrag) throws CommitIntegrityException {
        EObject eContainer = object.eContainer();
        if (eContainer == null) {
            CDOResource resource = object.cdoDirectResource();
            this.checkIncluded(resource.cdoID(), "resource of " + msgFrag, object);
        } else {
            CDOObject container = CDOUtil.getCDOObject(eContainer);
            this.checkIncluded(container.cdoID(), "container of " + msgFrag, object);
        }
    }

    private void checkCurrentRefTargetsIncluded(CDOObject referencer, String msgFrag) throws CommitIntegrityException {
        InternalCDOClassInfo classInfo = ((InternalCDOObject)referencer).cdoClassInfo();
        EReference[] eReferenceArray = classInfo.getAllPersistentReferences();
        int n = eReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean hasPersistentOpposite;
            EReference reference = eReferenceArray[n2];
            if (reference.isMany()) {
                EList list = (EList)referencer.eGet((EStructuralFeature)reference);
                if (!list.isEmpty()) {
                    hasPersistentOpposite = classInfo.hasPersistentOpposite((EStructuralFeature)reference);
                    for (Object refTarget : list) {
                        this.checkBidiRefTargetOrNewNonBidiTargetIncluded(referencer, reference, refTarget, hasPersistentOpposite, msgFrag);
                    }
                }
            } else {
                Object refTarget = referencer.eGet((EStructuralFeature)reference);
                if (refTarget != null) {
                    hasPersistentOpposite = classInfo.hasPersistentOpposite((EStructuralFeature)reference);
                    this.checkBidiRefTargetOrNewNonBidiTargetIncluded(referencer, reference, refTarget, hasPersistentOpposite, msgFrag);
                }
            }
            ++n2;
        }
    }

    private void checkBidiRefTargetOrNewNonBidiTargetIncluded(CDOObject referencer, EReference eRef, Object refTarget, boolean hasPersistentOpposite, String msgFrag) throws CommitIntegrityException {
        if (hasPersistentOpposite) {
            this.checkBidiRefTargetIncluded(refTarget, referencer, eRef.getName(), msgFrag);
        } else if (this.isNew(refTarget)) {
            this.checkIncluded(refTarget, "target of reference '" + eRef.getName() + "' of " + msgFrag, referencer);
        }
    }

    private void checkFormerBidiRefTargetsIncluded(CDOObject referencer, String msgFrag) throws CommitIntegrityException {
        InternalCDORevision cleanRev = this.transaction.getCleanRevisions().get(referencer);
        CheckUtil.checkState((Object)cleanRev, (String)"cleanRev");
        InternalCDOClassInfo referencerClassInfo = ((InternalCDOObject)referencer).cdoClassInfo();
        EReference[] eReferenceArray = referencerClassInfo.getAllPersistentReferences();
        int n = eReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            EReference reference = eReferenceArray[n2];
            if (referencerClassInfo.hasPersistentOpposite((EStructuralFeature)reference)) {
                if (reference.isMany()) {
                    CDOList list = cleanRev.getList((EStructuralFeature)reference);
                    if (list != null) {
                        for (Object element : list) {
                            this.checkBidiRefTargetIncluded(element, referencer, reference.getName(), msgFrag);
                        }
                    }
                } else {
                    Object value = cleanRev.getValue((EStructuralFeature)reference);
                    if (value != null) {
                        this.checkBidiRefTargetIncluded(value, referencer, reference.getName(), msgFrag);
                    }
                }
            }
            ++n2;
        }
    }

    private void checkBidiRefTargetIncluded(Object refTarget, CDOObject referencer, String refName, String msgFrag) throws CommitIntegrityException {
        CheckUtil.checkArg((Object)refTarget, (String)"refTarget");
        CDOID refTargetID = null;
        if (refTarget instanceof EObject) {
            refTargetID = CDOUtil.getCDOObject((EObject)refTarget).cdoID();
            if (refTargetID == null) {
                return;
            }
        } else if (refTarget instanceof CDOID) {
            refTargetID = (CDOID)refTarget;
        }
        this.checkIncluded(refTargetID, "target of reference '" + refName + "' of " + msgFrag, referencer);
    }

    private void checkFormerContainerIncluded(CDOObject detachedObject) throws CommitIntegrityException {
        InternalCDORevision rev = this.transaction.getCleanRevisions().get(detachedObject);
        CheckUtil.checkNull((Object)rev, (String)("Could not obtain clean revision for detached object " + detachedObject));
        CDOID id = this.getContainerOrResourceID(rev);
        this.checkIncluded(id, "former container (or resource) of detached", detachedObject);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        EXCEPTION_FAST,
        EXCEPTION,
        NO_EXCEPTION;

    }
}

