/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.ISpecializationType;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.sysml.service.types.command.SetNestedPathCommand;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.utils.ConnectorUtils;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.utils.RequestParameterUtils;
import org.eclipse.uml2.uml.Property;

public class BlockConnectorEditHelperAdvice
extends AbstractEditHelperAdvice {
    private ConnectorUtils utils = new ConnectorUtils();

    protected ICommand getBeforeCreateRelationshipCommand(CreateRelationshipRequest request) {
        EObject source = request.getSource();
        EObject target = request.getTarget();
        View sourceView = RequestParameterUtils.getSourceView((IEditCommandRequest)request);
        View targetView = RequestParameterUtils.getTargetView((IEditCommandRequest)request);
        if (request.getElementType() == UMLElementTypes.CONNECTOR && request.getSource() != null && request.getTarget() != null && request.getContainer() != null && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches(request.getContainer())) {
            if (this.utils.isCrossingEncapsulation(sourceView, targetView) || this.utils.isCrossingEncapsulation(targetView, sourceView)) {
                return UnexecutableCommand.INSTANCE;
            }
            if (ConnectorUtils.canCreate(source, target, sourceView, targetView)) {
                request.setParameter("UML_STRICT", (Object)false);
            }
        }
        return super.getBeforeCreateRelationshipCommand(request);
    }

    protected ICommand getAfterCreateRelationshipCommand(CreateRelationshipRequest request) {
        ICommand defaultCommand = super.getAfterCreateRelationshipCommand(request);
        View sourceView = RequestParameterUtils.getSourceView((IEditCommandRequest)request);
        View targetView = RequestParameterUtils.getTargetView((IEditCommandRequest)request);
        if (request.getElementType() == UMLElementTypes.CONNECTOR && request.getSource() != null && request.getTarget() != null && request.getContainer() != null && ((ISpecializationType)SysMLElementTypes.BLOCK).getMatcher().matches(request.getContainer())) {
            List<Property> nestedPath;
            if (this.utils.isNestedConnectableElement(sourceView, targetView)) {
                nestedPath = this.utils.getNestedPropertyPath(sourceView, targetView);
                defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)new SetNestedPathCommand("Set connector nested source path", request.getNewElement(), (IEditCommandRequest)request, nestedPath, 1));
            }
            if (this.utils.isNestedConnectableElement(targetView, sourceView)) {
                nestedPath = this.utils.getNestedPropertyPath(targetView, sourceView);
                defaultCommand = CompositeCommand.compose((ICommand)defaultCommand, (ICommand)new SetNestedPathCommand("Set connector nested source path", request.getNewElement(), (IEditCommandRequest)request, nestedPath, 2));
            }
        }
        return defaultCommand;
    }
}

