/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.constraints.ConstraintsPackage;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class ConstraintPropertyEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public ConstraintPropertyEditHelperAdvice() {
        this.requiredProfiles.add(ConstraintsPackage.eINSTANCE);
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    UMLUtil.StereotypeApplicationHelper.INSTANCE.applyStereotype((Element)element, ConstraintsPackage.eINSTANCE.getConstraintProperty());
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)ConstraintsPackage.eINSTANCE.getConstraintProperty().getName().toLowerCase(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                    if (element instanceof Property) {
                        ((Property)element).setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    }
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(request.getFeature()) && request.getValue() != null) {
            if (!(request.getValue() instanceof Element)) {
                return UnexecutableCommand.INSTANCE;
            }
            ConstraintBlock constraint = (ConstraintBlock)UMLUtil.getStereotypeApplication((Element)((Element)request.getValue()), ConstraintBlock.class);
            if (constraint == null) {
                return UnexecutableCommand.INSTANCE;
            }
        }
        return null;
    }

    protected ICommand getAfterConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Property sourcePart = (Property)request.getElementToConfigure();
                if (sourcePart != null && sourcePart.eContainer() != null) {
                    sourcePart.setAggregation(AggregationKind.COMPOSITE_LITERAL);
                    Type sourceType = this.resolveTypeContainer(sourcePart);
                    Package associationContainer = sourceType.getNearestPackage();
                    Property targetProperty = UMLFactory.eINSTANCE.createProperty();
                    targetProperty.setType(sourceType);
                    targetProperty.setName(sourceType.getName() != null ? sourceType.getName().toLowerCase() : "null");
                    Association association = UMLFactory.eINSTANCE.createAssociation();
                    association.getMemberEnds().add((Object)sourcePart);
                    association.getOwnedEnds().add((Object)targetProperty);
                    association.getMemberEnds().add((Object)targetProperty);
                    String associationName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)"Association", (Collection)associationContainer.eContents());
                    association.setName(associationName);
                    ElementUtil.addNature((Element)association, (String)"SysML_Nature");
                    association.setPackage(associationContainer);
                }
                return CommandResult.newOKCommandResult((Object)sourcePart);
            }

            private Type resolveTypeContainer(Property property) {
                EObject eContainer = property.eContainer();
                if (eContainer instanceof Property) {
                    eContainer = ((Property)eContainer).getType();
                }
                if (eContainer instanceof Type) {
                    return (Type)eContainer;
                }
                return null;
            }
        };
    }
}

