/*
 * Decompiled with CFR 0.152.
 */
package eu.fbk.eclipse.standardtools.StateMachineTranslatorToCleanC.core.utils;

import com.google.inject.Injector;
import eu.fbk.eclipse.standardtools.utils.core.utils.FileSystemUtil;
import eu.fbk.eclipse.standardtools.xtextService.core.utils.XTextResourceUtil;
import eu.fbk.tools.editor.c.c.TranslationUnit;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.resource.SaveOptions;
import org.eclipse.xtext.serializer.ISerializer;

public class CleanCModelUtil {
    private static final Logger logger = Logger.getLogger(CleanCModelUtil.class);
    private static CleanCModelUtil cleanCModelUtil;
    private XTextResourceUtil xtextResourceUtil = XTextResourceUtil.getInstance();

    public static CleanCModelUtil getInstance() {
        if (cleanCModelUtil == null) {
            cleanCModelUtil = new CleanCModelUtil();
        }
        return cleanCModelUtil;
    }

    public File generateCleanCFileFromCleanCModel(String selectedDirectory, String fileName, Object cleanCModel, IProgressMonitor monitor) throws Exception {
        monitor.subTask("generate C File model from C Model");
        File cleanCFile = this.generateCleanCFile(fileName, (TranslationUnit)cleanCModel, selectedDirectory);
        monitor.worked(1);
        return cleanCFile;
    }

    public File generateCleanCFile(String fileName, TranslationUnit ossModel, String workspaceDir) throws IOException {
        logger.debug((Object)"generateCleanCFile");
        File cleanCFile = fileName == null ? FileSystemUtil.generateEmptyFile((String)".c", (String)workspaceDir) : FileSystemUtil.generateEmptyFile((String)fileName, (String)".c", (String)workspaceDir);
        BufferedWriter bw = new BufferedWriter(new FileWriter(cleanCFile));
        this.generateText(bw, ossModel);
        bw.close();
        return cleanCFile;
    }

    private void generateText(Writer writer, TranslationUnit cleanCModel) throws IOException {
        if (writer == null) {
            return;
        }
        logger.debug((Object)"generateCText");
        Injector injector = this.xtextResourceUtil.getCleanCInjector();
        ISerializer serializer = (ISerializer)injector.getInstance(ISerializer.class);
        SaveOptions saveOpt = SaveOptions.newBuilder().format().getOptions();
        String serialization = serializer.serialize((EObject)cleanCModel, saveOpt);
        logger.debug((Object)("C: " + serialization));
        writer.append(serialization);
        logger.debug((Object)"C file generation completed");
    }
}

