/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Transition;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.core.Activator;

public class OpaqueExprChecker
extends AbstractModelConstraint {
    private static final String CLEAN_C_LANGUAGE = "CleanC";
    private static final String OCRA_LANGUAGE = "OCRA";

    public IStatus validate(IValidationContext ctx) {
        OpaqueExpression opaqueExpression = (OpaqueExpression)ctx.getTarget();
        String thisElement = opaqueExpression.getName();
        IStatus success = ctx.createSuccessStatus();
        Boolean checkOpaqueExpression = Activator.getDefault().getPreferenceStore().getBoolean("OpaqueExpression");
        if (checkOpaqueExpression.booleanValue()) {
            if (this.belongsToTransitionGuard(opaqueExpression)) {
                if (!opaqueExpression.getLanguages().contains((Object)CLEAN_C_LANGUAGE)) {
                    String errorMsg = "The transition guard must be defined with the language 'CleanC'.";
                    IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
                    return failure;
                }
                return success;
            }
            if (this.belongsToDelegationConstraints(opaqueExpression)) {
                if (!opaqueExpression.getLanguages().contains((Object)OCRA_LANGUAGE)) {
                    String errorMsg = "The delegation constraint must be defined with the language 'OCRA'.";
                    IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
                    return failure;
                }
                return success;
            }
            if (this.belongsToFormalProperty(opaqueExpression)) {
                if (!opaqueExpression.getLanguages().contains((Object)OCRA_LANGUAGE)) {
                    String errorMsg = "The formal property must be defined with the language 'OCRA'.";
                    IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
                    return failure;
                }
                return success;
            }
            String errorMsg = "The expression with this owner is not supported.";
            IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
            return failure;
        }
        return success;
    }

    private boolean belongsToFormalProperty(OpaqueExpression expr) {
        Element owner = expr.getOwner();
        return EntityUtil.getInstance().isFormalProperty(owner);
    }

    private boolean belongsToDelegationConstraints(OpaqueExpression expr) {
        Element owner = expr.getOwner();
        return EntityUtil.getInstance().isDelegationConstraint(owner);
    }

    private boolean belongsToTransitionGuard(OpaqueExpression expr) {
        Element owner = expr.getOwner();
        return owner instanceof Constraint && owner.getOwner() instanceof Transition;
    }
}

