/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.sysml.portandflows.FlowDirection;
import org.eclipse.papyrus.sysml.portandflows.FlowPort;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.chess.core.Activator;

public class Connector_02
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        Connector con = (Connector)ctx.getTarget();
        String thisElement = con.getName();
        IStatus success = ctx.createSuccessStatus();
        Boolean checkPortDirections = Activator.getDefault().getPreferenceStore().getBoolean("PortDirections");
        if (checkPortDirections.booleanValue()) {
            if (!ctx.getEventType().equals(EMFEventType.SET)) {
                return success;
            }
            ConnectorEnd firstEnd = (ConnectorEnd)con.getEnds().get(0);
            if (!(firstEnd.getRole() instanceof Port)) {
                String errorMsg = "First end is not instance of Port.";
                IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
                return failure;
            }
            Port firstPort = (Port)firstEnd.getRole();
            Stereotype firstStereo = firstPort.getAppliedStereotype("SysML::PortAndFlows::FlowPort");
            if (firstStereo == null) {
                return success;
            }
            FlowPort firstFlowPort = (FlowPort)firstPort.getStereotypeApplication(firstStereo);
            ConnectorEnd secondEnd = (ConnectorEnd)con.getEnds().get(1);
            if (!(secondEnd.getRole() instanceof Port)) {
                String errorMsg = "Second end is not instance of Port.";
                IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
                return failure;
            }
            Port secondPort = (Port)secondEnd.getRole();
            Stereotype secondStereo = secondPort.getAppliedStereotype("SysML::PortAndFlows::FlowPort");
            if (secondStereo == null) {
                return success;
            }
            FlowPort secondFlowPort = (FlowPort)secondPort.getStereotypeApplication(secondStereo);
            FlowDirection firstDir = firstFlowPort.getDirection();
            FlowDirection secondDir = secondFlowPort.getDirection();
            if (firstDir.equals((Object)FlowDirection.INOUT) || secondDir.equals((Object)FlowDirection.INOUT)) {
                return success;
            }
            if (firstDir.equals((Object)FlowDirection.IN) && firstEnd.getPartWithPort() == null && secondDir.equals((Object)FlowDirection.IN) && secondEnd.getPartWithPort() != null) {
                return success;
            }
            if (firstDir.equals((Object)FlowDirection.OUT) && firstEnd.getPartWithPort() != null && secondDir.equals((Object)FlowDirection.IN) && secondEnd.getPartWithPort() != null) {
                return success;
            }
            if (firstDir.equals((Object)FlowDirection.OUT) && firstEnd.getPartWithPort() != null && secondDir.equals((Object)FlowDirection.OUT) && secondEnd.getPartWithPort() == null) {
                return success;
            }
            String errorMsg = "The ports '" + firstPort.getName() + "' and '" + secondPort.getName() + "' have incompatible directions.";
            IStatus failure = ctx.createFailureStatus(new Object[]{thisElement, errorMsg});
            return failure;
        }
        return success;
    }
}

