/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tabbedproperties.xtext;

import com.google.inject.Injector;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.polarsys.chess.tabbedproperties.xtext.FLAExpressionsProvider;
import org.polarsys.chess.xtext.fladsl.ui.internal.FladslActivator;

public class XtextInputDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private StyledText text;
    private Text errorMessageText;
    private String errorMessage;
    private final boolean xtextEnabled;
    private EmbeddedEditorModelAccess embeddedEditorModel;

    public XtextInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        this(parentShell, dialogTitle, dialogMessage, initialValue, validator, true);
    }

    public XtextInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator, boolean xtextEnabled) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
        this.xtextEnabled = xtextEnabled;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.embeddedEditorModel.getSerializedModel() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(772);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        if (this.xtextEnabled) {
            Injector injector = FladslActivator.getInstance().getInjector("org.polarsys.chess.xtext.FlaDsl");
            FLAExpressionsProvider provider = (FLAExpressionsProvider)injector.getInstance(FLAExpressionsProvider.class);
            EmbeddedEditorFactory factory = (EmbeddedEditorFactory)injector.getInstance(EmbeddedEditorFactory.class);
            EmbeddedEditor editor = factory.newEditor((IEditedResourceProvider)provider).withParent(composite);
            this.embeddedEditorModel = editor.createPartialEditor("", this.value, "", false);
        } else {
            this.text = new StyledText(composite, 2880);
        }
        this.errorMessageText = new Text(composite, 8);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        XtextInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    @Deprecated
    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected StyledText getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }
}

