/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.m2m.transformations;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.Package;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.m2m.transformations.AcceleoMarte2mastProxy;
import org.polarsys.chess.m2m.transformations.QVToTransformation;
import org.polarsys.chess.m2m.transformations.TransUtil;
import org.polarsys.chess.m2m.transformations.TransformationResultsData;

public abstract class AbstractTransformation {
    private static final boolean DEBUG = false;
    private String folder = "schedulability_analysis";
    private IFolder transDir;
    protected Map<String, String> configProperty;
    private String saAnalysisName;
    private String psmPackageName;

    public String getFolder() {
        return this.folder;
    }

    public void setFolder(String newFolder) {
        this.folder = newFolder;
    }

    public Map<String, String> getConfigProperty() {
        return this.configProperty;
    }

    public void setConfigProperty(Map<String, String> configProperty) {
        this.configProperty = configProperty;
    }

    public String getPsmPackageName() {
        return this.psmPackageName;
    }

    public void setPsmPackageName(String psmPackageName) {
        this.psmPackageName = psmPackageName;
    }

    protected IFile prepareModel(IFile modelFile) throws Exception {
        this.transDir = modelFile.getProject().getFolder(this.folder);
        CHESSProjectSupport.deleteFolder((IFolder)this.transDir);
        CHESSProjectSupport.createFolder((IFolder)this.transDir);
        IFile modelCopy = CHESSProjectSupport.copyFile((IFile)modelFile, (String)this.folder, (String)modelFile.getName());
        Model m = TransUtil.purgeModel(modelCopy, this.saAnalysisName);
        m.eResource().save(null);
        return modelCopy;
    }

    public TransformationResultsData performTimingAnalysisWithMAST(PapyrusMultiDiagramEditor editor, IFile modelFile, IProgressMonitor monitor) throws Exception {
        IFile modelCopy = this.performPIM2PSMtransformation(editor, modelFile, monitor, false);
        String result = this.launchMarte2MastTrasformation(monitor, modelCopy, editor);
        CHESSProjectSupport.fileReplace((IFile)modelCopy, (IFile)modelFile);
        return new TransformationResultsData(result, modelFile);
    }

    public IFile performPIM2PSMtransformation(PapyrusMultiDiagramEditor editor, IFile modelFile, IProgressMonitor monitor, boolean replaceFile) throws Exception {
        this.saAnalysisName = this.configProperty.get("saAnalysis");
        IFile modelCopy = this.prepareModel(modelFile);
        QVToTransformation.launchCeilingAssignment(modelCopy, monitor);
        this.launchPIM2PSMtransformation(monitor, modelCopy);
        if (replaceFile) {
            CHESSProjectSupport.fileReplace((IFile)modelCopy, (IFile)modelFile);
        }
        return modelCopy;
    }

    protected abstract void launchPIM2PSMtransformation(IProgressMonitor var1, IFile var2) throws Exception;

    protected abstract void backpropagation(PapyrusMultiDiagramEditor var1, IFile var2) throws Exception;

    protected String launchMarte2MastTrasformation(IProgressMonitor monitor, IFile modelCopy, PapyrusMultiDiagramEditor editor) throws Exception {
        Package psmPackage;
        block3: {
            try {
                ModelContent inModel = TransUtil.loadModel(modelCopy);
                Model model = (Model)inModel.getContent().get(0);
                Package psmView = ViewUtils.getCHESSPSMPackage((Model)model);
                psmPackage = psmView.getNestedPackage(this.psmPackageName);
                if (psmPackage != null) break block3;
                return null;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        String result = AcceleoMarte2mastProxy.runMarte2Mast(modelCopy, this.transDir, monitor, psmPackage);
        this.backpropagation(editor, modelCopy);
        return result;
    }
}

