/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.transformations.commands;

import eu.fbk.eclipse.standardtools.utils.core.model.AbstractSystemModel;
import eu.fbk.eclipse.standardtools.utils.core.utils.StringArrayUtil;
import eu.fbk.eclipse.standardtools.utils.ui.dialogs.SelectArchitectureConfigurationDialog;
import java.util.StringJoiner;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.polarsys.chess.chessmlprofile.Dependability.DependableComponent.Analysis;
import org.polarsys.chess.chessmlprofile.ParameterizedArchitecture.InstantiatedArchitectureConfiguration;
import org.polarsys.chess.contracts.profile.chesscontract.util.EntityUtil;
import org.polarsys.chess.contracts.transformations.commands.AbstractXSapHandler;
import org.polarsys.chess.service.core.exceptions.NoComponentException;
import org.polarsys.chess.service.core.model.ChessSystemModel;
import org.polarsys.chess.service.gui.utils.SelectionUtil;

public class FMEAXSapHandler
extends AbstractXSapHandler {
    private Class umlSelectedComponent;
    private InstantiatedArchitectureConfiguration selectedInstantiatedArchitectureConfiguration;
    private SelectionUtil selectionUtil = SelectionUtil.getInstance();

    private String processConditions(String conditions) {
        StringJoiner arguments = new StringJoiner(" ");
        String[] stringArray = this.ftaFmeaCond.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String condition = stringArray[n2];
            arguments.add("\"" + condition + "\"");
            ++n2;
        }
        return arguments.toString();
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            this.umlSelectedComponent = this.selectionUtil.getUmlComponentFromSelectedObject(event);
        }
        catch (NoComponentException noComponentException) {
            this.umlSelectedComponent = this.analysisResultUtil.getSystemComponentFromEvent(event);
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        EList instantiatedArchitecures = EntityUtil.getInstance().getInstantiatedArchitecureConfigurations(this.umlSelectedComponent);
        if (instantiatedArchitecures != null && !instantiatedArchitecures.isEmpty()) {
            SelectArchitectureConfigurationDialog dialog = new SelectArchitectureConfigurationDialog(shell, (AbstractSystemModel)ChessSystemModel.getInstance(), instantiatedArchitecures);
            dialog.open();
            if (dialog.goAhead()) {
                this.selectedInstantiatedArchitectureConfiguration = (InstantiatedArchitectureConfiguration)dialog.getSelectedAchitectureConfiguration();
            }
        }
        if (!this.prepareExpandedFiles(event, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, Analysis.FMEA_ANALYSIS)) {
            return null;
        }
        String fmeaFileName = this.fileNamesUtil.computeFmeaFileName(this.editor, this.modelName);
        if (this.xSapExecService.computeFmea(this.extendedSmvFileName, this.fmsFileName, this.processConditions(this.ftaFmeaCond), fmeaFileName, true)) {
            BasicEList props = new BasicEList();
            StringArrayUtil.addConditionKeyValue((EList)props, (String)"property", (String)this.ftaFmeaCond);
            this.analysisResultUtil.createOrUpdateAnalysisContext(Analysis.FMEA_ANALYSIS, (EList)props, fmeaFileName, false, this.umlSelectedComponent, this.selectedInstantiatedArchitectureConfiguration, this.analysisContext);
            this.analysisResultUtil.showResult("xsap_compute_fmea_table", fmeaFileName);
        }
        return null;
    }
}

