/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.checkers.core.checkerManager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPage;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerPageBookView;
import org.eclipse.papyrus.views.modelexplorer.ModelExplorerView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPage;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.xtext.nodemodel.INode;
import org.polarsys.chess.checkers.core.checkerManager.Checker;
import org.polarsys.chess.checkers.core.checkerManager.CheckerMessage;
import org.polarsys.chess.checkers.core.checkerManager.CheckersContainer;
import org.polarsys.chess.service.gui.utils.ReportProblemsUtil;

public class CheckerManager {
    private static final Logger logger = Logger.getLogger(CheckerManager.class);
    private static final String CHECKER_NAME = "checkerName";
    List<CheckersContainer> checkersContainers;
    List<CheckerMessage> messages;
    HashMap<String, Boolean> checkerStatus;

    public CheckerManager() {
        logger.debug((Object)"Instantiate CheckerManager");
        this.checkersContainers = new ArrayList<CheckersContainer>();
        new CheckersContainer(this);
    }

    public void run(Set<String> selectedCheckersTags) throws Exception {
        logger.debug((Object)"run");
        this.checkerStatus = new HashMap();
        this.messages = new ArrayList<CheckerMessage>();
        for (CheckersContainer checkersContainer : this.checkersContainers) {
            logger.debug((Object)"run checkersContainer");
            checkersContainer.run(selectedCheckersTags);
        }
    }

    public void initSync(Set<String> selectedCheckersTags) throws Exception {
        logger.debug((Object)"initSync");
        for (CheckersContainer checkersContainer : this.checkersContainers) {
            logger.debug((Object)"init checkersContainer");
            checkersContainer.initSync(selectedCheckersTags);
        }
    }

    /*
     * Unable to fully structure code
     */
    public List<Exception> checkSync(Set<String> selectedCheckersTags, Package pkg, IProgressMonitor monitor) {
        block4: {
            CheckerManager.logger.debug((Object)"runSync");
            errors = new ArrayList<Exception>();
            this.checkerStatus = new HashMap<K, V>();
            this.messages = new ArrayList<CheckerMessage>();
            jobs = new ArrayList<Job>();
            for (CheckersContainer checkersContainer : this.checkersContainers) {
                CheckerManager.logger.debug((Object)"run checkersContainer");
                jobs.addAll(checkersContainer.checkSync(selectedCheckersTags, pkg));
            }
            try {
                Job.getJobManager().join((Object)Checker.FAMILY, monitor);
                break block4;
            }
            catch (InterruptedException | OperationCanceledException e1) {
                CheckerManager.logger.debug((Object)"Checker execution interrupted");
                ** for (job : jobs)
            }
lbl-1000:
            // 1 sources

            {
                job.cancel();
                continue;
            }
lbl20:
            // 1 sources

            errors.add(new Exception("Esecuzione checker interrotta"));
            e1.printStackTrace();
        }
        return errors;
    }

    public void register(CheckersContainer checkersContainer) {
        logger.debug((Object)"register CheckersContainer");
        this.checkersContainers.add(checkersContainer);
    }

    public Set<String> getTags() {
        HashSet<String> tags = new HashSet<String>();
        for (CheckersContainer containter : this.checkersContainers) {
            tags.addAll(containter.getTags());
        }
        return tags;
    }

    public CheckersContainer getCheckersContainter() {
        return this.checkersContainers.get(0);
    }

    public void addMessages(String unifiedName, List<CheckerMessage> newMessages) throws Exception {
        this.checkerStatus.put(unifiedName, true);
        for (CheckerMessage msn : newMessages) {
            if (msn.object != null && msn.object instanceof EObject) {
                IMarker marker = msn.file.createMarker("org.eclipse.emf.ecore.diagnostic");
                marker.setAttribute(CHECKER_NAME, (Object)msn.checkerName);
                marker.setAttribute("message", (Object)msn.message);
                String location = EcoreUtil.getURI((EObject)((EObject)msn.object)).toString();
                if (msn.object instanceof NamedElement) {
                    location = ((NamedElement)msn.object).getQualifiedName();
                }
                marker.setAttribute("location", (Object)location);
                marker.setAttribute("severity", msn.severity);
                marker.setAttribute("uri", (Object)EcoreUtil.getURI((EObject)((EObject)msn.object)).toString());
                continue;
            }
            if (msn.object == null || !(msn.object instanceof INode)) continue;
            try {
                INode node = (INode)msn.object;
                if (msn.severity == 0) {
                    ReportProblemsUtil.reportInfo((IResource)msn.file, (String)CHECKER_NAME, (String)msn.checkerName, (String)msn.message, (int)node.getStartLine(), (int)node.getOffset(), (int)node.getEndOffset());
                    continue;
                }
                if (msn.severity == 1) {
                    ReportProblemsUtil.reportWarning((IResource)msn.file, (String)CHECKER_NAME, (String)msn.checkerName, (String)msn.message, (int)node.getStartLine(), (int)node.getOffset(), (int)node.getEndOffset());
                    continue;
                }
                if (msn.severity != 2) continue;
                ReportProblemsUtil.reportError((IResource)msn.file, (String)CHECKER_NAME, (String)msn.checkerName, (String)msn.message, (int)node.getStartLine(), (int)node.getOffset(), (int)node.getEndOffset());
            }
            catch (NullPointerException | CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private Set<IFile> extractIFiles(List<CheckerMessage> checkerMessages) {
        HashSet<IFile> iFiles = new HashSet<IFile>();
        if (checkerMessages != null) {
            for (CheckerMessage checkerMessage : checkerMessages) {
                if (checkerMessage.file == null) continue;
                iFiles.add(checkerMessage.file);
            }
        }
        return iFiles;
    }

    void deleteMarkers(IFile file, String checkerName) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = file.findMarkers("org.eclipse.emf.ecore.diagnostic", false, 1);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker != null && marker.exists() && marker.getAttribute(CHECKER_NAME, "").equals(checkerName)) {
                marker.delete();
            }
            ++n2;
        }
    }

    void deleteProjectMarkers(IProject project, String checkerName) throws CoreException {
        IMarker[] markers;
        IMarker[] iMarkerArray = markers = project.findMarkers(null, false, 2);
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            if (marker != null && marker.exists() && marker.getAttribute(CHECKER_NAME, "").equals(checkerName)) {
                marker.delete();
            }
            ++n2;
        }
    }

    private ModelExplorerPageBookView getModelExplorerPageBookView() {
        IViewPart view;
        IWorkbench workbench = PlatformUI.getWorkbench();
        System.out.println("workbench: " + workbench);
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        System.out.println("window: " + window);
        IWorkbenchPage workbenchPage = window.getActivePage();
        System.out.println("workbenchPage: " + workbenchPage);
        IViewPart modelExplorerViewPart = null;
        IViewPart[] iViewPartArray = workbenchPage.getViews();
        int n = iViewPartArray.length;
        int n2 = 0;
        while (n2 < n) {
            view = iViewPartArray[n2];
            System.out.println("view: " + view.getTitle());
            ++n2;
        }
        try {
            modelExplorerViewPart = window.getActivePage().showView("org.eclipse.papyrus.views.modelexplorer.modelexplorer");
        }
        catch (PartInitException ex) {
            ex.printStackTrace(System.out);
        }
        view = (ModelExplorerPageBookView)modelExplorerViewPart;
        return view;
    }

    private ModelExplorerView getModelExplorerView() {
        ModelExplorerPageBookView view = this.getModelExplorerPageBookView();
        IPage currentPage = view.getCurrentPage();
        ModelExplorerPage page = (ModelExplorerPage)currentPage;
        IViewPart viewer = page.getViewer();
        ModelExplorerView modelExplorerView = (ModelExplorerView)viewer;
        return modelExplorerView;
    }

    public void updateCheckerStatus(String unifiedName, boolean b) {
        this.checkerStatus.put(unifiedName, b);
    }
}

