/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.chessmlprofile.Dependability.FMEA;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum FMEAAnalysisType implements Enumerator
{
    FRAME(0, "frame", "frame"),
    SYSTEM(1, "system", "system");

    public static final int FRAME_VALUE = 0;
    public static final int SYSTEM_VALUE = 1;
    private static final FMEAAnalysisType[] VALUES_ARRAY;
    public static final List<FMEAAnalysisType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new FMEAAnalysisType[]{FRAME, SYSTEM};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static FMEAAnalysisType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FMEAAnalysisType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FMEAAnalysisType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            FMEAAnalysisType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static FMEAAnalysisType get(int value) {
        switch (value) {
            case 0: {
                return FRAME;
            }
            case 1: {
                return SYSTEM;
            }
        }
        return null;
    }

    private FMEAAnalysisType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

