/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.validator.libs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.ClientServerPort;
import org.eclipse.papyrus.MARTE.MARTE_DesignModel.GCM.FlowPort;
import org.eclipse.papyrus.commands.wrappers.EMFtoGMFCommandWrapper;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Realization;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.internal.impl.RealizationImpl;
import org.polarsys.chess.chessmlprofile.Predictability.RTComponentModel.CHRtSpecification;
import org.polarsys.chess.core.util.CHESSProjectSupport;
import org.polarsys.chess.core.util.uml.UMLUtils;
import org.polarsys.chess.core.views.ViewUtils;
import org.polarsys.chess.service.utils.CHESSEditorUtils;
import org.polarsys.chess.validator.automatedActions.IAutomatedAction;
import org.polarsys.chess.validator.managers.AddDiagramElement;
import org.polarsys.chess.validator.messages.Messages;

public class ActionsLib {
    public static IAutomatedAction portModificationAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Port && notification.getEventType() == 22) {
                if (notification.getNewValue() instanceof ClientServerPort) {
                    if (((Port)notifier).getOwner() instanceof Component) {
                        Component comp = (Component)((Port)notifier).getOwner();
                        if (!UMLUtils.isComponentType((Object)comp) || !ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)comp))) {
                            return null;
                        }
                        ClientServerPort port = (ClientServerPort)notification.getNewValue();
                        EList cDependenciesToRemove = UMLUtils.computeDependenciesToRemove((Component)comp);
                        EList cRealizationsToRemove = UMLUtils.computeRealizationsToRemove((Component)comp);
                        CompoundCommand ccc = new CompoundCommand("portAutomations");
                        ccc.append(AddDiagramElement.updateImplementationsPorts(domain, port));
                        ccc.append(AddDiagramElement.destroyDependencies(domain, (EList<? extends Dependency>)cDependenciesToRemove));
                        ccc.append(AddDiagramElement.destroyDependencies(domain, (EList<? extends Dependency>)cRealizationsToRemove));
                        ccc.append(AddDiagramElement.createDependencies(domain, comp, port));
                        return ccc;
                    }
                } else if (notification.getNewValue() instanceof FlowPort && ((Port)notifier).getOwner() instanceof Component) {
                    Component comp = (Component)((Port)notifier).getOwner();
                    if (!UMLUtils.isComponentType((Object)comp) || !ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)comp))) {
                        return null;
                    }
                    FlowPort flPort = (FlowPort)notification.getNewValue();
                    CompoundCommand cc = new CompoundCommand("portAutomations");
                    cc.append(AddDiagramElement.updateImplementationsFlowPorts(domain, flPort));
                    return cc;
                }
            }
            return null;
        }
    };
    public static IAutomatedAction portRemovalAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) {
            Object notifier = notification.getNotifier();
            if ((notifier instanceof ClientServerPort || notifier instanceof FlowPort) && notification.getEventType() == 1 && notification.getFeature() instanceof EReference && ((EReference)notification.getFeature()).getName().equals("base_Port") && notification.getNewValue() == null) {
                Port p = (Port)notification.getOldValue();
                Element el = p.getOwner();
                if (!(el instanceof NamedElement && UMLUtils.isComponentType((Object)((NamedElement)el)) && ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)el)))) {
                    return null;
                }
                Component comp = (Component)el;
                EList cDependenciesToRemove = UMLUtils.computeDependenciesToRemove((Component)comp);
                EList cRealizationsToRemove = UMLUtils.computeRealizationsToRemove((Component)comp);
                CompoundCommand ccc = new CompoundCommand("portAutomations");
                ccc.append(AddDiagramElement.removeImplementationsPorts(domain, p));
                ccc.append(AddDiagramElement.destroyDependencies(domain, (EList<? extends Dependency>)cDependenciesToRemove));
                ccc.append(AddDiagramElement.destroyDependencies(domain, (EList<? extends Dependency>)cRealizationsToRemove));
                return ccc;
            }
            return null;
        }
    };
    public static IAutomatedAction componentInterfaceRealizationAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Component) {
                Component comp = (Component)notifier;
                if (notification.getEventType() == 3 && notification.getNewValue() instanceof InterfaceRealization) {
                    InterfaceRealization link = (InterfaceRealization)notification.getNewValue();
                    Interface contract = link.getContract();
                    if (ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)comp)) && UMLUtils.isComponentType((Object)comp)) {
                        return AddDiagramElement.addOperationCommand(domain, (Classifier)contract, comp);
                    }
                }
            }
            return null;
        }
    };
    public static IAutomatedAction componentRealizationAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) {
            Object notifier = notification.getNotifier();
            Object feature = notification.getFeature();
            if (feature instanceof EReference) {
                EReference ref = (EReference)feature;
                if (notifier instanceof Realization && ref.getName().equals("supplier")) {
                    Realization link = (Realization)notifier;
                    if (link.getClients().size() != 1) {
                        return null;
                    }
                    Component clientComp = (Component)link.getClients().get(0);
                    Object newVal = notification.getNewValue();
                    if (newVal instanceof Component) {
                        Component supplierComp = (Component)newVal;
                        if (!ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)clientComp)) || !UMLUtils.isComponentImplementation((Object)clientComp)) {
                            return null;
                        }
                        CompositeCommand cc = new CompositeCommand("portAndOpCommand");
                        Command cmd = AddDiagramElement.addOperationCommand(domain, (Classifier)supplierComp, clientComp);
                        cc.add((IUndoableOperation)new EMFtoGMFCommandWrapper(cmd));
                        Command cmd2 = AddDiagramElement.addAllPortsCommand(domain, supplierComp, clientComp);
                        cc.add((IUndoableOperation)new EMFtoGMFCommandWrapper(cmd2));
                        if (!cc.isEmpty()) {
                            return new GMFtoEMFCommandWrapper((ICommand)cc);
                        }
                    }
                }
            }
            return null;
        }
    };
    public static IAutomatedAction removeRealizationOperationsAction = new IAutomatedAction(){
        private IStatus operationAborted = new Status(4, "org.polarsys.chess.validator", Messages.operationAborted);

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Component) {
                Component comp = (Component)notifier;
                if (notification.getEventType() == 4 && notification.getOldValue().getClass().equals(RealizationImpl.class) && notification.getFeature() instanceof EReference && ((EReference)notification.getFeature()).getName().equals("clientDependency")) {
                    Package view = ViewUtils.getView((EObject)((Component)notifier));
                    Realization rel = (Realization)notification.getOldValue();
                    if (!ViewUtils.isComponentView((Package)view) || !UMLUtils.isComponentImplementation((Object)comp)) {
                        return null;
                    }
                    PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                    if (editor == null) {
                        return null;
                    }
                    MessageDialog md = CHESSEditorUtils.showConfirmDialog((EditorPart)editor, (String)"Confirm", (String)("Do you want to propagate the removal of the operations of this realization " + rel.getName() + "?"));
                    int result = md.open();
                    if (result == 0) {
                        return this.deleteOperations(comp, view, domain);
                    }
                    if (result == 2) {
                        CHESSProjectSupport.CHESS_CONSOLE.println(this.operationAborted.getMessage());
                    }
                }
            }
            return null;
        }

        private Command deleteOperations(Component component, Package view, TransactionalEditingDomain domain) {
            ICommand deleteCommand;
            DestroyElementRequest request;
            IElementEditService provider;
            CompositeCommand cmd = new CompositeCommand("delOpCommand");
            ArrayList<Operation> opToDel = new ArrayList<Operation>();
            ArrayList behaviorToDel = new ArrayList();
            ArrayList<Port> portToDel = new ArrayList<Port>();
            ArrayList commentToDel = new ArrayList();
            for (Operation op : component.getOwnedOperations()) {
                opToDel.add(op);
                behaviorToDel.addAll(op.getMethods());
            }
            for (Port p : component.getOwnedPorts()) {
                if (!UMLUtils.isClientServerPort((Object)p)) continue;
                portToDel.add(p);
                commentToDel.addAll(UMLUtils.getCHRtSpecificationComments((Package)view, (Port)p));
            }
            behaviorToDel.addAll(component.getOwnedBehaviors());
            DeleteCommand delC = new DeleteCommand((EditingDomain)domain, opToDel);
            cmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)delC));
            if (portToDel.size() > 0) {
                int i = 0;
                while (i < portToDel.size()) {
                    provider = ElementEditServiceUtils.getCommandProvider(portToDel.get(i));
                    if (provider != null) {
                        request = new DestroyElementRequest((EObject)portToDel.get(i), false);
                        deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
                        cmd.add((IUndoableOperation)deleteCommand);
                    }
                    ++i;
                }
            }
            if (commentToDel.size() > 0) {
                int i = 0;
                while (i < commentToDel.size()) {
                    provider = ElementEditServiceUtils.getCommandProvider(commentToDel.get(i));
                    if (provider != null) {
                        request = new DestroyElementRequest((EObject)commentToDel.get(i), false);
                        deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
                        cmd.add((IUndoableOperation)deleteCommand);
                    }
                    ++i;
                }
            }
            if (behaviorToDel.size() > 0) {
                int i = 0;
                while (i < behaviorToDel.size()) {
                    provider = ElementEditServiceUtils.getCommandProvider(behaviorToDel.get(i));
                    if (provider != null) {
                        request = new DestroyElementRequest((EObject)behaviorToDel.get(i), false);
                        deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
                        cmd.add((IUndoableOperation)deleteCommand);
                    }
                    ++i;
                }
            }
            if (!cmd.isEmpty()) {
                return new GMFtoEMFCommandWrapper((ICommand)cmd);
            }
            return null;
        }
    };
    public static IAutomatedAction propagateOperationModification = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Operation && notification.getEventType() == 1) {
                Operation op = (Operation)notifier;
                EObject container = op.eContainer();
                if (!(container instanceof Interface)) {
                    return null;
                }
                if (!ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)container))) {
                    return null;
                }
                EList relationships = UMLUtils.getAllInterfaceComponents((Interface)((Interface)container));
                if (relationships == null || relationships.isEmpty()) {
                    return null;
                }
                CompositeCommand cmd = new CompositeCommand("setCommand");
                for (Component comp : relationships) {
                    this.propagateFeature(notification, domain, op, cmd, comp);
                }
                if (!cmd.isEmpty()) {
                    return new GMFtoEMFCommandWrapper((ICommand)cmd);
                }
            }
            return null;
        }

        private void propagateFeature(Notification notification, TransactionalEditingDomain domain, Operation op, CompositeCommand cmd, Component comp) {
            String opName = op.getName();
            if (notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("name")) {
                opName = (String)notification.getOldValue();
            }
            for (Operation cOperation : comp.getOwnedOperations()) {
                if (!cOperation.getName().equalsIgnoreCase(opName) || !UMLUtils.areParametersEquals((Operation)cOperation, (Operation)op)) continue;
                SetCommand setC = new SetCommand((EditingDomain)domain, (EObject)cOperation, (EStructuralFeature)notification.getFeature(), notification.getNewValue());
                cmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)setC));
            }
        }
    };
    public static IAutomatedAction propagateInterfaceModification = new IAutomatedAction(){
        private IStatus operationAborted = new Status(4, "org.polarsys.chess.validator", Messages.operationAborted);

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Interface) {
                Operation operation;
                Interface interfce = (Interface)notifier;
                if (notification.getEventType() == 3 && notification.getNewValue() instanceof Operation) {
                    operation = (Operation)notification.getNewValue();
                    if (ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)interfce))) {
                        return AddDiagramElement.addOperationCommand1(domain, interfce, operation);
                    }
                }
                if (notification.getEventType() == 4 && notification.getOldValue() instanceof Operation) {
                    operation = (Operation)notification.getOldValue();
                    if (!ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)interfce))) {
                        return null;
                    }
                    PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                    if (editor == null) {
                        return null;
                    }
                    MessageDialog md = CHESSEditorUtils.showConfirmDialog((EditorPart)editor, (String)"Confirm", (String)("Do you want to propagate the removal of " + operation.getName() + " from all the  related model elements?"));
                    int result = md.open();
                    switch (result) {
                        case 0: {
                            ICommand deleteCommand;
                            DestroyElementRequest request;
                            IElementEditService provider;
                            EList relationships = UMLUtils.getAllInterfaceComponents((Interface)interfce);
                            CompositeCommand cmd = new CompositeCommand("delOpCommand");
                            ArrayList<Operation> opToDel = new ArrayList<Operation>();
                            ArrayList behaviorToDel = new ArrayList();
                            for (Component cmp : relationships) {
                                for (Operation op : cmp.getOwnedOperations()) {
                                    if (!UMLUtils.isOperationEquals((Operation)op, (Operation)operation)) continue;
                                    opToDel.add(op);
                                    behaviorToDel.addAll(op.getMethods());
                                }
                            }
                            cmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)new DeleteCommand((EditingDomain)domain, opToDel)));
                            ArrayList<Comment> commentToDel = new ArrayList<Comment>();
                            for (Notification aNotification : notificationList) {
                                if (aNotification.equals(notification) || !(aNotification.getNotifier() instanceof CHRtSpecification) || aNotification.getEventType() != 1 || !(aNotification.getOldValue() instanceof Operation) || !aNotification.getOldValue().equals(operation)) continue;
                                commentToDel.add(((CHRtSpecification)aNotification.getNotifier()).getBase_Comment());
                            }
                            if (!commentToDel.isEmpty()) {
                                for (Comment comment : commentToDel) {
                                    provider = ElementEditServiceUtils.getCommandProvider((Object)comment);
                                    if (provider == null) continue;
                                    request = new DestroyElementRequest((EObject)comment, false);
                                    deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
                                    cmd.add((IUndoableOperation)deleteCommand);
                                }
                            }
                            if (!behaviorToDel.isEmpty()) {
                                for (Behavior behavior : behaviorToDel) {
                                    provider = ElementEditServiceUtils.getCommandProvider((Object)behavior);
                                    if (provider == null) continue;
                                    request = new DestroyElementRequest((EObject)behavior, false);
                                    deleteCommand = provider.getEditCommand((IEditCommandRequest)request);
                                    cmd.add((IUndoableOperation)deleteCommand);
                                }
                            }
                            if (cmd.isEmpty()) break;
                            return new GMFtoEMFCommandWrapper((ICommand)cmd);
                        }
                        case 2: {
                            CHESSProjectSupport.CHESS_CONSOLE.println(this.operationAborted.getMessage());
                            throw new RollbackException(this.operationAborted);
                        }
                    }
                }
            }
            return null;
        }
    };
    public static IAutomatedAction propagateParameterRemovalAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Operation) {
                if (notification.getEventType() == 4 && notification.getOldValue() instanceof Parameter) {
                    Parameter param = (Parameter)notification.getOldValue();
                    Operation operation = (Operation)notifier;
                    CompositeCommand cmd = new CompositeCommand("delCommand");
                    EObject opCont = operation.eContainer();
                    if (!(opCont instanceof Interface) || !ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)opCont))) {
                        return null;
                    }
                    EList relationships = UMLUtils.getAllInterfaceComponents((Interface)((Interface)opCont));
                    if (relationships == null || relationships.isEmpty()) {
                        return null;
                    }
                    block0: for (Component comp : relationships) {
                        for (Operation op : comp.getOwnedOperations()) {
                            if (!UMLUtils.areOperationsEqual((Operation)op, (Operation)operation, (Parameter)param)) continue;
                            for (Parameter p : op.getOwnedParameters()) {
                                if (!UMLUtils.areParametersEqual((Parameter)p, (Parameter)param)) continue;
                                cmd.add((IUndoableOperation)new DestroyElementCommand(new DestroyElementRequest((EObject)p, false)));
                                continue block0;
                            }
                        }
                    }
                    if (!cmd.isEmpty()) {
                        return new GMFtoEMFCommandWrapper((ICommand)cmd);
                    }
                }
                if (notification.getEventType() == 6 && notification.getOldValue() instanceof EList) {
                    EList paramList = (EList)notification.getOldValue();
                    for (Object ob : paramList) {
                        if (!(ob instanceof Parameter)) continue;
                        Parameter param = (Parameter)ob;
                        Operation operation = (Operation)notifier;
                        CompositeCommand cmd = new CompositeCommand("delCommand");
                        EObject opCont = operation.eContainer();
                        if (!(opCont instanceof Interface) || !ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)opCont))) {
                            return null;
                        }
                        EList relationships = UMLUtils.getAllInterfaceComponents((Interface)((Interface)opCont));
                        block4: for (Component comp : relationships) {
                            for (Operation op : comp.getOwnedOperations()) {
                                if (!UMLUtils.areOperationsEqual((Operation)op, (Operation)operation, (Parameter)param)) continue;
                                for (Parameter p : op.getOwnedParameters()) {
                                    if (!UMLUtils.areParametersEqual((Parameter)p, (Parameter)param)) continue;
                                    cmd.add((IUndoableOperation)new DestroyElementCommand(new DestroyElementRequest((EObject)p, false)));
                                    continue block4;
                                }
                            }
                        }
                        if (cmd.isEmpty()) continue;
                        return new GMFtoEMFCommandWrapper((ICommand)cmd);
                    }
                }
            }
            return null;
        }
    };
    public static IAutomatedAction propagateParameterAdditionAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Operation) {
                Parameter param;
                Operation operation;
                EObject opCont;
                if (notification.getEventType() == 3 && notification.getNewValue() instanceof Parameter && (opCont = (operation = (param = (Parameter)notification.getNewValue()).getOperation()).eContainer()) instanceof Interface && ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)opCont))) {
                    return AddDiagramElement.addParameterCommand((Interface)opCont, param, operation, domain);
                }
                if (notification.getEventType() == 5 && notification.getNewValue() instanceof EList) {
                    EList paramList = (EList)notification.getNewValue();
                    boolean test = true;
                    opCont = null;
                    Operation operation2 = null;
                    for (Object ob : paramList) {
                        if (!(ob instanceof Parameter)) {
                            test = false;
                            break;
                        }
                        Parameter par = (Parameter)ob;
                        operation2 = par.getOperation();
                        opCont = operation2.eContainer();
                        if (opCont instanceof Interface && ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)opCont))) continue;
                        test = false;
                        break;
                    }
                    if (test) {
                        Parameter param2 = (Parameter)paramList.get(paramList.size() - 1);
                        return AddDiagramElement.addParameterCommand((Interface)opCont, param2, operation2, domain);
                    }
                }
            }
            return null;
        }
    };
    public static IAutomatedAction commentAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            if (notification.getNotifier() instanceof Comment) {
                Comment comment = (Comment)notification.getNotifier();
                if (notification.getEventType() == 20) {
                    return AddDiagramElement.addCommentCommand(domain, comment);
                }
                if (notification.getEventType() == 21) {
                    return AddDiagramElement.removeCommentCommand(domain, comment);
                }
            }
            return null;
        }
    };
    public static IAutomatedAction portAdditionAction = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            if (notification.getNotifier() instanceof Port && notification.getEventType() == 1 && notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("visibility")) {
                Port port = (Port)notification.getNotifier();
                Element supplierComp = port.getOwner();
                if (!UMLUtils.isClientServerPort((Object)port) || !UMLUtils.isComponentType((Object)supplierComp)) {
                    return null;
                }
                CompositeCommand cc = new CompositeCommand("portAndOpCommand");
                for (Component cImpl : UMLUtils.getComponentImplementations((Component)((Component)supplierComp))) {
                    Command cmd2 = AddDiagramElement.addPortCommand(domain, (Component)supplierComp, cImpl, port);
                    cc.add((IUndoableOperation)new EMFtoGMFCommandWrapper(cmd2));
                }
                if (!cc.isEmpty()) {
                    return new GMFtoEMFCommandWrapper((ICommand)cc);
                }
            }
            return null;
        }
    };
    public static IAutomatedAction propagatePortModification = new IAutomatedAction(){

        @Override
        public Command compile(Notification notification, List<Notification> notificationList, TransactionalEditingDomain domain) throws RollbackException {
            Object notifier = notification.getNotifier();
            if (notifier instanceof Port && notification.getEventType() == 1) {
                if (notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("name") && notification.getNewValue().equals("Port0")) {
                    return null;
                }
                Port port = (Port)notifier;
                EObject container = port.eContainer();
                if (!(container instanceof Component)) {
                    return null;
                }
                if (!ViewUtils.isComponentView((Package)ViewUtils.getView((EObject)container)) || !UMLUtils.isComponentType((Object)container)) {
                    return null;
                }
                EList relationships = UMLUtils.getComponentImplementations((Component)((Component)container));
                if (relationships == null || relationships.isEmpty()) {
                    return null;
                }
                CompositeCommand cmd = new CompositeCommand("setCommand");
                for (Component comp : relationships) {
                    this.propagateFeature(notification, domain, port, cmd, comp);
                }
                if (!cmd.isEmpty()) {
                    return new GMFtoEMFCommandWrapper((ICommand)cmd);
                }
            }
            return null;
        }

        private void propagateFeature(Notification notification, TransactionalEditingDomain domain, Port port, CompositeCommand cmd, Component comp) {
            Port portComp;
            String opName = port.getName();
            if (notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("name")) {
                opName = (String)notification.getOldValue();
            }
            Type portType = port.getType();
            if (notification.getFeature() instanceof EAttribute && ((EAttribute)notification.getFeature()).getName().equals("type")) {
                portType = (Type)notification.getOldValue();
            }
            if ((portComp = comp.getOwnedPort(opName, portType)) == null) {
                return;
            }
            SetCommand setC = new SetCommand((EditingDomain)domain, (EObject)portComp, (EStructuralFeature)notification.getFeature(), notification.getNewValue());
            cmd.add((IUndoableOperation)new EMFtoGMFCommandWrapper((Command)setC));
        }
    };
    public static IAutomatedAction[] actionList = new IAutomatedAction[]{portModificationAction, componentInterfaceRealizationAction, componentRealizationAction, commentAction};
}

