/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.tabbedproperties.sections;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.editor.PapyrusMultiDiagramEditor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.uml.diagram.composite.edit.parts.CompositeStructureDiagramEditPart;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.Component;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;
import org.polarsys.chess.core.profiles.MARTEProfileManager;
import org.polarsys.chess.service.utils.CHESSEditorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortsProperty
extends AbstractPropertySection {
    private static final String FLOWPORT = "MARTE::MARTE_DesignModel::GCM::FlowPort";
    private static final String CSPORT = "MARTE::MARTE_DesignModel::GCM::ClientServerPort";
    private static final String ALLOCATE = "MARTE::MARTE_Foundations::Alloc::Allocate";
    private Label msgLabel;
    private Text portText;
    private CCombo opCombo;
    private CCombo paramCombo;
    private org.eclipse.swt.widgets.List mapList;
    private Port port;
    private Component comp;
    private Operation op;
    private Parameter param;
    private ModifyListener modOpListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String opName = PortsProperty.this.opCombo.getText();
            if (PortsProperty.this.comp != null) {
                PortsProperty.this.paramCombo.removeAll();
                EList opList = PortsProperty.this.getInterfaceOperations(PortsProperty.this.comp);
                for (Operation operation : opList) {
                    if (!operation.getName().equals(opName)) continue;
                    PortsProperty.this.op = operation;
                    break;
                }
                if (PortsProperty.this.op != null) {
                    Type portType = PortsProperty.this.port.getType();
                    String portDirection = PortsProperty.this.port.getValue(PortsProperty.this.port.getAppliedStereotype(PortsProperty.FLOWPORT), "direction").toString();
                    boolean provided = false;
                    for (Operation operation : PortsProperty.this.comp.getAllOperations()) {
                        if (!operation.getName().equals(PortsProperty.this.op.getName())) continue;
                        provided = true;
                        break;
                    }
                    EList paramList = PortsProperty.this.op.getOwnedParameters();
                    for (Parameter param : paramList) {
                        if (!param.getType().equals(portType)) continue;
                        String paramDirection = param.getDirection().toString();
                        if (provided) {
                            if (!paramDirection.equals(portDirection) && !portDirection.equals("inout") && !paramDirection.equals("inout")) continue;
                            PortsProperty.this.paramCombo.add(param.getName());
                            continue;
                        }
                        if (portDirection.equals("inout") || paramDirection.equals("inout")) {
                            PortsProperty.this.paramCombo.add(param.getName());
                            continue;
                        }
                        if (paramDirection.equals("out") && portDirection.equals("in")) {
                            PortsProperty.this.paramCombo.add(param.getName());
                            continue;
                        }
                        if (!paramDirection.equals("in") || !portDirection.equals("out")) continue;
                        PortsProperty.this.paramCombo.add(param.getName());
                    }
                }
            }
        }
    };
    private ModifyListener modParamListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            String paramName = PortsProperty.this.paramCombo.getText();
            if (PortsProperty.this.comp != null && PortsProperty.this.op != null) {
                PortsProperty.this.param = PortsProperty.this.op.getOwnedParameter(paramName, null);
            }
        }
    };
    private SelectionListener selListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            Object temp;
            if (PortsProperty.this.comp != null && PortsProperty.this.port != null && PortsProperty.this.op != null && PortsProperty.this.param != null) {
                PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
                if (editor == null) {
                    PortsProperty.this.printErrMsg("please open the model in the CHESS editor");
                    return;
                }
                temp = CHESSEditorUtils.getDiagramGraphicalViewer().getRootEditPart().getChildren().get(0);
                if (temp == null || !(temp instanceof CompositeStructureDiagramEditPart)) {
                    PortsProperty.this.printErrMsg("please perform the operation in a Composite Structure Diagram");
                    return;
                }
            } else {
                PortsProperty.this.printErrMsg("please select Port, Operation and Parameter");
                return;
            }
            CompositeStructureDiagramEditPart csd = (CompositeStructureDiagramEditPart)temp;
            TransactionalEditingDomain editingDomain = csd.getEditingDomain();
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    Package owningPkg = (Package)PortsProperty.this.port.allOwningPackages().get(0);
                    EList pkgElments = owningPkg.getPackagedElements();
                    for (PackageableElement pkgElement : pkgElments) {
                        Abstraction abs;
                        if (!(pkgElement instanceof Abstraction) || !(abs = (Abstraction)pkgElement).getClients().contains((Object)PortsProperty.this.port) || !abs.getSuppliers().contains((Object)PortsProperty.this.param)) continue;
                        Display display = Display.getCurrent();
                        PortsProperty.this.msgLabel.setForeground(display.getSystemColor(8));
                        PortsProperty.this.msgLabel.setText("mapping already exists!");
                        return;
                    }
                    Abstraction abs = UMLFactory.eINSTANCE.createAbstraction();
                    abs.getClients().add((Object)PortsProperty.this.port);
                    abs.getSuppliers().add((Object)PortsProperty.this.param);
                    abs.setName("map " + PortsProperty.this.port.getName() + " to " + PortsProperty.this.param.getOperation().getName() + "." + PortsProperty.this.param.getName());
                    owningPkg.getPackagedElements().add((Object)abs);
                    MARTEProfileManager.applyStereotypeTo((String)"allocate", (Element)abs);
                    Display display = Display.getCurrent();
                    PortsProperty.this.msgLabel.setForeground(display.getSystemColor(9));
                    PortsProperty.this.msgLabel.setText("mapping created!");
                    PortsProperty.this.mapList.add(abs.getName());
                    PortsProperty.this.mapList.update();
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    private SelectionListener remMapListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            int index = PortsProperty.this.mapList.getSelectionIndex();
            if (index < 0) {
                PortsProperty.this.printErrMsg("please select a mapping from the list below");
                return;
            }
            final String selected = PortsProperty.this.mapList.getItem(index);
            PapyrusMultiDiagramEditor editor = CHESSEditorUtils.getCHESSEditor();
            if (editor == null) {
                PortsProperty.this.printErrMsg("please open the model in the CHESS editor");
                return;
            }
            Object temp = CHESSEditorUtils.getDiagramGraphicalViewer().getRootEditPart().getChildren().get(0);
            if (temp == null || !(temp instanceof CompositeStructureDiagramEditPart)) {
                PortsProperty.this.printErrMsg("please perform the operation in a Composite Structure Diagram");
                return;
            }
            CompositeStructureDiagramEditPart csd = (CompositeStructureDiagramEditPart)temp;
            TransactionalEditingDomain editingDomain = csd.getEditingDomain();
            editingDomain.getCommandStack().execute((Command)new RecordingCommand(editingDomain){

                protected void doExecute() {
                    Package owningPkg = PortsProperty.this.port.getNearestPackage();
                    Abstraction abs = (Abstraction)owningPkg.getPackagedElement(selected);
                    abs.unapplyStereotype(abs.getAppliedStereotype(PortsProperty.ALLOCATE));
                    owningPkg.getPackagedElements().remove((Object)abs);
                    abs.destroy();
                    PortsProperty.this.mapList.remove(selected);
                    PortsProperty.this.mapList.update();
                    Display display = Display.getCurrent();
                    PortsProperty.this.msgLabel.setForeground(display.getSystemColor(9));
                    PortsProperty.this.msgLabel.setText("mapping removed!");
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    private void printErrMsg(String msg) {
        Display display = Display.getCurrent();
        this.msgLabel.setForeground(display.getSystemColor(3));
        this.msgLabel.setText(msg);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, true);
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        this.portText = this.getWidgetFactory().createText(composite, "no flowport selected");
        this.portText.setEditable(false);
        this.portText.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        Label portLabel = this.getWidgetFactory().createLabel(composite, "selected flow port", 0);
        portLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        this.opCombo = this.getWidgetFactory().createCCombo(composite);
        this.opCombo.addModifyListener(this.modOpListener);
        this.opCombo.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        Label opLabel = this.getWidgetFactory().createLabel(composite, "select operation", 0);
        opLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        gd.horizontalSpan = 2;
        this.paramCombo = this.getWidgetFactory().createCCombo(composite);
        this.paramCombo.addModifyListener(this.modParamListener);
        this.paramCombo.setLayoutData((Object)gd);
        gd = new GridData(4, 4, false, false);
        Label paramLabel = this.getWidgetFactory().createLabel(composite, "select parameter", 0);
        paramLabel.setLayoutData((Object)gd);
        gd = new GridData(1, 4, false, false);
        Button mapButton = this.getWidgetFactory().createButton(composite, "Create Mapping", 8);
        mapButton.addSelectionListener(this.selListener);
        mapButton.setLayoutData((Object)gd);
        gd = new GridData(1, 4, false, false);
        Button removeMapButton = this.getWidgetFactory().createButton(composite, "Remove Mapping", 8);
        removeMapButton.addSelectionListener(this.remMapListener);
        removeMapButton.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, false);
        this.msgLabel = this.getWidgetFactory().createLabel(composite, "", 0);
        this.msgLabel.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        gd.horizontalSpan = 3;
        this.mapList = this.getWidgetFactory().createList(composite, 2560);
        this.mapList.setLayoutData((Object)gd);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.mapList.removeAll();
        this.msgLabel.setText("");
        this.port = this.getPortFromSelection(this.getSelection());
        if (this.port != null) {
            this.portText.setText(this.port.getName());
            this.comp = (Component)this.port.getFeaturingClassifiers().get(0);
            if (this.comp != null) {
                this.opCombo.removeAll();
                this.paramCombo.removeAll();
                EList<Operation> opList = this.getInterfaceOperations(this.comp);
                for (Operation operation : opList) {
                    this.opCombo.add(operation.getName());
                }
            }
            EList dependencies = this.port.getClientDependencies();
            for (Dependency dep : dependencies) {
                if (!(dep instanceof Abstraction) || dep.getAppliedStereotype(ALLOCATE) == null) continue;
                this.mapList.add(dep.getName());
            }
        } else {
            this.portText.setText("no flow port selected");
            this.comp = null;
            this.op = null;
            this.opCombo.removeAll();
            this.paramCombo.removeAll();
            this.mapList.removeAll();
        }
    }

    private EList<Operation> getInterfaceOperations(Component comp) {
        BasicEList ops = new BasicEList();
        EList compAttrs = comp.getAllAttributes();
        for (Property prop : compAttrs) {
            Stereotype stereo = prop.getAppliedStereotype(CSPORT);
            if (!(prop instanceof Port) || stereo == null) continue;
            Port csport = (Port)prop;
            EList provIfs = (EList)csport.getValue(stereo, "provInterface");
            EList reqIfs = (EList)csport.getValue(stereo, "reqInterface");
            BasicEList result = new BasicEList();
            result.addAll((Collection)provIfs);
            result.addAll((Collection)reqIfs);
            for (Interface interf : result) {
                ops.addAll((Collection)interf.getAllOperations());
            }
        }
        return ops;
    }

    public void refresh() {
        super.refresh();
    }

    private Port getPortFromSelection(ISelection selection) {
        Object selected;
        EObject selectedEObject;
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        List selectionList = ((IStructuredSelection)selection).toList();
        if (selectionList.size() == 1 && (selectedEObject = EMFHelper.getEObject(selected = selectionList.get(0))) instanceof Port) {
            Port port = (Port)selectedEObject;
            port.getAppliedStereotypes();
            if (port.getAppliedStereotype(FLOWPORT) != null) {
                return port;
            }
        }
        return null;
    }
}

