/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.chess.contracts.chessextension.popup.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.sysml.diagram.common.edit.part.ConstraintPropertyChildLabelEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PropertyForClassEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.PropertyForComponentEditPart;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLFactory;
import org.polarsys.chess.contracts.chessextension.dialogs.SetContractRefinementDialog;
import org.polarsys.chess.contracts.chessextension.managers.CHESSContractProfileManager;
import org.polarsys.chess.contracts.profile.chesscontract.ContractProperty;
import org.polarsys.chess.contracts.profile.chesscontract.ContractRefinement;

public class SetContractRefinement
implements IObjectActionDelegate {
    public static final String CONTRACT_PROPERTY = "CHESSContract::ContractProperty";
    protected static final String CONTRACT_REFINEMENt = "CHESSContract::ContractRefinement";
    public static final String COMPONENT_INSTANCE = "CHESSContract::ComponentInstance";
    private Shell shell;
    private ConstraintPropertyChildLabelEditPart sysmlEditPart;
    private PropertyForClassEditPart umlClassEditPart;
    private PropertyForComponentEditPart umlCompEditPart;
    private TransactionalEditingDomain editdomain;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.shell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        Stereotype contrPropStereo;
        Object temp;
        Node notationNode;
        this.setSelection();
        Property contrProp = null;
        if (this.sysmlEditPart != null) {
            notationNode = (Node)this.sysmlEditPart.getModel();
            contrProp = (Property)notationNode.getElement();
            this.editdomain = this.sysmlEditPart.getEditingDomain();
        } else if (this.umlClassEditPart != null) {
            notationNode = (Node)this.umlClassEditPart.getModel();
            contrProp = (Property)notationNode.getElement();
            this.editdomain = this.umlClassEditPart.getEditingDomain();
        } else if (this.umlCompEditPart != null) {
            notationNode = (Node)this.umlCompEditPart.getModel();
            contrProp = (Property)notationNode.getElement();
            this.editdomain = this.umlCompEditPart.getEditingDomain();
        }
        if (contrProp != null && (temp = contrProp.getValue(contrPropStereo = contrProp.getAppliedStereotype(CONTRACT_PROPERTY), "RefinedBy")) instanceof EList) {
            final EList refineList = (EList)temp;
            final Class ownerClass = (Class)contrProp.getOwner();
            SetContractRefinementDialog dialog = new SetContractRefinementDialog(this.shell, ownerClass);
            dialog.create();
            if (dialog.open() == 0 && dialog.getSelected() != null) {
                final String[] selection = dialog.getSelected();
                this.editdomain.getCommandStack().execute((Command)new RecordingCommand(this.editdomain){

                    protected void doExecute() {
                        int i = 0;
                        while (i < selection.length) {
                            String stringRef = selection[i];
                            Classifier present = ownerClass.getNestedClassifier(stringRef);
                            if (present == null) {
                                DataType dt = UMLFactory.eINSTANCE.createDataType();
                                ownerClass.getNestedClassifiers().add((Object)dt);
                                dt.setName(stringRef);
                                Stereotype st = CHESSContractProfileManager.getContractRefinement();
                                dt.applyStereotype(st);
                                String partName = stringRef.substring(0, stringRef.indexOf("."));
                                String contrName = stringRef.substring(stringRef.indexOf(".") + 1, stringRef.length());
                                ContractRefinement contRef = (ContractRefinement)dt.getStereotypeApplication(st);
                                Property instance = ownerClass.getPart(partName, null);
                                contRef.setInstance(instance);
                                Property contrProp = ((Classifier)instance.getType()).getAttribute(contrName, null);
                                ContractProperty contract = (ContractProperty)contrProp.getStereotypeApplication(contrProp.getAppliedStereotype(SetContractRefinement.CONTRACT_PROPERTY));
                                contRef.setContract(contract);
                                refineList.add((Object)contRef);
                            } else {
                                ContractRefinement cr = (ContractRefinement)present.getStereotypeApplication(present.getAppliedStereotype(SetContractRefinement.CONTRACT_REFINEMENt));
                                refineList.add((Object)cr);
                            }
                            ++i;
                        }
                    }
                });
            }
        }
    }

    private void setSelection() {
        IStructuredSelection strucSelection;
        ISelection selection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection && (strucSelection = (IStructuredSelection)selection).size() == 1) {
            Object partSelected = strucSelection.iterator().next();
            if (partSelected instanceof ConstraintPropertyChildLabelEditPart) {
                this.sysmlEditPart = (ConstraintPropertyChildLabelEditPart)partSelected;
            } else if (partSelected instanceof PropertyForClassEditPart) {
                this.umlClassEditPart = (PropertyForClassEditPart)partSelected;
            } else if (partSelected instanceof PropertyForComponentEditPart) {
                this.umlCompEditPart = (PropertyForComponentEditPart)partSelected;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

