/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.markup;

import com.google.inject.Injector;
import java.io.StringReader;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.examples.pivot.manager.MetaModelManager;
import org.eclipse.ocl.examples.xtext.markup.Markup;
import org.eclipse.ocl.examples.xtext.markup.MarkupStandaloneSetup;
import org.eclipse.ocl.examples.xtext.markup.MarkupToHTML;
import org.eclipse.ocl.examples.xtext.markup.NewLineElement;
import org.eclipse.ocl.examples.xtext.markup.parser.antlr.MarkupParser;
import org.eclipse.ocl.examples.xtext.markup.util.MarkupSwitch;
import org.eclipse.xtext.parser.IParseResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarkupUtils
extends MarkupSwitch<StringBuilder> {
    @Nullable
    public static IParseResult decode(@NonNull String text) {
        Injector injector = MarkupStandaloneSetup.getInjector();
        MarkupParser parser = (MarkupParser)((Object)injector.getInstance(MarkupParser.class));
        StringReader reader = new StringReader(text);
        return parser.parse(reader);
    }

    public static int getNewlineCount(@NonNull NewLineElement element) {
        int lineCount = 0;
        String s = element.getText();
        int iMax = s.length();
        int i = 0;
        while (i < iMax) {
            char c;
            if ((c = s.charAt(i++)) == '\n') {
                ++lineCount;
                if (i >= iMax || (c = s.charAt(i)) != '\r') continue;
                ++i;
                continue;
            }
            if (c != '\r') continue;
            ++lineCount;
            if (i >= iMax || (c = s.charAt(i)) != '\n') continue;
            ++i;
        }
        return lineCount;
    }

    public static String toHTML(@NonNull MetaModelManager metaModelManager, @NonNull Object context, @NonNull Markup markup) throws Exception {
        return MarkupToHTML.toString(metaModelManager, context, markup);
    }
}

