/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.customization.factory;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.customization.Activator;
import org.eclipse.papyrus.customization.factory.FileBasedExtensionFactory;
import org.eclipse.papyrus.customization.messages.Messages;
import org.eclipse.papyrus.customization.model.customizationplugin.CustomizableElement;
import org.eclipse.papyrus.customization.model.customizationplugin.CustomizationPluginPackage;
import org.eclipse.papyrus.customization.model.customizationplugin.FileBasedCustomizableElement;
import org.eclipse.papyrus.customization.plugin.PluginEditor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.widgets.util.FileUtil;
import org.eclipse.papyrus.views.properties.contexts.Context;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Element;

public class PropertyViewExtensionFactory
extends FileBasedExtensionFactory {
    protected IStatus result;

    public PropertyViewExtensionFactory() {
        super(Messages.PropertyViewExtensionFactory_PropertyView, "org.eclipse.papyrus.views.properties.context", "contextModel", "context", true);
    }

    public void addElement(CustomizableElement element, PluginEditor editor) {
        super.addElement(element, editor);
        editor.getManifestEditor().addDependency("org.eclipse.papyrus.views.properties");
    }

    protected Element createExtension(FileBasedCustomizableElement element, PluginEditor editor) {
        Element extension = super.createExtension(element, editor);
        return extension;
    }

    protected void copyFile(FileBasedCustomizableElement element, PluginEditor editor) {
        block6: {
            String path = element.getFile();
            File sourceFile = FileUtil.getFile((String)path);
            URI uri = URI.createFileURI((String)sourceFile.getAbsolutePath());
            File targetFile = FileUtil.getWorkspaceFile((String)("/" + editor.getProject().getName() + "/" + this.getTargetPath(element)));
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            try {
                try {
                    EObject propertyViewModel = EMFHelper.loadEMFModel((ResourceSet)resourceSet, (URI)uri);
                    this.copyAll((Context)propertyViewModel, targetFile);
                }
                catch (IOException ex) {
                    Activator.log.error((Throwable)ex);
                    EMFHelper.unload((ResourceSet)resourceSet);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                EMFHelper.unload((ResourceSet)resourceSet);
                throw throwable;
            }
            EMFHelper.unload((ResourceSet)resourceSet);
        }
        editor.getBuildEditor().addToBuild("propertyView/");
    }

    private void copyAll(final Context source, final File target) {
        final File targetDirectory = target.getParentFile();
        final String targetName = target.getName();
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
        try {
            dialog.run(true, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    monitor.beginTask(String.valueOf(Messages.PropertyViewExtensionFactory_InitializingCopy) + source.getName() + Messages.PropertyViewExtensionFactory_WaitMessage, -1);
                    EcoreUtil.resolveAll((EObject)source);
                    monitor.done();
                    PropertyViewExtensionFactory.this.result = Status.OK_STATUS;
                }
            });
            dialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            if (this.result.getCode() == 0) {
                dialog.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        try {
                            targetDirectory.mkdirs();
                            monitor.beginTask(String.valueOf(Messages.PropertyViewExtensionFactory_Copying) + source.getName() + Messages.PropertyViewExtensionFactory_To + targetName, source.eResource().getResourceSet().getResources().size());
                            PropertyViewExtensionFactory.this.copy(source.eResource(), target);
                            monitor.worked(1);
                            for (Resource resource : source.eResource().getResourceSet().getResources()) {
                                if (monitor.isCanceled()) {
                                    return;
                                }
                                if (source.eResource() != resource && PropertyViewExtensionFactory.this.isRelative((EObject)source, resource)) {
                                    PropertyViewExtensionFactory.this.copy(resource, targetDirectory, (EObject)source, targetName);
                                }
                                monitor.worked(1);
                            }
                            monitor.done();
                        }
                        catch (IOException ex) {
                            Activator.log.error((Throwable)ex);
                            PropertyViewExtensionFactory.this.result = new Status(4, "org.eclipse.papyrus.customization", "An error occured during the copy of " + source.getName(), (Throwable)ex);
                            return;
                        }
                        PropertyViewExtensionFactory.this.result = Status.OK_STATUS;
                    }
                });
            }
        }
        catch (InvocationTargetException ex) {
            Activator.log.error((Throwable)ex);
        }
        catch (InterruptedException ex) {
            Activator.log.error((Throwable)ex);
        }
    }

    private boolean isRelative(EObject source, Resource resource) {
        URI baseURI = source.eResource().getURI();
        URI resourceURI = resource.getURI();
        URI uri = resourceURI.deresolve(baseURI);
        return uri.isRelative() && !uri.toString().startsWith("..") && !uri.toString().startsWith("/");
    }

    protected void copy(Resource resource, File directory, EObject source, String targetName) throws IOException {
        URI relativeURI = resource.getURI().deresolve(source.eResource().getURI());
        if (relativeURI.toString().equals("")) {
            relativeURI = URI.createURI((String)(String.valueOf(targetName) + ".ctx"));
        }
        File target = new File(directory, relativeURI.toString());
        this.copy(resource, target);
    }

    protected void copy(Resource resource, File target) throws IOException {
        this.copy(new URL(resource.getURI().toString()).openStream(), target);
    }

    protected String getTargetPath(FileBasedCustomizableElement element) {
        String fileName = this.getFileName(element);
        if (fileName.indexOf(".") > -1) {
            String simpleName = fileName.substring(0, fileName.lastIndexOf("."));
            return "/propertyView/" + simpleName + "/" + fileName;
        }
        return fileName;
    }

    public EClass getCustomizableElementClass() {
        return CustomizationPluginPackage.eINSTANCE.getPropertyView();
    }
}

