/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.validation.description.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.sirius.diagram.description.ConditionalContainerStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalEdgeStyleDescription;
import org.eclipse.sirius.diagram.description.ConditionalNodeStyleDescription;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.util.DescriptionSwitch;

public class ValidStyleConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        IStatus constraintStatus = null;
        constraintStatus = ElementMappingSwitch.INSTANCE.doSwitch(eObj, ctx);
        return constraintStatus != null ? constraintStatus : ctx.createSuccessStatus();
    }

    private static class ElementMappingSwitch
    extends DescriptionSwitch<Object> {
        public static final ElementMappingSwitch INSTANCE = new ElementMappingSwitch();
        private static final String MESSAGE_CONDITION = "Conditional style ";
        private static final String OF = " of ";

        private ElementMappingSwitch() {
        }

        public IStatus doSwitch(EObject object, IValidationContext ctx) {
            return this.doSwitch(object.eClass(), object, ctx);
        }

        protected IStatus doSwitch(EClass theEClass, EObject theEObject, IValidationContext ctx) {
            if (theEClass.eContainer() == modelPackage) {
                return this.doSwitch(theEClass.getClassifierID(), theEObject, ctx);
            }
            EList eSuperTypes = theEClass.getESuperTypes();
            return eSuperTypes.isEmpty() ? (ConstraintStatus)this.defaultCase(theEObject) : this.doSwitch((EClass)eSuperTypes.get(0), theEObject, ctx);
        }

        protected IStatus doSwitch(int classifierID, EObject object, IValidationContext ctx) {
            ConstraintStatus constraint = null;
            switch (classifierID) {
                case 5: {
                    constraint = this.caseNodeMapping((NodeMapping)object, ctx);
                    break;
                }
                case 6: {
                    constraint = this.caseContainerMapping((ContainerMapping)object, ctx);
                    break;
                }
                case 9: {
                    constraint = this.caseEdgeMapping((EdgeMapping)object, ctx);
                    break;
                }
                case 12: {
                    constraint = this.caseConditionalNodeStyleDescription((ConditionalNodeStyleDescription)object, ctx);
                    break;
                }
                case 13: {
                    constraint = this.caseConditionalEdgeStyleDescription((ConditionalEdgeStyleDescription)object, ctx);
                    break;
                }
                case 14: {
                    constraint = this.caseConditionalContainerStyleDescription((ConditionalContainerStyleDescription)object, ctx);
                    break;
                }
                default: {
                    constraint = (ConstraintStatus)this.defaultCase(object);
                }
            }
            return constraint;
        }

        private IStatus caseNodeMapping(NodeMapping object, IValidationContext ctx) {
            if (object.getStyle() == null) {
                return ctx.createFailureStatus(new Object[]{object.getName()});
            }
            return null;
        }

        private IStatus caseEdgeMapping(EdgeMapping object, IValidationContext ctx) {
            if (object.getStyle() == null) {
                return ctx.createFailureStatus(new Object[]{object.getName()});
            }
            return null;
        }

        private IStatus caseContainerMapping(ContainerMapping object, IValidationContext ctx) {
            if (object.getStyle() == null) {
                return ctx.createFailureStatus(new Object[]{object.getName()});
            }
            return null;
        }

        public IStatus caseConditionalEdgeStyleDescription(ConditionalEdgeStyleDescription object, IValidationContext ctx) {
            if (object.getStyle() == null) {
                return ctx.createFailureStatus(new Object[]{MESSAGE_CONDITION + object.getPredicateExpression() + OF + ((EdgeMapping)object.eContainer()).getName()});
            }
            return null;
        }

        private IStatus caseConditionalNodeStyleDescription(ConditionalNodeStyleDescription object, IValidationContext ctx) {
            if (object.getStyle() == null) {
                return ctx.createFailureStatus(new Object[]{MESSAGE_CONDITION + object.getPredicateExpression() + OF + ((NodeMapping)object.eContainer()).getName()});
            }
            return null;
        }

        private IStatus caseConditionalContainerStyleDescription(ConditionalContainerStyleDescription object, IValidationContext ctx) {
            if (object.getStyle() == null) {
                return ctx.createFailureStatus(new Object[]{MESSAGE_CONDITION + object.getPredicateExpression() + OF + ((ContainerMapping)object.eContainer()).getName()});
            }
            return null;
        }
    }
}

