/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.tools.internal.command.builders;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.FeatureNotFoundException;
import org.eclipse.sirius.ecore.extender.business.api.accessor.exception.MetaClassNotFoundException;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.tools.internal.command.builders.AbstractCommandBuilder;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;

public abstract class AbstractDiagramCommandBuilder
extends AbstractCommandBuilder {
    protected boolean checkPrecondition(DDiagram diagram, AbstractToolDescription abstractToolDescription) {
        return this.genericCheckPrecondition(diagram, abstractToolDescription);
    }

    protected boolean checkPrecondition(DDiagramElement diagramElement, AbstractToolDescription abstractToolDescription) {
        return this.genericCheckPrecondition((EObject)diagramElement, abstractToolDescription);
    }

    protected void addRefreshTask(final DDiagram diagram, DCommand result, final AbstractToolDescription abstractToolDescription) {
        if (abstractToolDescription != null && diagram instanceof DSemanticDiagram) {
            EObject semanticElement = ((DSemanticDecorator)diagram).getTarget();
            final Session session = SessionManager.INSTANCE.getSession(semanticElement);
            if (semanticElement != null && session != null) {
                result.getTasks().add(new AbstractCommandTask(){

                    public String getLabel() {
                        return "Set RefreshEditorsPrecommitListener options";
                    }

                    public void execute() throws MetaClassNotFoundException, FeatureNotFoundException {
                        if (abstractToolDescription.isForceRefresh()) {
                            session.getRefreshEditorsListener().setForceRefresh(true);
                        }
                        session.getRefreshEditorsListener().addRepresentationToForceRefresh((DRepresentation)diagram);
                    }
                });
            }
        }
    }

    protected void addRefreshTask(DDiagramElement diagramElement, DCommand result, AbstractToolDescription abstractToolDescription) {
        this.addRefreshTask(diagramElement.getParentDiagram(), result, abstractToolDescription);
    }

    protected void addDiagramVariable(DCommand command, EObject containerView, final IInterpreter interpreter) {
        final Option<DDiagram> diag = this.getDDiagram();
        if (diag.some()) {
            command.getTasks().add(new AbstractCommandTask(){

                public String getLabel() {
                    return "Add diagram variable";
                }

                public void execute() {
                    interpreter.setVariable("diagram", diag.get());
                }
            });
        }
    }

    public boolean isInLayoutingModeDiagram(EObject element) {
        DDiagram ddiagram = null;
        if (element instanceof DDiagram) {
            ddiagram = (DDiagram)element;
        } else if (element instanceof DDiagramElement) {
            ddiagram = ((DDiagramElement)element).getParentDiagram();
        }
        if (ddiagram != null) {
            return ddiagram.isIsInLayoutingMode();
        }
        return false;
    }

    private boolean genericCheckPrecondition(EObject container, AbstractToolDescription abstractToolDescription) {
        boolean result = true;
        EObject semanticContainer = null;
        if (container instanceof DSemanticDecorator) {
            semanticContainer = ((DSemanticDecorator)container).getTarget();
        }
        if (abstractToolDescription.getPrecondition() != null && !StringUtil.isEmpty((String)abstractToolDescription.getPrecondition().trim())) {
            IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)container);
            interpreter.setVariable("containerView", (Object)container);
            interpreter.setVariable("container", (Object)semanticContainer);
            result = this.evaluatePrecondition(interpreter, semanticContainer, abstractToolDescription.getPrecondition());
            interpreter.unSetVariable("container");
            interpreter.unSetVariable("containerView");
        }
        return result;
    }

    protected abstract Option<DDiagram> getDDiagram();
}

