/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.query;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.DiagramDescriptionQuery;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.PasteTargetDescription;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;

public class PasteTargetQuery {
    private DSemanticDecorator semDec;

    public PasteTargetQuery(DSemanticDecorator decorator) {
        this.semDec = decorator;
    }

    public Collection<PasteDescription> getAvailablePasteTools() {
        ArrayList result = Lists.newArrayList();
        if (this.semDec instanceof DDiagram) {
            DDiagram diag = (DDiagram)this.semDec;
            result.addAll(this.getPasteToolsOnActivatedLayers(diag, diag.getDescription()));
        } else if (this.semDec instanceof DDiagramElement) {
            DDiagramElement dde = (DDiagramElement)this.semDec;
            result.addAll(this.getPasteToolsOnActivatedLayers(dde.getParentDiagram(), dde.getDiagramElementMapping()));
        }
        return result;
    }

    private Collection<PasteDescription> getPasteToolsOnActivatedLayers(DDiagram dDiagram, PasteTargetDescription pasteTargetDescription) {
        if (dDiagram.getDescription().getDefaultLayer() != null) {
            HashSet allActivatedTools = Sets.newHashSet();
            allActivatedTools.addAll(dDiagram.getDescription().getDefaultLayer().getAllTools());
            for (Layer layer : dDiagram.getActivatedLayers()) {
                allActivatedTools.addAll(layer.getAllTools());
            }
            Collection<PasteDescription> pasteTools = this.getAllPasteTools(pasteTargetDescription);
            pasteTools.retainAll(allActivatedTools);
            return pasteTools;
        }
        return this.getAllPasteTools(pasteTargetDescription);
    }

    private Collection<PasteDescription> getAllPasteTools(PasteTargetDescription pasteTargetDescription) {
        HashSet pasteTools = Sets.newHashSet();
        pasteTools = pasteTargetDescription instanceof DiagramElementMapping ? Sets.newHashSet(new DiagramElementMappingQuery((DiagramElementMapping)pasteTargetDescription).getAllPasteTools()) : (pasteTargetDescription instanceof DiagramDescription ? Sets.newHashSet(new DiagramDescriptionQuery((DiagramDescription)pasteTargetDescription).getAllPasteTools()) : Sets.newHashSet((Iterable)pasteTargetDescription.getPasteDescriptions()));
        return pasteTools;
    }
}

