/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.spec;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.query.EdgeMappingQuery;
import org.eclipse.sirius.diagram.business.api.query.IEdgeMappingQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.EdgeMappingImportWrapper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.DSemanticDiagramHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.operations.DDiagramElementSpecOperations;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.impl.DEdgeImpl;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.Style;

public class DEdgeSpec
extends DEdgeImpl {
    public DiagramElementMapping getMapping() {
        return (DiagramElementMapping)new IEdgeMappingQuery(this.getActualMapping()).getEdgeMapping().get();
    }

    public void refresh() {
        Option<EdgeMapping> edgeMapping = new IEdgeMappingQuery(this.getActualMapping()).getEdgeMapping();
        if (edgeMapping.some()) {
            ((EdgeMapping)edgeMapping.get()).updateEdge(this);
        }
    }

    public Style getStyle() {
        return this.getOwnedStyle();
    }

    @Override
    public DDiagram getParentDiagram() {
        return DDiagramElementSpecOperations.getParentDiagram(this);
    }

    @Override
    public boolean validate() {
        DSemanticDiagram diagram;
        boolean result = true;
        DslCommonPlugin.PROFILER.startWork("Validating the edge");
        if (this.getActualMapping() != null && this.cantFindSemanticTargetFromSemanticSource()) {
            result = false;
        }
        EObject root = null;
        if (this.getParentDiagram() instanceof DSemanticDiagram) {
            diagram = (DSemanticDiagram)this.getParentDiagram();
            root = DSemanticDiagramHelper.getRootContent(diagram);
        } else {
            diagram = null;
        }
        if (diagram != null && root != null && this.getActualMapping() != null) {
            Collection<EObject> candidates;
            IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter(root);
            Option<EdgeMapping> edgeMappingOption = new IEdgeMappingQuery(this.getActualMapping()).getEdgeMapping();
            if (edgeMappingOption.some() && ((EdgeMapping)edgeMappingOption.get()).isUseDomainElement() && !(candidates = this.getSemanticCandidates(interpreter, root, diagram)).contains(this.getTarget())) {
                DslCommonPlugin.PROFILER.stopWork("Validating the edge");
                return false;
            }
            if (edgeMappingOption.some() && this.getSourceNode() instanceof DSemanticDecorator && this.getTargetNode() instanceof DSemanticDecorator) {
                EdgeMapping edgeMapping = (EdgeMapping)edgeMappingOption.get();
                EdgeMappingQuery edgeMappingQuery = new EdgeMappingQuery(edgeMapping);
                result = result && edgeMappingQuery.evaluatePrecondition(diagram, diagram, interpreter, this.getTarget(), (DSemanticDecorator)this.getSourceNode(), (DSemanticDecorator)this.getTargetNode());
            }
        }
        DslCommonPlugin.PROFILER.stopWork("Validating the edge");
        return result;
    }

    private boolean cantFindSemanticTargetFromSemanticSource() {
        EdgeTarget tgNode;
        Option<EdgeMapping> edgeMapping;
        DDiagram vp = null;
        boolean result = false;
        EdgeTarget srcNode = this.getSourceNode();
        if (srcNode instanceof DDiagramElement) {
            vp = ((DDiagramElement)((Object)srcNode)).getParentDiagram();
        }
        if ((edgeMapping = new IEdgeMappingQuery(this.getActualMapping()).getEdgeMapping()).some() && srcNode instanceof DSemanticDecorator && (tgNode = this.getTargetNode()) instanceof DSemanticDecorator) {
            EObject semanticSource = ((DSemanticDecorator)srcNode).getTarget();
            EObject semanticTarget = ((DSemanticDecorator)tgNode).getTarget();
            result = !this.findTargetFromSource((EdgeMapping)edgeMapping.get(), vp, semanticSource, semanticTarget);
        }
        return result;
    }

    private boolean findTargetFromSource(EdgeMapping mapping, DDiagram vp, EObject source, EObject target) {
        boolean result = false;
        if (mapping.isUseDomainElement()) {
            EObject edgeTarget = this.getTarget();
            if (mapping.getEdgeTargetCandidates(edgeTarget, vp).contains((Object)target) && mapping.getEdgeSourceCandidates(edgeTarget, vp).contains((Object)source)) {
                result = true;
            }
        } else if (mapping.getEdgeTargetCandidates(source, vp).contains((Object)target)) {
            result = true;
        }
        return result;
    }

    @Override
    @Deprecated
    public boolean isRootFolding() {
        throw new UnsupportedOperationException("Deprecated method.");
    }

    private Collection<EObject> getSemanticCandidates(IInterpreter interpreter, EObject model, DDiagram diagram) {
        Collection<Object> semanticCandidates;
        block11: {
            semanticCandidates = null;
            Option<EdgeMapping> actualEdgeMappingOption = new IEdgeMappingQuery(this.getActualMapping()).getEdgeMapping();
            if (actualEdgeMappingOption.some()) {
                EdgeMapping actualEdgeMapping = (EdgeMapping)actualEdgeMappingOption.get();
                if (actualEdgeMapping.isUseDomainElement() && actualEdgeMapping.getSemanticCandidatesExpression() != null && !StringUtil.isEmpty((String)actualEdgeMapping.getSemanticCandidatesExpression().trim())) {
                    interpreter.setVariable("viewpoint", (Object)diagram);
                    interpreter.setVariable("viewPoint", (Object)diagram);
                    interpreter.setVariable("diagram", (Object)diagram);
                    interpreter.setVariable("containerView", (Object)diagram);
                    EObject context = model;
                    try {
                        try {
                            semanticCandidates = interpreter.evaluateCollection(context, actualEdgeMapping.getSemanticCandidatesExpression());
                        }
                        catch (EvaluationException e) {
                            RuntimeLoggerManager.INSTANCE.error((EObject)this.getActualMapping(), (EStructuralFeature)DescriptionPackage.eINSTANCE.getDiagramElementMapping_SemanticCandidatesExpression(), (Throwable)e);
                            interpreter.unSetVariable("containerView");
                            interpreter.unSetVariable("diagram");
                            interpreter.unSetVariable("viewPoint");
                            interpreter.unSetVariable("viewpoint");
                            break block11;
                        }
                    }
                    catch (Throwable throwable) {
                        interpreter.unSetVariable("containerView");
                        interpreter.unSetVariable("diagram");
                        interpreter.unSetVariable("viewPoint");
                        interpreter.unSetVariable("viewpoint");
                        throw throwable;
                    }
                    interpreter.unSetVariable("containerView");
                    interpreter.unSetVariable("diagram");
                    interpreter.unSetVariable("viewPoint");
                    interpreter.unSetVariable("viewpoint");
                } else {
                    ModelAccessor extPackage = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(model);
                    semanticCandidates = Lists.newArrayList();
                    Session session = SessionManager.INSTANCE.getSession(model);
                    for (Resource resource : session.getSemanticResources()) {
                        for (EObject root : resource.getContents()) {
                            semanticCandidates.addAll(extPackage.eAllContents(root, "EObject"));
                        }
                    }
                }
            }
        }
        if (semanticCandidates == null) {
            semanticCandidates = Collections.emptySet();
        }
        return semanticCandidates;
    }

    @Override
    public String toString() {
        if (this.getTargetNode() != null && this.getSourceNode() != null) {
            return "Edge source:" + this.getSourceNode() + " | target:" + this.getTargetNode() + " on semantic" + this.getTarget();
        }
        return super.toString();
    }

    @Override
    public EList<EdgeTarget> getPath() {
        if (this.path == null) {
            this.path = new EObjectResolvingEList<EdgeTarget>(EdgeTarget.class, (InternalEObject)this, 21){

                protected boolean isUnique() {
                    return false;
                }
            };
        }
        return this.path;
    }

    public void eNotify(Notification notification) {
        if (notification.getEventType() == 1 && notification.getFeatureID(DEdge.class) == 16 && notification.getOldValue() instanceof EdgeMappingImport && EdgeMappingImportWrapper.getWrapper((EdgeMappingImport)notification.getOldValue()) == notification.getNewValue()) {
            return;
        }
        super.eNotify(notification);
    }
}

