/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.description.filter.spec;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.FilterVariableValue;
import org.eclipse.sirius.diagram.description.filter.FilterPackage;
import org.eclipse.sirius.diagram.description.filter.impl.VariableFilterImpl;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class VariableFilterSpec
extends VariableFilterImpl {
    private Multimap<String, EObject> variables;
    private DDiagram curDiagram;

    @Override
    public boolean isVisible(DDiagramElement element) {
        if (element.getParentDiagram() == null) {
            return false;
        }
        this.getVariablesFromDiagram(element.getParentDiagram());
        boolean valid = true;
        IInterpreter interpreter = SiriusPlugin.getDefault().getInterpreterRegistry().getInterpreter((EObject)element);
        if (this.variables != null) {
            for (String key : this.variables.keySet()) {
                Collection value = this.variables.get((Object)key);
                interpreter.setVariable(key, (Object)value);
            }
        }
        if (this.getSemanticConditionExpression() != null) {
            EObject target = element.getTarget();
            if (target == null || target.eResource() == null) {
                valid = false;
            } else {
                try {
                    valid = interpreter.evaluateBoolean(element.getTarget(), this.getSemanticConditionExpression());
                }
                catch (EvaluationException e) {
                    RuntimeLoggerManager.INSTANCE.error((EObject)this, (EStructuralFeature)FilterPackage.eINSTANCE.getVariableFilter_SemanticConditionExpression(), (Throwable)e);
                }
            }
        }
        return valid;
    }

    private void getVariablesFromDiagram(DDiagram dDiagram) {
        if (this.curDiagram == null || dDiagram != this.curDiagram) {
            this.variables = ArrayListMultimap.create();
            if (dDiagram.getFilterVariableHistory() != null) {
                for (FilterVariableValue value : dDiagram.getFilterVariableHistory().getOwnedValues()) {
                    if (!this.getOwnedVariables().contains((Object)value.getVariableDefinition())) continue;
                    this.variables.put((Object)value.getVariableDefinition().getName(), (Object)value.getModelElement());
                }
            }
            this.curDiagram = dDiagram;
        }
    }

    @Override
    public void setFilterContext(Map<?, ?> variablesMap) {
        this.variables = ArrayListMultimap.create();
        for (Map.Entry<?, ?> entry : variablesMap.entrySet()) {
            this.variables.put((Object)((String)entry.getKey()), (Object)((EObject)entry.getValue()));
        }
        this.curDiagram = null;
    }
}

