/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICommandTask;
import org.eclipse.sirius.business.api.helper.task.TaskExecutor;
import org.eclipse.sirius.business.api.preferences.SiriusPreferencesKeys;
import org.eclipse.sirius.business.internal.helper.task.DeleteDDiagramElementTask;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.tools.internal.command.builders.DeletionCommandBuilder;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.tools.api.command.SiriusCommand;
import org.eclipse.sirius.tools.api.command.ui.UICallBack;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class DeleteSeveralDDiagramElementsTask
extends AbstractCommandTask {
    private DCommand cmd;
    private DDiagramElement dde;
    private TransactionalEditingDomain domain;
    private ModelAccessor modelAcessor;
    private List<ICommandTask> executedTask;
    private DeletionCommandBuilder deletionCommandBuilder;

    public DeleteSeveralDDiagramElementsTask(TransactionalEditingDomain domain, ModelAccessor modelAcessor, UICallBack callback, DCommand cmd, DDiagramElement dde) {
        this.cmd = cmd;
        this.dde = dde;
        this.domain = domain;
        this.modelAcessor = modelAcessor;
        this.deletionCommandBuilder = new DeletionCommandBuilder();
        this.deletionCommandBuilder.init(modelAcessor, domain, callback);
    }

    public void execute() {
        ArrayList<ICommandTask> tasks = new ArrayList<ICommandTask>();
        EObject root = null;
        boolean automaticRefresh = Platform.getPreferencesService().getBoolean("org.eclipse.sirius", SiriusPreferencesKeys.PREF_AUTO_REFRESH.name(), false, null);
        if (automaticRefresh) {
            root = EcoreUtil.getRootContainer((EObject)this.dde);
        } else {
            EObjectQuery eObjectQuery = new EObjectQuery((EObject)this.dde);
            root = (EObject)eObjectQuery.getRepresentation().get();
        }
        Set<DSemanticDecorator> vpElements = this.deletionCommandBuilder.getDElementToClearFromSemanticElements(root, this.completeCollection(this.cmd.getDeletedObjects()));
        for (DSemanticDecorator eObj : vpElements) {
            tasks.add((ICommandTask)new DeleteDDiagramElementTask((EObject)eObj, this.modelAcessor));
            if (!(eObj instanceof DDiagram)) continue;
            SiriusCommand temp = new SiriusCommand(this.domain);
            this.deletionCommandBuilder.addDeleteDiagramTasks((DCommand)temp, (DDiagram)eObj);
            List tempTasks = temp.getTasks();
            if (!TaskExecutor.canExecute((List)tempTasks)) continue;
            TaskExecutor.execute((List)tempTasks);
            if (this.executedTask == null) {
                this.executedTask = new LinkedList<ICommandTask>();
            }
            this.executedTask.addAll(tempTasks);
        }
        if (TaskExecutor.canExecute(tasks)) {
            TaskExecutor.execute(tasks);
            if (this.executedTask != null) {
                this.executedTask.addAll(tasks);
            } else {
                this.executedTask = tasks;
            }
        }
    }

    public void undo() {
        if (this.executedTask != null) {
            TaskExecutor.undo(this.executedTask);
        }
    }

    public void redo() {
        if (this.executedTask != null) {
            TaskExecutor.redo(this.executedTask);
        }
    }

    public String getLabel() {
        return "delete diagram elements task";
    }

    private Set<EObject> completeCollection(Collection<EObject> semantics) {
        HashSet<EObject> result = new HashSet<EObject>(semantics);
        for (EObject sem : semantics) {
            TreeIterator iterContent = sem.eAllContents();
            while (iterContent.hasNext()) {
                result.add((EObject)iterContent.next());
            }
        }
        return result;
    }
}

