/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.display;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.listener.NotificationReceiver;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.helper.display.DisplayServiceManager;

public class VisibilityPropagatorAdapter
extends EContentAdapter
implements NotificationReceiver {
    private boolean active;
    private boolean previousActive;
    private Session session;
    private DDiagram diagram;

    public VisibilityPropagatorAdapter(Session session, DDiagram diagram) {
        this.session = session;
        this.diagram = diagram;
        this.diagram.eAdapters().add((Object)this);
    }

    public void receive(int kind, int notification) {
        block0 : switch (notification) {
            case 2: {
                switch (kind) {
                    case 0: {
                        this.previousActive = this.active;
                        this.active = true;
                        break block0;
                    }
                    case 1: {
                        this.active = this.previousActive;
                        this.previousActive = false;
                        break block0;
                    }
                }
                break;
            }
            case 3: {
                switch (kind) {
                    case 0: {
                        this.previousActive = this.active;
                        this.active = false;
                        break block0;
                    }
                    case 1: {
                        this.active = this.previousActive;
                        this.previousActive = false;
                        break block0;
                    }
                }
                break;
            }
        }
    }

    public void notifyChanged(Notification n) {
        super.notifyChanged(n);
        Object notifier = n.getNotifier();
        if (this.active) {
            switch (n.getEventType()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    if (notifier instanceof DSemanticDiagram && DiagramPackage.eINSTANCE.getDDiagram_ActivatedFilters().equals(n.getFeature())) {
                        DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)notifier);
                    }
                    if (notifier instanceof DSemanticDiagram && DiagramPackage.eINSTANCE.getDDiagram_ActivatedLayers().equals(n.getFeature())) {
                        DisplayServiceManager.INSTANCE.getDisplayService().refreshAllElementsVisibility((DDiagram)notifier);
                    }
                    if (!(notifier instanceof DDiagramElement) || n.getFeatureID(DDiagramElement.class) != 4) break;
                    this.propagateElementVisibility((DDiagramElement)notifier, n);
                    break;
                }
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        if (notifier instanceof DSemanticDiagram || notifier instanceof DDiagramElement) {
            super.addAdapter(notifier);
        }
    }

    private void propagateElementVisibility(DDiagramElement element, Notification n) {
        DDiagram parentDiagram = element.getParentDiagram();
        if (element instanceof AbstractDNode) {
            for (DNode borderNode : ((AbstractDNode)element).getOwnedBorderedNodes()) {
                borderNode.setVisible(this.getVisibility(parentDiagram, borderNode, n.getNewBooleanValue()));
            }
        }
        if (element instanceof DNodeContainer) {
            for (DDiagramElement child : ((DNodeContainer)element).getOwnedDiagramElements()) {
                child.setVisible(this.getVisibility(parentDiagram, child, n.getNewBooleanValue()));
            }
        } else if (element instanceof DNodeList) {
            for (DDiagramElement child : ((DNodeList)element).getElements()) {
                child.setVisible(this.getVisibility(parentDiagram, child, n.getNewBooleanValue()));
            }
        }
        if (element instanceof EdgeTarget) {
            for (DEdge linkedEdge : Iterables.concat(((EdgeTarget)((Object)element)).getIncomingEdges(), ((EdgeTarget)((Object)element)).getOutgoingEdges())) {
                linkedEdge.setVisible(this.getVisibility(parentDiagram, linkedEdge, n.getNewBooleanValue()));
            }
        }
    }

    private boolean getVisibility(DDiagram parentDiagram, DDiagramElement element, boolean parentIsVisible) {
        if (!parentIsVisible) {
            return false;
        }
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(this.session, parentDiagram);
        return DisplayServiceManager.INSTANCE.getDisplayService().computeVisibility(mappingManager, parentDiagram, element);
    }

    public void dispose() {
        if (this.diagram != null) {
            this.diagram.eAdapters().remove((Object)this);
        }
        this.diagram = null;
        this.session = null;
    }
}

