/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.experimental.sync;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.query.DiagramElementMappingQuery;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.AbstractDNodeCandidate;
import org.eclipse.sirius.diagram.business.internal.experimental.sync.DDiagramSynchronizer;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.LayerHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingsListVisitor;
import org.eclipse.sirius.diagram.business.internal.sync.visitor.DiagramElementsHierarchyVisitor;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;

public class MappingsUpdater {
    private DDiagram diagram;
    private DiagramMappingsManager mappingsManager;
    private DDiagramSynchronizer synchronizer;

    public MappingsUpdater(DDiagram diagram, DiagramMappingsManager mappingsManager, DDiagramSynchronizer synchronizer) {
        this.diagram = diagram;
        this.mappingsManager = mappingsManager;
        this.synchronizer = synchronizer;
    }

    public void updateMappings() {
        this.updateMappings(this.diagram);
    }

    private void updateMappings(DragAndDropTarget container) {
        this.mappingsManager.iterate(new MappingUpdateVisitor(container), container);
        for (DDiagramElement dDiagramElement : DiagramElementsHierarchyVisitor.INSTANCE.getChildren(container)) {
            if (!(dDiagramElement instanceof DragAndDropTarget)) continue;
            this.updateMappings((DragAndDropTarget)((Object)dDiagramElement));
        }
    }

    private class MappingUpdateVisitor
    implements MappingsListVisitor {
        private DragAndDropTarget container;

        public MappingUpdateVisitor(DragAndDropTarget container) {
            this.container = container;
        }

        @Override
        public Set<AbstractDNodeCandidate> visit(DiagramElementMapping pMapping, Set<AbstractDNodeCandidate> candidateFilter) {
            HashSet result;
            if (pMapping instanceof AbstractNodeMapping) {
                final AbstractNodeMapping mapping = (AbstractNodeMapping)pMapping;
                Collection<AbstractDNodeCandidate> validCandidates = this.getNodeCandidates(mapping, candidateFilter);
                Collection validSemantics = Collections2.transform(validCandidates, (Function)new Function<AbstractDNodeCandidate, EObject>(){

                    public EObject apply(AbstractDNodeCandidate from) {
                        return from.getSemantic();
                    }
                });
                HashSet<EObject> semanticElementsDone = new HashSet<EObject>();
                if (!validSemantics.isEmpty()) {
                    for (DDiagramElement dDiagramElement : DiagramElementsHierarchyVisitor.INSTANCE.getChildren(this.container)) {
                        DiagramElementMapping elementMapping = dDiagramElement.getDiagramElementMapping();
                        EObject semanticElement = dDiagramElement.getTarget();
                        if (!(elementMapping instanceof AbstractNodeMapping) || semanticElement == null || !validSemantics.contains(semanticElement) || !new DiagramElementMappingQuery(elementMapping).areInSameHiearchy(mapping)) continue;
                        LayerHelper.updateActualMapping(dDiagramElement, mapping);
                        semanticElementsDone.add(semanticElement);
                    }
                }
                result = Sets.newHashSet((Iterable)Collections2.transform(semanticElementsDone, (Function)new Function<EObject, AbstractDNodeCandidate>(){

                    public AbstractDNodeCandidate apply(EObject from) {
                        return new AbstractDNodeCandidate(mapping, from, MappingUpdateVisitor.this.container);
                    }
                }));
            } else {
                result = Collections.emptySet();
            }
            return result;
        }

        private Set<AbstractDNodeCandidate> getHierarchyCandidateFilter(final AbstractNodeMapping mapping, Set<AbstractDNodeCandidate> semanticFilter) {
            final DiagramElementMappingQuery diagramElementMappingQuery = new DiagramElementMappingQuery(mapping);
            final HashMap knownMappingHierarchy = Maps.newHashMap();
            return Sets.newHashSet((Iterable)Collections2.transform(semanticFilter, (Function)new Function<AbstractDNodeCandidate, AbstractDNodeCandidate>(){

                public AbstractDNodeCandidate apply(AbstractDNodeCandidate from) {
                    boolean areInSameHiearchy;
                    AbstractDNodeCandidate result = from;
                    AbstractNodeMapping fromMapping = from.getMapping();
                    if (!knownMappingHierarchy.containsKey(fromMapping)) {
                        areInSameHiearchy = diagramElementMappingQuery.areInSameHiearchy(fromMapping);
                        knownMappingHierarchy.put(fromMapping, areInSameHiearchy);
                    } else {
                        areInSameHiearchy = (Boolean)knownMappingHierarchy.get(fromMapping);
                    }
                    if (areInSameHiearchy) {
                        result = new AbstractDNodeCandidate(mapping, from.getSemantic(), MappingUpdateVisitor.this.container);
                    }
                    return result;
                }
            }));
        }

        private Collection<AbstractDNodeCandidate> getNodeCandidates(AbstractNodeMapping mapping, Set<AbstractDNodeCandidate> candidateFilter) {
            Collection<AbstractDNodeCandidate> result;
            Set<AbstractDNodeCandidate> hierarchyCandidateFilter = this.getHierarchyCandidateFilter(mapping, candidateFilter);
            if (!new DiagramElementMappingQuery(mapping).isSynchronizedAndCreateElement(MappingsUpdater.this.diagram)) {
                MappingsUpdater.this.synchronizer.forceRetrieve();
                Collection<AbstractDNodeCandidate> candidates = MappingsUpdater.this.synchronizer.computeNodeCandidates(this.container, mapping, hierarchyCandidateFilter);
                MappingsUpdater.this.synchronizer.resetforceRetrieve();
                result = candidates;
            } else {
                result = MappingsUpdater.this.synchronizer.computeNodeCandidates(this.container, mapping, hierarchyCandidateFilter);
            }
            return result;
        }
    }
}

