/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ResizeKind implements Enumerator
{
    NONE_LITERAL(0, "NONE", "NONE"),
    NSEW_LITERAL(1, "NSEW", "NSEW"),
    NORTH_SOUTH_LITERAL(2, "NORTH_SOUTH", "NORTH_SOUTH"),
    EAST_WEST_LITERAL(3, "EAST_WEST", "EAST_WEST");

    public static final int NONE = 0;
    public static final int NSEW = 1;
    public static final int NORTH_SOUTH = 2;
    public static final int EAST_WEST = 3;
    private static final ResizeKind[] VALUES_ARRAY;
    public static final List<ResizeKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ResizeKind[]{NONE_LITERAL, NSEW_LITERAL, NORTH_SOUTH_LITERAL, EAST_WEST_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ResizeKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResizeKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResizeKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ResizeKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ResizeKind get(int value) {
        switch (value) {
            case 0: {
                return NONE_LITERAL;
            }
            case 1: {
                return NSEW_LITERAL;
            }
            case 2: {
                return NORTH_SOUTH_LITERAL;
            }
            case 3: {
                return EAST_WEST_LITERAL;
            }
        }
        return null;
    }

    private ResizeKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

