/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum LabelPosition implements Enumerator
{
    BORDER_LITERAL(0, "border", "border"),
    NODE_LITERAL(1, "node", "node");

    public static final int BORDER = 0;
    public static final int NODE = 1;
    private static final LabelPosition[] VALUES_ARRAY;
    public static final List<LabelPosition> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new LabelPosition[]{BORDER_LITERAL, NODE_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static LabelPosition get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LabelPosition result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LabelPosition getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            LabelPosition result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static LabelPosition get(int value) {
        switch (value) {
            case 0: {
                return BORDER_LITERAL;
            }
            case 1: {
                return NODE_LITERAL;
            }
        }
        return null;
    }

    private LabelPosition(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

