/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.tools.utils;

import org.eclipse.uml2.uml.MultiplicityElement;

public class MultiplicityElementUtil {
    public static String getMultiplicityAsString(MultiplicityElement element) {
        StringBuffer buffer = new StringBuffer();
        String multiplicityStr = MultiplicityElementUtil.getMultiplicityAsStringWithoutSquareBrackets(element);
        if (multiplicityStr != null && !"".equals(multiplicityStr)) {
            buffer.append(" [");
            buffer.append(multiplicityStr);
            buffer.append("]");
        }
        return buffer.toString();
    }

    public static String getMultiplicityAsStringWithoutSquareBrackets(MultiplicityElement element) {
        int upper;
        StringBuffer buffer = new StringBuffer();
        int lower = element.getLower();
        if (lower == (upper = element.getUpper())) {
            buffer.append(lower);
        } else if (lower == 0 && upper == -1) {
            buffer.append("*");
        } else if (upper == -1) {
            buffer.append(lower);
            buffer.append("..*");
        } else {
            buffer.append(lower);
            buffer.append("..");
            buffer.append(upper);
        }
        return buffer.toString();
    }

    public static int[] parseMultiplicity(String value) throws NumberFormatException {
        int lower = 0;
        int upper = 0;
        int firstIndex = value.indexOf("..");
        if (firstIndex == -1) {
            if ("*".equals(value)) {
                lower = 0;
                upper = -1;
            } else {
                upper = lower = Integer.parseInt(value);
            }
        } else {
            String lowerValue = value.substring(0, firstIndex);
            String upperValue = value.substring(firstIndex + "..".length());
            lower = Integer.parseInt(lowerValue);
            upper = -2;
            upper = "*".equals(upperValue) ? -1 : Integer.parseInt(upperValue);
        }
        return new int[]{lower, upper};
    }
}

