/*
 * Decompiled with CFR 0.152.
 */
package org.yakindu.sct.model.sgraph.resource;

import com.google.common.base.Strings;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EClassImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.gmf.runtime.emf.core.resources.GMFResource;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.XtextFactory;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.ILinker;
import org.eclipse.xtext.linking.ILinkingDiagnosticMessageProvider;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.linking.impl.XtextLinkingDiagnostic;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.parsetree.reconstr.XtextSerializationException;
import org.eclipse.xtext.resource.XtextSyntaxDiagnostic;
import org.eclipse.xtext.resource.impl.ListBasedDiagnosticConsumer;
import org.eclipse.xtext.serializer.ISerializer;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.Triple;
import org.eclipse.xtext.validation.IConcreteSyntaxValidator;
import org.yakindu.sct.model.sgraph.SGraphPackage;
import org.yakindu.sct.model.sgraph.SpecificationElement;
import org.yakindu.sct.model.sgraph.State;
import org.yakindu.sct.model.sgraph.Statechart;
import org.yakindu.sct.model.sgraph.Transition;

public abstract class AbstractSCTResource
extends GMFResource {
    public static final String SCT_PREFIX = "SCT_";
    @Inject
    private IParser parser;
    @Inject
    private ILinker linker;
    @Inject
    private ISerializer serializer;
    @Inject
    private LazyURIEncoder encoder;
    @Inject
    private ILinkingService linkingService;
    @Inject
    private ILinkingDiagnosticMessageProvider diagnosticMessageProvider;
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    @Named(value="languageName")
    private String languageName;
    protected boolean isParsing = false;
    protected boolean isLinking = false;
    protected boolean isSerializing = false;
    private boolean serializerEnabled = false;
    protected Multimap<SpecificationElement, Resource.Diagnostic> syntaxDiagnostics = HashMultimap.create();
    protected Multimap<SpecificationElement, Resource.Diagnostic> linkingDiagnostics = HashMultimap.create();
    protected Map<SpecificationElement, Resource.Diagnostic> sublinkDiagnostics;

    protected abstract void parseTransition(Transition var1);

    protected abstract void parseState(State var1);

    protected abstract void parseStatechart(Statechart var1);

    protected abstract void serializeStatechart(Statechart var1);

    protected abstract void serializeState(State var1);

    protected abstract void serializeTransition(Transition var1);

    public AbstractSCTResource(URI uri) {
        super(uri);
    }

    protected void attachedHelper(EObject eObject) {
        super.attachedHelper(eObject);
        if (eObject instanceof SpecificationElement) {
            Adapter serializeAdapter;
            Adapter parseAdapter = EcoreUtil.getExistingAdapter((Notifier)eObject, ParseAdapter.class);
            if (parseAdapter == null) {
                this.parseSpecificationElement((SpecificationElement)eObject);
                this.linkSpecificationElement((SpecificationElement)eObject);
                eObject.eAdapters().add((Object)new ParseAdapter());
            }
            if ((serializeAdapter = EcoreUtil.getExistingAdapter((Notifier)eObject, SerializeAdapter.class)) == null) {
                eObject.eAdapters().add((Object)new SerializeAdapter());
            }
        }
    }

    public void detached(EObject eObject) {
        super.detached(eObject);
        DETACHED_EOBJECT_TO_ID_MAP.clear();
    }

    protected void detachedHelper(EObject eObject) {
        if (eObject instanceof SpecificationElement) {
            Adapter serializeAdapter;
            Adapter parseAdapter = EcoreUtil.getExistingAdapter((Notifier)eObject, ParseAdapter.class);
            if (parseAdapter != null) {
                eObject.eAdapters().remove((Object)parseAdapter);
            }
            if ((serializeAdapter = EcoreUtil.getExistingAdapter((Notifier)eObject, SerializeAdapter.class)) != null) {
                eObject.eAdapters().remove((Object)serializeAdapter);
            }
        }
        super.detachedHelper(eObject);
    }

    public synchronized EObject getEObject(String uriFragment) {
        if (this.encoder.isCrossLinkFragment((Resource)this, uriFragment)) {
            Triple triple = this.encoder.decode((Resource)this, uriFragment);
            List linkedObjects = null;
            linkedObjects = this.linkingService.getLinkedObjects((EObject)triple.getFirst(), (EReference)triple.getSecond(), (INode)triple.getThird());
            if (!linkedObjects.isEmpty()) {
                return (EObject)linkedObjects.get(0);
            }
            this.createDiagnostic((Triple<EObject, EReference, INode>)triple);
        }
        if (uriFragment != null && uriFragment.startsWith(SCT_PREFIX)) {
            return super.getEObject(uriFragment.substring(SCT_PREFIX.length()));
        }
        return super.getEObject(uriFragment);
    }

    public synchronized String getURIFragment(EObject eObject) {
        String fragment;
        if (this.unloadingContents != null) {
            return super.getURIFragment(eObject);
        }
        ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)eObject);
        if (node != null && !Strings.isNullOrEmpty((String)(fragment = super.getURIFragment(eObject)))) {
            return SCT_PREFIX + fragment;
        }
        return super.getURIFragment(eObject);
    }

    public String getID(EObject eObject) {
        if (NodeModelUtils.getNode((EObject)eObject) != null) {
            return null;
        }
        return super.getID(eObject);
    }

    protected void createDiagnostic(Triple<EObject, EReference, INode> triple) {
        SpecificationElement specificationElement = (SpecificationElement)EcoreUtil2.getContainerOfType((EObject)((EObject)triple.getFirst()), SpecificationElement.class);
        DiagnosticMessage message = this.createDiagnosticMessage(triple);
        XtextLinkingDiagnostic diagnostic = new XtextLinkingDiagnostic((INode)triple.getThird(), message.getMessage(), message.getIssueCode(), message.getIssueData());
        this.linkingDiagnostics.put((Object)specificationElement, (Object)diagnostic);
    }

    protected DiagnosticMessage createDiagnosticMessage(Triple<EObject, EReference, INode> triple) {
        ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext context = this.createDiagnosticMessageContext(triple);
        DiagnosticMessage message = this.diagnosticMessageProvider.getUnresolvedProxyMessage(context);
        return message;
    }

    protected ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext createDiagnosticMessageContext(Triple<EObject, EReference, INode> triple) {
        return new DiagnosticMessageContext(triple, this.linkingHelper);
    }

    public void resolveLazyCrossReferences(CancelIndicator monitor) {
        TreeIterator iterator = EcoreUtil.getAllContents((Resource)this, (boolean)true);
        while (iterator.hasNext()) {
            InternalEObject source = (InternalEObject)iterator.next();
            EStructuralFeature[] eStructuralFeatures = ((EClassImpl.FeatureSubsetSupplier)source.eClass().getEAllStructuralFeatures()).crossReferences();
            if (eStructuralFeatures == null) continue;
            EStructuralFeature[] eStructuralFeatureArray = eStructuralFeatures;
            int n = eStructuralFeatures.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature crossRef = eStructuralFeatureArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                this.resolveLazyCrossReference(source, crossRef, monitor);
                ++n2;
            }
        }
    }

    protected void resolveLazyCrossReference(InternalEObject source, EStructuralFeature crossRef, CancelIndicator monitor) {
        block13: {
            EObject target;
            String fragment;
            block12: {
                if (crossRef.isDerived()) {
                    return;
                }
                if (!crossRef.isMany()) break block12;
                InternalEList list = (InternalEList)source.eGet(crossRef);
                int i = 0;
                while (i < list.size()) {
                    EObject proxy = (EObject)list.basicGet(i);
                    if (proxy.eIsProxy()) {
                        EObject target2;
                        String fragment2;
                        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
                        if (this.getURI().equals(proxyURI.trimFragment()) && this.encoder.isCrossLinkFragment((Resource)this, fragment2 = proxyURI.fragment()) && !monitor.isCanceled() && (target2 = this.getEObject(fragment2)) != null) {
                            try {
                                source.eSetDeliver(false);
                                list.setUnique(i, (Object)target2);
                            }
                            finally {
                                source.eSetDeliver(true);
                            }
                        }
                    }
                    ++i;
                }
                break block13;
            }
            EObject proxy = (EObject)source.eGet(crossRef, false);
            if (proxy == null || !proxy.eIsProxy()) break block13;
            URI proxyURI = ((InternalEObject)proxy).eProxyURI();
            if (this.getURI().equals(proxyURI.trimFragment()) && this.encoder.isCrossLinkFragment((Resource)this, fragment = proxyURI.fragment()) && !monitor.isCanceled() && (target = this.getEObject(fragment)) != null) {
                try {
                    source.eSetDeliver(false);
                    source.eSet(crossRef, (Object)target);
                }
                finally {
                    source.eSetDeliver(true);
                }
            }
        }
    }

    public void parseSpecificationElement(SpecificationElement element) {
        Assert.isNotNull((Object)element);
        this.isParsing = true;
        if (element instanceof Transition) {
            this.parseTransition((Transition)element);
        } else if (element instanceof State) {
            this.parseState((State)element);
        } else if (element instanceof Statechart) {
            this.parseStatechart((Statechart)element);
        }
        this.isParsing = false;
    }

    protected IParseResult parse(SpecificationElement element, String rule) {
        ParserRule parserRule = XtextFactory.eINSTANCE.createParserRule();
        parserRule.setName(rule);
        String specification = element.getSpecification();
        IParseResult result = this.parser.parse(parserRule, (Reader)new StringReader(specification != null ? specification : ""));
        this.createDiagnostics(result, element);
        return result;
    }

    protected void createDiagnostics(IParseResult parseResult, SpecificationElement semanticTarget) {
        this.syntaxDiagnostics.get((Object)semanticTarget).clear();
        for (INode error : parseResult.getSyntaxErrors()) {
            this.syntaxDiagnostics.put((Object)semanticTarget, (Object)new XtextSyntaxDiagnostic(error));
        }
    }

    public void linkSpecificationElements() {
        TreeIterator iter = this.getAllContents();
        while (iter.hasNext()) {
            EObject currentObject = (EObject)iter.next();
            if (!(currentObject instanceof SpecificationElement)) continue;
            this.linkSpecificationElement((SpecificationElement)currentObject);
        }
    }

    protected void linkSpecificationElement(SpecificationElement element) {
        this.isLinking = true;
        ListBasedDiagnosticConsumer consumer = new ListBasedDiagnosticConsumer();
        this.linker.linkModel((EObject)element, (IDiagnosticConsumer)consumer);
        this.linkingDiagnostics.get((Object)element).clear();
        this.linkingDiagnostics.putAll((Object)element, (Iterable)consumer.getResult(Severity.ERROR));
        this.linkingDiagnostics.putAll((Object)element, (Iterable)consumer.getResult(Severity.WARNING));
        this.isLinking = false;
    }

    protected void serializeSpecificationElement(SpecificationElement element) {
        if (this.getSyntaxDiagnostics().get((Object)element).size() > 0 || this.getLinkingDiagnostics().get((Object)element).size() > 0) {
            return;
        }
        try {
            try {
                this.isSerializing = true;
                if (element instanceof Transition) {
                    this.serializeTransition((Transition)element);
                } else if (element instanceof State) {
                    this.serializeState((State)element);
                } else if (element instanceof Statechart) {
                    this.serializeStatechart((Statechart)element);
                }
            }
            catch (XtextSerializationException xtextSerializationException) {
                this.isSerializing = false;
            }
            catch (IConcreteSyntaxValidator.InvalidConcreteSyntaxException invalidConcreteSyntaxException) {
                this.isSerializing = false;
            }
        }
        finally {
            this.isSerializing = false;
        }
    }

    protected String serialize(EObject object) {
        if (object != null) {
            return this.serializer.serialize(object);
        }
        return "";
    }

    public Multimap<SpecificationElement, Resource.Diagnostic> getSyntaxDiagnostics() {
        return this.syntaxDiagnostics;
    }

    public Multimap<SpecificationElement, Resource.Diagnostic> getLinkingDiagnostics() {
        return this.linkingDiagnostics;
    }

    public String getLanguageName() {
        return this.languageName;
    }

    public boolean isSerializerEnabled() {
        return this.serializerEnabled;
    }

    public void setSerializerEnabled(boolean serializerEnabled) {
        this.serializerEnabled = serializerEnabled;
    }

    protected static class DiagnosticMessageContext
    implements ILinkingDiagnosticMessageProvider.ILinkingDiagnosticContext {
        private final Triple<EObject, EReference, INode> triple;
        private final LinkingHelper linkingHelper;

        protected DiagnosticMessageContext(Triple<EObject, EReference, INode> triple, LinkingHelper helper) {
            this.triple = triple;
            this.linkingHelper = helper;
        }

        public EObject getContext() {
            return (EObject)this.triple.getFirst();
        }

        public EReference getReference() {
            return (EReference)this.triple.getSecond();
        }

        public String getLinkText() {
            return this.linkingHelper.getCrossRefNodeAsString((INode)this.triple.getThird(), true);
        }
    }

    protected final class ParseAdapter
    extends AdapterImpl {
        protected ParseAdapter() {
        }

        public void notifyChanged(Notification msg) {
            if (AbstractSCTResource.this.isSerializing) {
                return;
            }
            if (msg.getFeature() == SGraphPackage.Literals.SPECIFICATION_ELEMENT__SPECIFICATION) {
                String newValString = msg.getNewStringValue();
                String oldVString = msg.getOldStringValue();
                if (newValString != null && !newValString.equals(oldVString)) {
                    AbstractSCTResource.this.parseSpecificationElement((SpecificationElement)msg.getNotifier());
                    AbstractSCTResource.this.linkSpecificationElements();
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return ParseAdapter.class == type;
        }
    }

    protected final class SerializeAdapter
    extends EContentAdapter {
        protected SerializeAdapter() {
        }

        public void notifyChanged(Notification msg) {
            super.notifyChanged(msg);
            if (AbstractSCTResource.this.isSerializerEnabled()) {
                EObject eObject;
                SpecificationElement container;
                if (AbstractSCTResource.this.isLoading() || AbstractSCTResource.this.isParsing || AbstractSCTResource.this.isLinking || AbstractSCTResource.this.isSerializing) {
                    return;
                }
                if (msg.getEventType() == 8 || msg.getEventType() == 9) {
                    return;
                }
                Object notifier = msg.getNotifier();
                if (notifier instanceof EObject && (container = (SpecificationElement)EcoreUtil2.getContainerOfType((EObject)(eObject = (EObject)notifier), SpecificationElement.class)) != null) {
                    AbstractSCTResource.this.serializeSpecificationElement(container);
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return SerializeAdapter.class == type;
        }
    }
}

