/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.rete.construction.quasitree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.incquery.runtime.matchers.planning.SubPlan;
import org.eclipse.incquery.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.incquery.runtime.matchers.psystem.PConstraint;
import org.eclipse.incquery.runtime.matchers.psystem.PVariable;
import org.eclipse.incquery.runtime.matchers.util.CollectionsFactory;
import org.eclipse.incquery.runtime.rete.construction.quasitree.TieBreaker;

class JoinCandidate {
    SubPlan primary;
    SubPlan secondary;
    SubPlan joinedPlan;
    Set<PVariable> varPrimary;
    Set<PVariable> varSecondary;
    Set<PVariable> varCommon;
    List<PConstraint> consPrimary;
    List<PConstraint> consSecondary;
    private Boolean heath;

    JoinCandidate(SubPlan joinedPlan) {
        this.joinedPlan = joinedPlan;
        this.primary = (SubPlan)joinedPlan.getParentPlans().get(0);
        this.secondary = (SubPlan)joinedPlan.getParentPlans().get(1);
        this.varPrimary = this.getPrimary().getVisibleVariables();
        this.varSecondary = this.getSecondary().getVisibleVariables();
        this.varCommon = CollectionsFactory.getSet(this.varPrimary);
        this.varCommon.retainAll(this.varSecondary);
        this.consPrimary = new ArrayList<PConstraint>(this.primary.getAllEnforcedConstraints());
        Collections.sort(this.consPrimary, TieBreaker.CONSTRAINT_COMPARATOR);
        this.consSecondary = new ArrayList<PConstraint>(this.secondary.getAllEnforcedConstraints());
        Collections.sort(this.consSecondary, TieBreaker.CONSTRAINT_COMPARATOR);
    }

    public SubPlan getPrimary() {
        return this.primary;
    }

    public SubPlan getSecondary() {
        return this.secondary;
    }

    public SubPlan getJoinedPlan() {
        return this.joinedPlan;
    }

    public String toString() {
        return String.valueOf(this.primary.toString()) + " |x| " + this.secondary.toString();
    }

    public Set<PVariable> getVarPrimary() {
        return this.varPrimary;
    }

    public Set<PVariable> getVarSecondary() {
        return this.varSecondary;
    }

    public List<PConstraint> getConsPrimary() {
        return this.consPrimary;
    }

    public List<PConstraint> getConsSecondary() {
        return this.consSecondary;
    }

    public boolean isTrivial() {
        return this.getPrimary().equals((Object)this.getSecondary());
    }

    public boolean isCheckOnly() {
        return this.varPrimary.containsAll(this.varSecondary) || this.varSecondary.containsAll(this.varPrimary);
    }

    public boolean isDescartes() {
        return Collections.disjoint(this.varPrimary, this.varSecondary);
    }

    public boolean isHeath() {
        if (this.heath == null) {
            HashMap dependencies = new HashMap();
            for (PConstraint pConstraint : this.primary.getAllEnforcedConstraints()) {
                dependencies.putAll(pConstraint.getFunctionalDependencies());
            }
            for (PConstraint pConstraint : this.secondary.getAllEnforcedConstraints()) {
                dependencies.putAll(pConstraint.getFunctionalDependencies());
            }
            Set varCommonClosure = FunctionalDependencyHelper.closureOf(this.varCommon, dependencies);
            this.heath = varCommonClosure.containsAll(this.varPrimary) || varCommonClosure.containsAll(this.varSecondary);
        }
        return this.heath;
    }
}

