/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.edit.parts;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.core.edithelpers.CreateElementRequestAdapter;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DragDropEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewAndElementRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.IPapyrusNodeFigure;
import org.eclipse.papyrus.infra.gmfdiag.common.figure.node.SelectableBorderedNodeFigure;
import org.eclipse.papyrus.uml.diagram.clazz.custom.policies.ClassDiagramDragDropEditPolicy;
import org.eclipse.papyrus.uml.diagram.clazz.custom.policies.CustomGraphicalNodeEditPolicy;
import org.eclipse.papyrus.uml.diagram.clazz.custom.policies.itemsemantic.CustomClassItemSemanticEditPolicyCN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassAttributeCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassNameEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassNestedClassifierCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.ClassOperationCompartmentEditPartCN;
import org.eclipse.papyrus.uml.diagram.clazz.edit.parts.RedefinableTemplateSignatureEditPart;
import org.eclipse.papyrus.uml.diagram.clazz.edit.policies.ClassItemSemanticEditPolicyCN;
import org.eclipse.papyrus.uml.diagram.clazz.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.clazz.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.diagram.common.editparts.ClassifierEditPart;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.AppliedStereotypeNodeLabelDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.BorderItemResizableEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ConstrainedItemBorderLayoutEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.PapyrusCreationEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.QualifiedNameDisplayEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideClassifierContentsEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.editpolicies.ShowHideCompartmentEditPolicy;
import org.eclipse.papyrus.uml.diagram.common.figure.node.ClassifierFigure;
import org.eclipse.papyrus.uml.diagram.common.locator.TemplateBorderItemLocator;
import org.eclipse.swt.graphics.Color;

public class ClassEditPartCN
extends ClassifierEditPart {
    public static final int VISUAL_ID = 3010;
    protected IFigure contentPane;
    protected IFigure primaryShape;

    public ClassEditPartCN(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        this.installEditPolicy("CreationPolicy", (EditPolicy)new PapyrusCreationEditPolicy());
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new ClassItemSemanticEditPolicyCN());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new DragDropEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
        this.installEditPolicy("RESIZE_BORDER_ITEMS", (EditPolicy)new ConstrainedItemBorderLayoutEditPolicy());
        this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new CustomGraphicalNodeEditPolicy());
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new CustomClassItemSemanticEditPolicyCN());
        this.installEditPolicy("AppliedStereotypeLabelDisplayEditPolicy", (EditPolicy)new AppliedStereotypeNodeLabelDisplayEditPolicy());
        this.installEditPolicy("Qualified_name_editpolicy", (EditPolicy)new QualifiedNameDisplayEditPolicy());
        this.installEditPolicy("Show/Hide Compartment Policy", (EditPolicy)new ShowHideCompartmentEditPolicy());
        this.installEditPolicy("Show/Hide Classifier Contents Policy", (EditPolicy)new ShowHideClassifierContentsEditPolicy());
        this.installEditPolicy("DragDropPolicy", (EditPolicy)new ClassDiagramDragDropEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy lep = new org.eclipse.gmf.runtime.diagram.ui.editpolicies.LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                View childView = (View)child.getModel();
                switch (UMLVisualIDRegistry.getVisualID(childView)) {
                    case 3015: {
                        return new BorderItemResizableEditPolicy();
                    }
                }
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected void handleNotificationEvent(Notification event) {
        super.handleNotificationEvent(event);
        if (this.resolveSemanticElement() != null && this.resolveSemanticElement().equals(event.getNotifier()) && event.getFeature() instanceof EAttribute && ((EAttribute)event.getFeature()).getName().equals("isActive")) {
            this.getPrimaryShape().setActive(event.getNewBooleanValue());
            this.refreshVisuals();
        }
    }

    protected IFigure createNodeShape() {
        this.primaryShape = new ClassifierFigure();
        return this.primaryShape;
    }

    public ClassifierFigure getPrimaryShape() {
        return (ClassifierFigure)this.primaryShape;
    }

    protected boolean addFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ClassNameEditPartCN) {
            ((ClassNameEditPartCN)childEditPart).setLabel((IFigure)this.getPrimaryShape().getNameLabel());
            return true;
        }
        if (childEditPart instanceof ClassAttributeCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getAttributeCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((ClassAttributeCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ClassOperationCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getOperationCompartmentFigure();
            this.setupContentPane(pane);
            pane.add(((ClassOperationCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ClassNestedClassifierCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getNestedClassifierFigure();
            this.setupContentPane(pane);
            pane.add(((ClassNestedClassifierCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof RedefinableTemplateSignatureEditPart) {
            TemplateBorderItemLocator locator = new TemplateBorderItemLocator(this.getMainFigure(), 16);
            this.getBorderedFigure().getBorderItemContainer().add(((RedefinableTemplateSignatureEditPart)childEditPart).getFigure(), (Object)locator);
            return true;
        }
        return false;
    }

    protected boolean removeFixedChild(EditPart childEditPart) {
        if (childEditPart instanceof ClassNameEditPartCN) {
            return true;
        }
        if (childEditPart instanceof ClassAttributeCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getAttributeCompartmentFigure();
            pane.remove(((ClassAttributeCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ClassOperationCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getOperationCompartmentFigure();
            pane.remove(((ClassOperationCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof ClassNestedClassifierCompartmentEditPartCN) {
            IFigure pane = this.getPrimaryShape().getNestedClassifierFigure();
            pane.remove(((ClassNestedClassifierCompartmentEditPartCN)childEditPart).getFigure());
            return true;
        }
        if (childEditPart instanceof RedefinableTemplateSignatureEditPart) {
            this.getBorderedFigure().getBorderItemContainer().remove(((RedefinableTemplateSignatureEditPart)childEditPart).getFigure());
            return true;
        }
        return false;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        if (this.addFixedChild(childEditPart)) {
            return;
        }
        super.addChildVisual(childEditPart, -1);
    }

    protected void removeChildVisual(EditPart childEditPart) {
        if (this.removeFixedChild(childEditPart)) {
            return;
        }
        super.removeChildVisual(childEditPart);
    }

    protected IFigure getContentPaneFor(IGraphicalEditPart editPart) {
        if (editPart instanceof ClassAttributeCompartmentEditPartCN) {
            return this.getPrimaryShape().getAttributeCompartmentFigure();
        }
        if (editPart instanceof ClassOperationCompartmentEditPartCN) {
            return this.getPrimaryShape().getOperationCompartmentFigure();
        }
        if (editPart instanceof ClassNestedClassifierCompartmentEditPartCN) {
            return this.getPrimaryShape().getNestedClassifierFigure();
        }
        if (editPart instanceof IBorderItemEditPart) {
            return this.getBorderedFigure().getBorderItemContainer();
        }
        return this.getContentPane();
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(100, 100);
        return result;
    }

    protected NodeFigure createMainFigure() {
        return new SelectableBorderedNodeFigure((IFigure)this.createMainFigureWithSVG());
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(5);
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    protected void setForegroundColor(Color color) {
        if (this.primaryShape != null) {
            this.primaryShape.setForegroundColor(color);
        }
    }

    protected void setLineWidth(int width) {
        super.setLineWidth(width);
    }

    protected void setLineType(int style) {
        if (this.primaryShape instanceof IPapyrusNodeFigure) {
            ((IPapyrusNodeFigure)this.primaryShape).setLineStyle(style);
        }
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(5014));
    }

    public EditPart getTargetEditPart(Request request) {
        if (request instanceof CreateViewAndElementRequest) {
            CreateElementRequestAdapter adapter = ((CreateViewAndElementRequest)request).getViewAndElementDescriptor().getCreateElementRequestAdapter();
            IElementType type = (IElementType)adapter.getAdapter(IElementType.class);
            if (type == UMLElementTypes.Property_3012) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7011));
            }
            if (type == UMLElementTypes.Reception_3011) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7012));
            }
            if (type == UMLElementTypes.Operation_3013) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7012));
            }
            if (type == UMLElementTypes.Class_3014) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7013));
            }
            if (type == UMLElementTypes.Interface_3036) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7013));
            }
            if (type == UMLElementTypes.Enumeration_3052) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7013));
            }
            if (type == UMLElementTypes.PrimitiveType_3047) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7013));
            }
            if (type == UMLElementTypes.DataType_3044) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7013));
            }
            if (type == UMLElementTypes.Signal_3050) {
                return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(7013));
            }
        }
        return super.getTargetEditPart(request);
    }
}

