/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.clazz.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.diagram.clazz.edit.policies.UMLBaseItemSemanticEditPolicy;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.GeneralizationSet;
import org.eclipse.uml2.uml.Package;

public class GeneralizationSetReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public GeneralizationSetReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof GeneralizationSet)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof Generalization) || !(this.newEnd instanceof Generalization)) {
            return false;
        }
        if (this.getLink().getGeneralizations().size() != 1) {
            return false;
        }
        Generalization target = (Generalization)this.getLink().getGeneralizations().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistGeneralizationSet_4020(container, this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof Generalization) || !(this.newEnd instanceof Generalization)) {
            return false;
        }
        if (this.getLink().getGeneralizations().size() != 1) {
            return false;
        }
        Generalization source = (Generalization)this.getLink().getGeneralizations().get(0);
        if (!(this.getLink().eContainer() instanceof Package)) {
            return false;
        }
        Package container = (Package)this.getLink().eContainer();
        return UMLBaseItemSemanticEditPolicy.getLinkConstraints().canExistGeneralizationSet_4020(container, this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getLink().getGeneralizations().remove((Object)this.getOldSource());
        this.getLink().getGeneralizations().add((Object)this.getNewSource());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().getGeneralizations().remove((Object)this.getOldTarget());
        this.getLink().getGeneralizations().add((Object)this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected GeneralizationSet getLink() {
        return (GeneralizationSet)this.getElementToEdit();
    }

    protected Generalization getOldSource() {
        return (Generalization)this.oldEnd;
    }

    protected Generalization getNewSource() {
        return (Generalization)this.newEnd;
    }

    protected Generalization getOldTarget() {
        return (Generalization)this.oldEnd;
    }

    protected Generalization getNewTarget() {
        return (Generalization)this.newEnd;
    }
}

