/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.validate.ConstraintAdapter;
import org.eclipse.gmf.internal.validate.DebugOptions;
import org.eclipse.gmf.internal.validate.ExternModelImport;
import org.eclipse.gmf.internal.validate.LabelProvider;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.Trace;
import org.eclipse.gmf.internal.validate.expressions.EnvironmentProvider;
import org.eclipse.gmf.internal.validate.expressions.ExpressionProviderRegistry;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpressionProvider;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;
import org.eclipse.gmf.internal.validate.expressions.NoProviderExpression;
import org.eclipse.gmf.validate.ValidationOptions;
import org.eclipse.osgi.util.NLS;

class ExpressionCache {
    private final HashMap<EClass, List<ConstraintAdapter>> myClass2Constraints = new HashMap();

    public Validator get(EClass context, DiagnosticChain diag, ExternModelImport modelImports) {
        LinkedList<ConstraintAdapter> result = new LinkedList<ConstraintAdapter>();
        List<ConstraintAdapter> l = this.myClass2Constraints.get(context);
        if (l == null) {
            l = ExpressionCache.extract(context, diag, modelImports);
            this.myClass2Constraints.put(context, l);
        }
        result.addAll(l);
        for (EClass s : context.getEAllSuperTypes()) {
            l = this.myClass2Constraints.get(s);
            if (l == null) {
                l = ExpressionCache.extract(s, diag, modelImports);
                this.myClass2Constraints.put(s, l);
            }
            result.addAll(l);
        }
        if (result.isEmpty()) {
            return null;
        }
        return new Validator(result);
    }

    public static Validator get(EAnnotation ann, DiagnosticChain diag, ExternModelImport modelImports) {
        EClass contextClass;
        if (!"http://www.eclipse.org/gmf/2005/constraints".equals(ann.getSource())) {
            return null;
        }
        EModelElement e = ann.getEModelElement();
        Object object = e instanceof EClass ? (EClass)e : (contextClass = e instanceof EStructuralFeature ? ((EStructuralFeature)e).getEContainingClass() : null);
        if (contextClass != null) {
            List<ConstraintAdapter> r = ExpressionCache.extract(Collections.singletonList(ann), contextClass, diag, modelImports);
            if (r.isEmpty()) {
                return null;
            }
            return new Validator(r);
        }
        diag.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.gmf.validation", StatusCodes.INVALID_CONSTRAINT_CONTEXT, MessageFormat.format(Messages.validation_ConstraintInInvalidContext, LabelProvider.INSTANCE.getObjectLabel((EObject)e)), new Object[]{ann}));
        return null;
    }

    private static List<ConstraintAdapter> extract(EClass eClass, DiagnosticChain diag, ExternModelImport modelImports) {
        LinkedList<EAnnotation> constraintAnnotations = new LinkedList<EAnnotation>();
        for (EAnnotation a : eClass.getEAnnotations()) {
            if (!"http://www.eclipse.org/gmf/2005/constraints".equals(a.getSource())) continue;
            constraintAnnotations.add(a);
        }
        for (EOperation nextOperation : eClass.getEOperations()) {
            for (EAnnotation a : nextOperation.getEAnnotations()) {
                if (!"http://www.eclipse.org/gmf/2005/constraints".equals(a.getSource())) continue;
                constraintAnnotations.add(a);
            }
        }
        for (EStructuralFeature nextFeature : eClass.getEStructuralFeatures()) {
            for (EAnnotation a : nextFeature.getEAnnotations()) {
                if (!"http://www.eclipse.org/gmf/2005/constraints".equals(a.getSource())) continue;
                constraintAnnotations.add(a);
            }
        }
        return ExpressionCache.extract(constraintAnnotations, eClass, diag, modelImports);
    }

    private static List<ConstraintAdapter> extract(List<EAnnotation> constraintAnnotations, EClass eClass, DiagnosticChain diag, ExternModelImport modelImports) {
        if (constraintAnnotations.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ConstraintAdapter> result = new LinkedList<ConstraintAdapter>();
        for (EAnnotation ann : constraintAnnotations) {
            int severity = ExpressionCache.getDiagnosticSeverity(ann, diag);
            String description = ExpressionCache.getDescriptionDetail(ann);
            for (Map.Entry nextDetail : ann.getDetails()) {
                String body;
                String key = String.valueOf(nextDetail.getKey());
                if (!ExpressionProviderRegistry.getInstance().getLanguages().contains(key) || (body = ExpressionCache.readBodyDetail(nextDetail, diag)) == null) continue;
                IModelExpression expression = ExpressionCache.getExpression(key, body, (EClassifier)eClass, modelImports);
                ConstraintAdapter constraint = new ConstraintAdapter(expression, severity, description);
                result.add(constraint);
            }
        }
        return result;
    }

    private static IModelExpression getExpression(String language, String body, EClassifier context, ExternModelImport modelImports) {
        IModelExpressionProvider provider = ExpressionProviderRegistry.getInstance().getProvider(language);
        if (provider == null) {
            return new NoProviderExpression(language, body, context);
        }
        IParseEnvironment env = null;
        if (modelImports != null && modelImports.getPackageRegistry() != null) {
            env = EnvironmentProvider.createParseEnv();
            env.setImportRegistry(modelImports.getPackageRegistry());
        }
        return provider.createExpression(body, context, env);
    }

    private static int getDiagnosticSeverity(EAnnotation constraintAnnotation, DiagnosticChain diagnostics) {
        String strVal;
        int severity = 4;
        Object val = constraintAnnotation.getDetails().get((Object)"severity");
        String string = strVal = val instanceof String ? ((String)val).trim() : null;
        if ("info".equals(strVal)) {
            severity = 1;
        } else if ("warn".equals(strVal)) {
            severity = 2;
        } else if ("error".equals(strVal)) {
            severity = 4;
        } else if (strVal != null) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", StatusCodes.INVALID_CONSTRAINT_SEVERITY, NLS.bind((String)Messages.invalidConstraintSeverity, (Object[])new Object[]{strVal, "error", "warn", "info"}), new Object[]{val}));
        }
        return severity;
    }

    private static String getDescriptionDetail(EAnnotation annotation) {
        Object val = annotation.getDetails().get((Object)"description");
        return val != null ? String.valueOf(val) : null;
    }

    private static String readBodyDetail(Map.Entry<String, String> bodyEntry, DiagnosticChain diagnostics) {
        String body = bodyEntry.getValue();
        if (body != null && body.trim().length() > 0) {
            return body;
        }
        diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.gmf.validation", StatusCodes.EMPTY_CONSTRAINT_BODY, Messages.validation_EmptyExpressionBody, new Object[]{bodyEntry}));
        return null;
    }

    static class Validator {
        private final List<ConstraintAdapter> myConstraints;

        public Validator(List<ConstraintAdapter> constraints) {
            assert (constraints != null);
            this.myConstraints = constraints;
        }

        public boolean validate(EObject modelElement, DiagnosticChain diagnostics, ValidationOptions opts) {
            boolean isValid = true;
            for (ConstraintAdapter x : this.myConstraints) {
                isValid &= this.handleConstraintDefinition(x, diagnostics);
                isValid &= Validator.handleConstrainedElement(x, modelElement, diagnostics, opts);
            }
            return isValid;
        }

        public boolean checkConstraints(DiagnosticChain diagnostics) {
            boolean isValid = true;
            for (ConstraintAdapter constraint : this.myConstraints) {
                isValid &= this.handleConstraintDefinition(constraint, diagnostics);
            }
            return isValid;
        }

        private boolean handleConstraintDefinition(ConstraintAdapter constraintProxy, DiagnosticChain diagnostics) {
            IStatus constraintStatus = constraintProxy.getStatus();
            if (Trace.shouldTrace(DebugOptions.META_DEFINITIONS)) {
                String msgPtn = "[metamodel-constraint] context={0} body={1}";
                Trace.trace(MessageFormat.format(msgPtn, LabelProvider.INSTANCE.getObjectLabel((EObject)constraintProxy.getContext()), constraintProxy.getBody()));
            }
            if (!constraintStatus.isOK()) {
                String message = MessageFormat.format(Messages.invalidExpressionBody, constraintProxy.getBody(), constraintStatus.getMessage());
                diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.gmf.validation", constraintStatus.getCode(), message, new Object[]{constraintProxy.getContext()}));
                return false;
            }
            return true;
        }

        private static boolean handleConstrainedElement(ConstraintAdapter constraint, EObject constrainedElement, DiagnosticChain diagnostics, ValidationOptions opts) {
            if (!constraint.isSatisfied(constrainedElement)) {
                String message = null;
                message = constraint.getDescription() == null ? MessageFormat.format(Messages.validation_ConstraintViolation, constraint.getBody(), LabelProvider.INSTANCE.getObjectLabel(constrainedElement)) : constraint.getDescription();
                diagnostics.add((Diagnostic)new BasicDiagnostic(constraint.getSeverity(), "org.eclipse.gmf.validation", 225, message, new Object[]{constrainedElement}));
                return false;
            }
            if (opts.isReportSuccess()) {
                diagnostics.add((Diagnostic)new BasicDiagnostic(0, "org.eclipse.gmf.validation", 226, MessageFormat.format(Messages.validation_ConstraintSatisfied, constraint.getBody(), LabelProvider.INSTANCE.getObjectLabel(constrainedElement)), new Object[]{constrainedElement}));
            }
            return true;
        }
    }
}

