/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.notation.EObjectListValueStyle;
import org.eclipse.papyrus.infra.emf.databinding.EMFObservableList;
import org.eclipse.papyrus.infra.gmfdiag.css.notation.CSSDiagram;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddAllModelStyleSheetCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.AddModelStyleSheetCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.CustomModelStyleSheetListener;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.RemoveAllModelStyleSheetValueCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.properties.databinding.RemoveObjectCommand;
import org.eclipse.papyrus.infra.gmfdiag.css.stylesheets.ModelStyleSheets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelStyleSheetObservableList
extends EMFObservableList
implements IChangeListener {
    private Resource notationResource;
    private EditingDomain domain;
    private CustomModelStyleSheetListener listener;

    public ModelStyleSheetObservableList(Resource notationResource, List<?> wrappedList, EditingDomain domain, EObject source, EStructuralFeature feature) {
        super(wrappedList, domain, source, feature);
        this.notationResource = notationResource;
        this.domain = domain;
        this.listener = new CustomModelStyleSheetListener(notationResource, (ModelStyleSheets)source, this);
        source.eAdapters().add((Object)this.listener);
    }

    public Command getAddAllCommand(Collection<?> values) {
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.append(super.getAddAllCommand(values));
        compoundCommand.append((Command)new AddAllModelStyleSheetCommand((TransactionalEditingDomain)this.domain, this.notationResource, values));
        return compoundCommand;
    }

    public Command getRemoveCommand(Object value) {
        CompoundCommand compoundCommand = new CompoundCommand();
        compoundCommand.append(super.getRemoveCommand(value));
        EList objectsFromResource = this.notationResource.getContents();
        for (Object objectFromResource : objectsFromResource) {
            if (!(objectFromResource instanceof CSSDiagram)) continue;
            EList objectsFromDiagram = ((CSSDiagram)objectFromResource).getStyles();
            for (Object objectFromDiagram : objectsFromDiagram) {
                if (!(objectFromDiagram instanceof EObjectListValueStyle)) continue;
                for (Object styleSheetReference : ((EObjectListValueStyle)objectFromDiagram).getEObjectListValue()) {
                    if (value != styleSheetReference) continue;
                    compoundCommand.append((Command)new RemoveObjectCommand((TransactionalEditingDomain)this.domain, (EObject)styleSheetReference));
                    compoundCommand.append((Command)new AddModelStyleSheetCommand((TransactionalEditingDomain)this.domain, this.notationResource, (EObject)styleSheetReference));
                }
            }
        }
        return compoundCommand;
    }

    public Command getRemoveAllCommand(Collection<?> values) {
        return new RemoveAllModelStyleSheetValueCommand((TransactionalEditingDomain)this.domain, this.notationResource, values);
    }

    public void dispose() {
        this.source.eAdapters().remove((Object)this.listener);
        this.listener.dispose();
        this.listener = null;
        super.dispose();
    }
}

