/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.hyperlink.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.infra.core.editorsfactory.IPageIconsRegistry;
import org.eclipse.papyrus.infra.hyperlink.Activator;
import org.eclipse.papyrus.infra.hyperlink.helper.AbstractHyperLinkHelper;
import org.eclipse.papyrus.infra.hyperlink.helper.HyperLinkHelperFactory;
import org.eclipse.papyrus.infra.hyperlink.messages.Messages;
import org.eclipse.papyrus.infra.hyperlink.object.HyperLinkObject;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkManagerShell;
import org.eclipse.papyrus.infra.hyperlink.ui.AbstractHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.ui.DefaultHyperLinkTab;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkException;
import org.eclipse.papyrus.infra.hyperlink.util.HyperLinkTabsRegistrationUtil;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HyperLinkManagerShell
extends AbstractHyperLinkManagerShell {
    private static final String HYPER_LINK_SHELL_MEMENTO = "HYPER_LINK_SHELL_MEMENTO";
    private static final String LAST_TAB_USE_MEMENTO = "LAST_TAB_USE_MEMENTO";
    protected static final String LAST_GLOBAL_TAB_USED = "LAST_USED_MEMENTO";
    private CompoundCommand cmd;
    protected final List<HyperLinkObject> allhypHyperlinkObjects = new ArrayList<HyperLinkObject>();
    protected EModelElement view;
    protected EObject semanticElement;
    protected TransactionalEditingDomain transactionalEditingDomain;
    protected HyperLinkHelperFactory hyperLinkHelperFactory;

    public void setInput(List<HyperLinkObject> hyperLinkObjectList) {
        this.allhypHyperlinkObjects.clear();
        this.allhypHyperlinkObjects.addAll(hyperLinkObjectList);
        for (AbstractHyperLinkTab hyperLinkTab : this.tabList) {
            hyperLinkTab.setInput(this.allhypHyperlinkObjects);
        }
    }

    public HyperLinkManagerShell(IPageIconsRegistry editorFactoryRegistry, TransactionalEditingDomain domain, EModelElement semanticElement, EModelElement aview, HyperLinkHelperFactory hyperHelperFactory) {
        this.hyperLinkHelperFactory = hyperHelperFactory;
        this.view = aview;
        this.semanticElement = semanticElement;
        this.transactionalEditingDomain = domain;
        this.createHyperLinkShell();
        this.initializeFolder(null);
        this.getCancelButton().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkManagerShell.this.tabList.clear();
                HyperLinkManagerShell.this.getHyperLinkShell().close();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        SelectionListener okListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                HyperLinkManagerShell.this.executeOkButton();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.getOkButton().addSelectionListener(okListener);
    }

    protected void executeOkButton() {
        CompoundCommand myCommand = this.getCommand();
        myCommand.append((Command)HyperLinkHelperFactory.getEmptyAllHyperLinkCommand(this.transactionalEditingDomain, this.view));
        this.doAction();
        try {
            myCommand.append(this.hyperLinkHelperFactory.getAddHyperLinkCommand(this.transactionalEditingDomain, this.view, this.allhypHyperlinkObjects));
        }
        catch (HyperLinkException e) {
            Activator.log.error((Throwable)e);
        }
        Assert.isTrue((boolean)myCommand.canExecute());
        this.transactionalEditingDomain.getCommandStack().execute((Command)myCommand);
        this.closeDialog();
    }

    protected void doAction() {
        this.allhypHyperlinkObjects.clear();
        this.allhypHyperlinkObjects.addAll(this.getSelectedHyperLinkObjectCrossingTabs());
        for (HyperLinkObject hyperLink : this.allhypHyperlinkObjects) {
            hyperLink.setIsDefault(false);
        }
        DefaultHyperLinkTab defaultHyperLinkTab = this.getDefaultHyperLinkTab();
        int i = defaultHyperLinkTab.getDefaultHyperLinkObject().size() - 1;
        while (i >= 0) {
            HyperLinkObject hyperLinkObject = defaultHyperLinkTab.getDefaultHyperLinkObject().get(i);
            hyperLinkObject.setIsDefault(true);
            if (this.allhypHyperlinkObjects.contains(hyperLinkObject)) {
                this.allhypHyperlinkObjects.remove(hyperLinkObject);
                this.allhypHyperlinkObjects.add(0, hyperLinkObject);
            }
            --i;
        }
    }

    private void closeDialog() {
        this.saveCorrespondingTab();
        this.tabList.clear();
        this.getHyperLinkShell().close();
    }

    protected CompoundCommand getCommand() {
        if (this.cmd == null) {
            this.cmd = new CompoundCommand(Messages.HyperLinkManagerShell_HyperLinksCommands);
        }
        return this.cmd;
    }

    public void initializeFolder(AbstractHyperLinkHelper abstractHyperLinkHelper) {
        for (AbstractHyperLinkTab current : HyperLinkTabsRegistrationUtil.INSTANCE.getAllHyperLinkTab()) {
            current.init(this.getcTabFolder(), this.allhypHyperlinkObjects, this.semanticElement);
            this.tabList.add(current);
        }
        final DefaultHyperLinkTab defaultTab = this.getDefaultHyperLinkTab();
        defaultTab.getMainComposite().addListener(22, new Listener(){

            public void handleEvent(Event event) {
                defaultTab.setInput(HyperLinkManagerShell.this.getSelectedHyperLinkObjectCrossingTabs());
            }
        });
    }

    public void open() {
        Display display = Display.getCurrent();
        this.getHyperLinkShell().pack();
        this.getHyperLinkShell().open();
        this.selectLastTab();
        while (!this.getHyperLinkShell().isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    protected void saveCorrespondingTab() {
        IMemento rootMemento = HyperLinkManagerShell.getExistingHPMemento();
        IMemento memento = HyperLinkManagerShell.getLastTabUseMemento(rootMemento);
        if (this.semanticElement != null) {
            int selectionIndex = this.getcTabFolder().getSelectionIndex();
            memento.putInteger(this.semanticElement.eClass().getInstanceTypeName(), selectionIndex);
            memento.putInteger(LAST_GLOBAL_TAB_USED, selectionIndex);
        }
        HyperLinkManagerShell.saveMemento((XMLMemento)rootMemento, HYPER_LINK_SHELL_MEMENTO);
    }

    protected void selectLastTab() {
        IMemento rootMemento = HyperLinkManagerShell.getExistingHPMemento();
        Integer lastIndexUsed = null;
        if (this.semanticElement != null) {
            lastIndexUsed = HyperLinkManagerShell.getLastTabUseMemento(rootMemento, this.semanticElement.eClass().getInstanceTypeName());
        }
        if (lastIndexUsed == null && (lastIndexUsed = HyperLinkManagerShell.getLastTabUseMemento(rootMemento, LAST_GLOBAL_TAB_USED)) == null) {
            lastIndexUsed = 0;
        }
        try {
            this.getcTabFolder().setSelection(lastIndexUsed.intValue());
        }
        catch (IndexOutOfBoundsException e) {
            this.getcTabFolder().setSelection(0);
        }
    }

    public static void saveMemento(XMLMemento xmlMemento, String key) {
        StringWriter writer = new StringWriter();
        try {
            xmlMemento.save((Writer)writer);
            if (HyperLinkManagerShell.getPreferenceStore() != null) {
                HyperLinkManagerShell.getPreferenceStore().setValue(key, writer.toString());
            }
        }
        catch (IOException e) {
            Activator.log.error(Messages.HyperLinkManagerShell_InputOutputException, (Throwable)e);
        }
    }

    public static IMemento getExistingHPMemento() {
        String sValue = HyperLinkManagerShell.getPreferenceStore().getString(HYPER_LINK_SHELL_MEMENTO);
        try {
            if (sValue != null && !sValue.equals("")) {
                XMLMemento rootMemento = XMLMemento.createReadRoot((Reader)new StringReader(sValue));
                return rootMemento;
            }
            return XMLMemento.createWriteRoot((String)HYPER_LINK_SHELL_MEMENTO);
        }
        catch (WorkbenchException e) {
            Activator.log.error(Messages.HyperLinkManagerShell_ImpossibleToReadPreferences, (Throwable)e);
            return null;
        }
    }

    public static Integer getLastTabUseMemento(IMemento rootMemento, String elementSemanticHint) {
        IMemento lastTabUsedMemento = HyperLinkManagerShell.getLastTabUseMemento(rootMemento);
        if (lastTabUsedMemento != null) {
            return lastTabUsedMemento.getInteger(elementSemanticHint);
        }
        return null;
    }

    protected static IMemento getLastTabUseMemento(IMemento memento) {
        IMemento lastTabUsedMemento = memento.getChild(LAST_TAB_USE_MEMENTO);
        if (lastTabUsedMemento == null) {
            lastTabUsedMemento = memento.createChild(LAST_TAB_USE_MEMENTO);
        }
        return lastTabUsedMemento;
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public List<HyperLinkObject> getSelectedHyperLinkObjectCrossingTabs() {
        HashSet<HyperLinkObject> selectedObjects = new HashSet<HyperLinkObject>();
        for (AbstractHyperLinkTab current : this.tabList) {
            List<HyperLinkObject> tmp;
            if (current instanceof DefaultHyperLinkTab || (tmp = current.getHyperlinkObjects()) == null) continue;
            selectedObjects.addAll(tmp);
        }
        return new ArrayList<HyperLinkObject>(selectedObjects);
    }

    protected DefaultHyperLinkTab getDefaultHyperLinkTab() {
        int nbTab = 0;
        DefaultHyperLinkTab defaultHyperLinkTab = null;
        for (AbstractHyperLinkTab current : this.tabList) {
            if (!(current instanceof DefaultHyperLinkTab)) continue;
            defaultHyperLinkTab = (DefaultHyperLinkTab)current;
            ++nbTab;
        }
        Assert.isTrue((nbTab == 1 ? 1 : 0) != 0);
        Assert.isNotNull(defaultHyperLinkTab);
        return defaultHyperLinkTab;
    }
}

