/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.model.presentation;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecp.ide.view.service.IDEViewModelRegistry;
import org.eclipse.emf.ecp.view.editor.handler.ControlGenerator;
import org.eclipse.emf.ecp.view.model.presentation.IncludeViewModelProviderXmiFileExtensionPage;
import org.eclipse.emf.ecp.view.model.presentation.SelectEClassWizardPage;
import org.eclipse.emf.ecp.view.model.presentation.SelectEcorePage;
import org.eclipse.emf.ecp.view.model.presentation.ViewEditorPlugin;
import org.eclipse.emf.ecp.view.model.presentation.ViewModelWizardNewFileCreationPage;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewPackage;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.ServiceReference;

public class ViewModelWizard
extends Wizard
implements INewWizard {
    private static final String PLUGIN_ID = "org.eclipse.emf.ecp.view.model.presentation";
    private IFile selectedEcore;
    private List<ViewModelWizardNewFileCreationPage> fileCreationPages;
    private List<EClass> selectedEClasses;
    public static final List<String> FILE_EXTENSIONS = Collections.unmodifiableList(Arrays.asList(ViewEditorPlugin.INSTANCE.getString("_UI_ViewEditorFilenameExtensions").split("\\s*,\\s*")));
    public static final String FORMATTED_FILE_EXTENSIONS = ViewEditorPlugin.INSTANCE.getString("_UI_ViewEditorFilenameExtensions").replaceAll("\\s*,\\s*", ", ");
    protected VViewPackage viewPackage = VViewPackage.eINSTANCE;
    protected VViewFactory viewFactory = this.viewPackage.getViewFactory();
    private IncludeViewModelProviderXmiFileExtensionPage contributeToFileExtensionPage;
    protected IStructuredSelection selection;
    protected IWorkbench workbench;
    protected List<String> initialObjectNames;
    private SelectEcorePage selectEcorePage;
    private SelectEClassWizardPage selectEClassPage;

    public void setSelectedEcore(IFile selectedEcore) {
        this.selectedEcore = selectedEcore;
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
        this.setWindowTitle(ViewEditorPlugin.INSTANCE.getString("_UI_Wizard_label"));
        this.setDefaultPageImageDescriptor(ExtendedImageRegistry.INSTANCE.getImageDescriptor(ViewEditorPlugin.INSTANCE.getImage("full/wizban/NewView")));
    }

    protected Collection<String> getInitialObjectNames() {
        if (this.initialObjectNames == null) {
            this.initialObjectNames = new ArrayList<String>();
            for (EClassifier eClassifier : this.viewPackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                this.initialObjectNames.add(eClass.getName());
            }
            Collections.sort(this.initialObjectNames, CommonPlugin.INSTANCE.getComparator());
        }
        return this.initialObjectNames;
    }

    public void addPages() {
        this.selectEcorePage = new SelectEcorePage(PLUGIN_ID);
        this.addPage((IWizardPage)this.selectEcorePage);
        this.contributeToFileExtensionPage = new IncludeViewModelProviderXmiFileExtensionPage(PLUGIN_ID);
        this.addPage((IWizardPage)this.contributeToFileExtensionPage);
    }

    public IWizardPage getStartingPage() {
        if (this.selectedEcore == null) {
            return this.selectEcorePage;
        }
        this.selectEClassPage = new SelectEClassWizardPage();
        this.selectEClassPage.setSelectedEcore(this.selectedEcore);
        this.selectEClassPage.setPageComplete(true);
        this.addPage((IWizardPage)this.selectEClassPage);
        return this.selectEClassPage;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.selectEcorePage) {
            this.selectedEClasses = null;
            this.selectedEcore = this.selectEcorePage.getSelectedEcore();
            if (this.selectedEcore != null) {
                if (this.selectEClassPage == null) {
                    this.selectEClassPage = new SelectEClassWizardPage();
                    this.selectEClassPage.setPageComplete(true);
                    this.addPage((IWizardPage)this.selectEClassPage);
                }
                this.selectEClassPage.setSelectedEcore(this.selectedEcore);
                return this.selectEClassPage;
            }
            return null;
        }
        if (page == this.selectEClassPage) {
            this.selectedEClasses = this.selectEClassPage.getSelectedEClasses();
            this.fileCreationPages = new ArrayList<ViewModelWizardNewFileCreationPage>();
            if (this.selectedEClasses != null && !this.selectedEClasses.isEmpty()) {
                for (EClass eclass : this.selectedEClasses) {
                    ViewModelWizardNewFileCreationPage fileCreationPage = this.getNewFileCreationPage();
                    fileCreationPage.setEClass(eclass);
                    fileCreationPage.setWizard((IWizard)this);
                    this.fileCreationPages.add(fileCreationPage);
                }
                if (this.fileCreationPages.isEmpty()) {
                    return null;
                }
                return (IWizardPage)this.fileCreationPages.get(0);
            }
        } else if (ViewModelWizardNewFileCreationPage.class.isInstance(page)) {
            int i = this.fileCreationPages.indexOf(page);
            if (i < this.fileCreationPages.size() - 1) {
                return (IWizardPage)this.fileCreationPages.get(i + 1);
            }
            return this.contributeToFileExtensionPage;
        }
        return null;
    }

    private ViewModelWizardNewFileCreationPage getNewFileCreationPage() {
        ViewModelWizardNewFileCreationPage newFileCreationPage = new ViewModelWizardNewFileCreationPage("Whatever", this.selection);
        newFileCreationPage.setTitle(ViewEditorPlugin.INSTANCE.getString("_UI_ViewModelWizard_label"));
        newFileCreationPage.setDescription(ViewEditorPlugin.INSTANCE.getString("_UI_ViewModelWizard_description"));
        newFileCreationPage.setFileName(String.valueOf(ViewEditorPlugin.INSTANCE.getString("_UI_ViewEditorFilenameDefaultBase")) + "." + FILE_EXTENSIONS.get(0));
        return newFileCreationPage;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.selectEClassPage) {
            return this.selectEcorePage;
        }
        if (ViewModelWizardNewFileCreationPage.class.isInstance(page)) {
            return this.selectEClassPage;
        }
        return null;
    }

    public boolean canFinish() {
        if (this.selectEClassPage != null) {
            List<EClass> selectedClasses = this.selectEClassPage.getSelectedEClasses();
            return selectedClasses != null && !selectedClasses.isEmpty() && this.contributeToFileExtensionPage.isPageComplete();
        }
        return false;
    }

    public boolean performFinish() {
        try {
            WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor progressMonitor) {
                    try {
                        boolean generateViewModelControls = ViewModelWizard.this.selectEClassPage.isGenerateViewModelOptionSelected();
                        IDEViewModelRegistry registry = ViewModelWizard.getViewModelRegistry();
                        if (registry == null) {
                            ViewEditorPlugin.INSTANCE.log(new Status(4, ViewModelWizard.PLUGIN_ID, "No View Model Registry", null));
                            return;
                        }
                        try {
                            for (ViewModelWizardNewFileCreationPage filePage : ViewModelWizard.this.fileCreationPages) {
                                IFile modelFile = filePage.getModelFile();
                                VView view = registry.createViewModel(modelFile, filePage.getEClass(), ViewModelWizard.this.selectedEcore);
                                if (generateViewModelControls) {
                                    ControlGenerator.generateAllControls((VView)view);
                                }
                                if (ViewModelWizard.this.contributeToFileExtensionPage.isContributeToExtensionOptionSelected()) {
                                    ViewModelWizard.this.addContribution(modelFile);
                                }
                                ViewModelWizard.this.addToBuildProperties(modelFile);
                                IWorkbenchPage page = ViewModelWizard.this.workbench.getActiveWorkbenchWindow().getActivePage();
                                page.openEditor((IEditorInput)new FileEditorInput(modelFile), ViewModelWizard.this.workbench.getEditorRegistry().getDefaultEditor(modelFile.getFullPath().toString()).getId());
                            }
                        }
                        catch (Exception exception) {
                            ViewEditorPlugin.INSTANCE.log(exception);
                        }
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            };
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            return true;
        }
        catch (Exception exception) {
            ViewEditorPlugin.INSTANCE.log(exception);
            return false;
        }
    }

    protected void addToBuildProperties(IFile modelFile) {
        IProject project = modelFile.getProject();
        String projectRelPath = modelFile.getProjectRelativePath().toString();
        int lastPathDelimiter = projectRelPath.lastIndexOf("/");
        String path = lastPathDelimiter == -1 ? projectRelPath : projectRelPath.substring(0, projectRelPath.lastIndexOf("/") + 1);
        IFile buildFile = project.getFile("build.properties");
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(buildFile.getContents()));
            String line = null;
            StringBuffer contents = new StringBuffer();
            while ((line = in.readLine()) != null) {
                if (line.contains("bin.includes")) {
                    String entry;
                    int start;
                    boolean found = false;
                    while (line.contains(",\\")) {
                        start = line.indexOf("=");
                        if (start == -1) {
                            start = 0;
                        }
                        if ((entry = line.substring(start + 1, line.indexOf(",\\")).trim()).equals(path)) {
                            found = true;
                            break;
                        }
                        contents.append(String.valueOf(line) + "\n");
                        line = in.readLine();
                    }
                    if (!found) {
                        start = line.indexOf("=");
                        if (start == -1) {
                            start = 0;
                        }
                        if (!(entry = line.substring(start).trim()).equals(path)) {
                            contents.append(String.valueOf(path) + ",\\\n");
                        }
                    }
                }
                contents.append(String.valueOf(line) + "\n");
            }
            in.close();
            FileWriter out = new FileWriter(buildFile.getRawLocation().makeAbsolute().toFile());
            out.write(String.valueOf(contents));
            out.flush();
            out.close();
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ViewEditorPlugin.INSTANCE.log(new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            ViewEditorPlugin.INSTANCE.log(new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    protected void addContribution(IFile modelFile) {
        IProject project = modelFile.getProject();
        IFile pluginFile = project.getFile("plugin.xml");
        try {
            if (!pluginFile.exists()) {
                pluginFile.create((InputStream)new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<?eclipse version=\"3.4\"?>\n<plugin>\n</plugin>".getBytes()), true, null);
                project.refreshLocal(2, null);
            }
            BufferedReader in = new BufferedReader(new InputStreamReader(pluginFile.getContents()));
            String line = null;
            StringBuffer contents = new StringBuffer();
            boolean extensionAdded = false;
            while ((line = in.readLine()) != null) {
                int end;
                if (line.contains("org.eclipse.emf.ecp.view.model.provider.xmi.file")) {
                    String filePathAttribute;
                    end = line.indexOf("/>");
                    if (end != -1) {
                        filePathAttribute = "<file filePath=\"" + modelFile.getProjectRelativePath().toString() + "\"/>";
                        line = String.valueOf(line.substring(0, end)) + ">\n" + filePathAttribute + "\n</extension>\n" + line.substring(end + 2, line.length());
                    } else {
                        filePathAttribute = "<file filePath=\"" + modelFile.getProjectRelativePath().toString() + "\"/>";
                        line = line.concat("\n" + filePathAttribute + "\n");
                    }
                    extensionAdded = true;
                }
                if (line.contains("</plugin>") && !extensionAdded) {
                    end = line.indexOf("</plugin>");
                    line = String.valueOf(line.substring(0, end)) + "\n<extension  point=\"org.eclipse.emf.ecp.view.model.provider.xmi.file\">\n<file filePath=\"" + modelFile.getProjectRelativePath().toString() + "\"/>\n</extension>\n" + line.substring(end);
                }
                contents.append(String.valueOf(line) + "\n");
            }
            in.close();
            FileWriter out = new FileWriter(pluginFile.getRawLocation().makeAbsolute().toFile());
            out.write(String.valueOf(contents));
            out.flush();
            out.close();
            project.refreshLocal(2, null);
        }
        catch (CoreException e) {
            ViewEditorPlugin.INSTANCE.log(new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
        catch (IOException e) {
            ViewEditorPlugin.INSTANCE.log(new Status(4, PLUGIN_ID, e.getMessage(), (Throwable)e));
        }
    }

    public static IDEViewModelRegistry getViewModelRegistry() {
        ServiceReference serviceReference = ViewEditorPlugin.getPlugin().getBundle().getBundleContext().getServiceReference(IDEViewModelRegistry.class);
        if (serviceReference == null) {
            return null;
        }
        return (IDEViewModelRegistry)ViewEditorPlugin.getPlugin().getBundle().getBundleContext().getService(serviceReference);
    }

    public void setWorkbench(IWorkbench workbench) {
        this.workbench = workbench;
    }
}

