/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.ui.color;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.e4.ui.css.core.css2.CSS2ColorHelper;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

public class CSSSemanticHighlightingCalculator
implements ISemanticHighlightingCalculator {
    private final Map<String, String> ruleNameToID = new HashMap<String, String>();
    private final Set<String> fontNames = new HashSet<String>();

    public CSSSemanticHighlightingCalculator() {
        FontData[] fontData;
        this.ruleNameToID.put("CSSId", "CSSId");
        this.ruleNameToID.put("Class", "CSSClass");
        this.ruleNameToID.put("Attribute", "Attribute");
        this.ruleNameToID.put("Selector", "Selector");
        this.ruleNameToID.put("Combinator", "Selector");
        this.ruleNameToID.put("Declaration", "Property");
        this.ruleNameToID.put("Function", "Function");
        this.ruleNameToID.put("Name", "string");
        this.ruleNameToID.put("StringValue", "string");
        this.ruleNameToID.put("Uri", "string");
        this.ruleNameToID.put("HexColor", "HexColor");
        this.ruleNameToID.put("Length", "number");
        this.ruleNameToID.put("Percentage", "number");
        this.ruleNameToID.put("Frequency", "number");
        this.ruleNameToID.put("Ems", "number");
        this.ruleNameToID.put("Exs", "number");
        this.ruleNameToID.put("Angle", "number");
        this.ruleNameToID.put("Time", "number");
        this.ruleNameToID.put("Number", "number");
        FontData[] fontDataArray = fontData = Display.getCurrent().getFontList(null, true);
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData data = fontDataArray[n2];
            this.fontNames.add(data.getName().toLowerCase());
            ++n2;
        }
    }

    public void provideHighlightingFor(XtextResource resource, IHighlightedPositionAcceptor acceptor) {
        if (resource == null || resource.getParseResult() == null) {
            return;
        }
        ICompositeNode root = resource.getParseResult().getRootNode();
        for (INode node : root.getAsTreeIterable()) {
            if (!(node.getGrammarElement() instanceof RuleCall)) continue;
            RuleCall ruleCall = (RuleCall)node.getGrammarElement();
            String name = ruleCall.getRule().getName();
            String stringOrNameValue = null;
            if ("Name".equals(name)) {
                stringOrNameValue = node.getText();
            } else if ("StringValue".equals(name)) {
                stringOrNameValue = node.getText();
                stringOrNameValue = stringOrNameValue.substring(1, stringOrNameValue.length() - 1);
            }
            if (stringOrNameValue != null) {
                if (this.isFont(stringOrNameValue)) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Font"});
                    continue;
                }
                if (this.isColor(stringOrNameValue)) {
                    acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{"Color"});
                    continue;
                }
            }
            if (!this.ruleNameToID.containsKey(name)) continue;
            acceptor.addPosition(node.getOffset(), node.getLength(), new String[]{this.ruleNameToID.get(name)});
        }
    }

    public boolean isFont(String value) {
        return this.fontNames.contains(value.toLowerCase());
    }

    public boolean isColor(String value) {
        return CSS2ColorHelper.isColorName((String)value.toLowerCase());
    }
}

