/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;

public class Zone {
    public static final int defaultWidth = 200;
    public static final int defaultHeight = 100;
    public static final int defaultHeader = 13;
    public static final String ANNOTATION_KEY = "RegionAnnotationKey";
    public static final String ZONE_KEY = "RegionZoneKey";
    public static final String NONE = "";
    public static final String TOP = "T";
    public static final String RIGHT = "R";
    public static final String BOTTOM = "B";
    public static final String LEFT = "L";

    public static String copy(String s) {
        return new String(s);
    }

    public static void copyZone(View from, View to) {
        if (to.getEAnnotation(ANNOTATION_KEY) == null) {
            throw new IllegalArgumentException();
        }
        if (!to.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        String zone = Zone.copy(Zone.getZone(from));
        to.getEAnnotation(ANNOTATION_KEY).getDetails().put((Object)ZONE_KEY, (Object)zone);
    }

    public static void createRegionDefaultAnnotation(View region) {
        if (!Zone.isRegion(region)) {
            throw new IllegalArgumentException();
        }
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        eAnnotation.setEModelElement((EModelElement)region);
        eAnnotation.setSource(ANNOTATION_KEY);
        eAnnotation.getDetails().put((Object)ZONE_KEY, (Object)NONE);
    }

    public static int getAllowedResizeDirections(String s) {
        if (s == null) {
            return 0;
        }
        int direction = 0;
        if (Zone.hasLeftNeighbours(s)) {
            direction |= 8;
        }
        if (Zone.hasRightNeighbours(s)) {
            direction |= 0x10;
        }
        if (Zone.hasTopNeighbours(s)) {
            direction |= 1;
        }
        if (Zone.hasBottomNeighbours(s)) {
            direction |= 4;
        }
        return direction;
    }

    public static Rectangle getBounds(View view) {
        int x = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        int y = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        int width = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        int height = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        return new Rectangle(x, y, width, height);
    }

    public static int getHeight(View view) {
        int height = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
        return height;
    }

    public static List<View> getMatchingRegionsFromList(List<View> regionList, String initPattern, String excludingZoneInFinalPattern) {
        ArrayList<View> matchingRegions = new ArrayList<View>();
        for (View view : regionList) {
            String zoneLastPart;
            String zone = Zone.getZone(view);
            String string = zoneLastPart = zone.length() <= initPattern.length() ? NONE : zone.substring(initPattern.length());
            if (!zone.startsWith(initPattern) || zoneLastPart.contains(excludingZoneInFinalPattern)) continue;
            matchingRegions.add(view);
        }
        return matchingRegions;
    }

    public static List<View> getRegionBottomBorderInsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(TOP);
        String initPattern = String.valueOf(zone.substring(0, index)) + TOP;
        String excludingZoneInFinalPattern = TOP;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionBottomBorderOutsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(TOP);
        String initPattern = String.valueOf(zone.substring(0, index)) + BOTTOM;
        String excludingZoneInFinalPattern = BOTTOM;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionLeftBorderInsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(RIGHT);
        String initPattern = String.valueOf(zone.substring(0, index)) + RIGHT;
        String excludingZoneInFinalPattern = RIGHT;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionLeftBorderOutsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(RIGHT);
        String initPattern = String.valueOf(zone.substring(0, index)) + LEFT;
        String excludingZoneInFinalPattern = LEFT;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionRightBorderInsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(LEFT);
        String initPattern = String.valueOf(zone.substring(0, index)) + LEFT;
        String excludingZoneInFinalPattern = LEFT;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionRightBorderOutsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(LEFT);
        String initPattern = String.valueOf(zone.substring(0, index)) + RIGHT;
        String excludingZoneInFinalPattern = RIGHT;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionTopBorderInsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(BOTTOM);
        String initPattern = String.valueOf(zone.substring(0, index)) + BOTTOM;
        String excludingZoneInFinalPattern = BOTTOM;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static List<View> getRegionTopBorderOutsideNeighbours(View region) {
        String zone = Zone.getZone(region);
        int index = zone.lastIndexOf(BOTTOM);
        String initPattern = String.valueOf(zone.substring(0, index)) + TOP;
        String excludingZoneInFinalPattern = TOP;
        View stateMachineCompartment = (View)region.eContainer();
        ArrayList<View> regionList = new ArrayList<View>();
        for (Object child : stateMachineCompartment.getChildren()) {
            if (!(child instanceof View)) continue;
            regionList.add((View)child);
        }
        List<View> neighbours = Zone.getMatchingRegionsFromList(regionList, initPattern, excludingZoneInFinalPattern);
        return neighbours;
    }

    public static int getWidth(View view) {
        int width = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
        return width;
    }

    public static int getX(View view) {
        int x = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
        return x;
    }

    public static int getY(View view) {
        int y = (Integer)ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
        return y;
    }

    public static String getZone(View view) {
        if (view.getEAnnotation(ANNOTATION_KEY) == null) {
            return null;
        }
        if (!view.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        return (String)view.getEAnnotation(ANNOTATION_KEY).getDetails().get((Object)ZONE_KEY);
    }

    private static String getZoneCounterpart(String s) {
        String cs = s.substring(0, s.length() - 1);
        if (Zone.isRight(s)) {
            return Zone.setLeft(cs);
        }
        if (Zone.isLeft(s)) {
            return Zone.setRight(cs);
        }
        if (Zone.isBottom(s)) {
            return Zone.setTop(cs);
        }
        if (Zone.isTop(s)) {
            return Zone.setBottom(cs);
        }
        return s;
    }

    public static String getZoneFromLocationInRectangleWithAbsoluteCoordinates(Point location, Rectangle rect) {
        double d1 = (double)location.y - 1.0 * (double)rect.height / (double)rect.width * (double)(rect.x - location.x) - (double)rect.y - (double)rect.height;
        double d2 = (double)location.y + 1.0 * (double)rect.height / (double)rect.width * (double)(rect.x - location.x) - (double)rect.y;
        if (d1 <= 0.0 && d2 <= 0.0) {
            return TOP;
        }
        if (d1 <= 0.0 && d2 > 0.0) {
            return LEFT;
        }
        if (d1 > 0.0 && d2 <= 0.0) {
            return RIGHT;
        }
        if (d1 > 0.0 && d2 > 0.0) {
            return BOTTOM;
        }
        return NONE;
    }

    public static String getZoneFromLocationInRectangleWithLocalCoordinates(Point location, Rectangle rect) {
        double d1 = (double)location.y + 1.0 * (double)rect.height * (double)location.x / (double)rect.width - (double)rect.height;
        double d2 = (double)location.y - 1.0 * (double)rect.height * (double)location.x / (double)rect.width;
        if (d1 <= 0.0 && d2 <= 0.0) {
            return TOP;
        }
        if (d1 <= 0.0 && d2 > 0.0) {
            return LEFT;
        }
        if (d1 > 0.0 && d2 <= 0.0) {
            return RIGHT;
        }
        if (d1 > 0.0 && d2 > 0.0) {
            return BOTTOM;
        }
        return NONE;
    }

    public static boolean hasBottomNeighbours(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s.contains(TOP);
    }

    public static boolean hasLeftNeighbours(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s.contains(RIGHT);
    }

    public static boolean hasRightNeighbours(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s.contains(LEFT);
    }

    public static boolean hasTopNeighbours(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return s.contains(BOTTOM);
    }

    public static boolean isBottom(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(BOTTOM);
    }

    public static boolean isLeft(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(LEFT);
    }

    public static boolean isRegion(View view) {
        if (view == null) {
            return false;
        }
        return UMLVisualIDRegistry.getVisualID(view.getType()) == 3000;
    }

    public static boolean isRight(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(RIGHT);
    }

    public static boolean isStateMachine(View view) {
        if (view == null) {
            throw new IllegalArgumentException();
        }
        return UMLVisualIDRegistry.getVisualID(view.getType()) == 2000;
    }

    public static boolean isTop(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(TOP);
    }

    public static void resetRegionCounterpartZone(View region) {
        String zone = Zone.getZone(region);
        if (zone == null) {
            return;
        }
        String cZone = Zone.getZoneCounterpart(zone);
        View stateMachineCompartment = (View)region.eContainer();
        for (Object next : stateMachineCompartment.getChildren()) {
            View view;
            String currentZone;
            if (!(next instanceof View) || !(currentZone = Zone.getZone(view = (View)next)).startsWith(cZone)) continue;
            String initPart = currentZone.substring(0, cZone.length() - 1);
            String finalPart = currentZone.length() <= cZone.length() ? NONE : currentZone.substring(cZone.length());
            currentZone = String.valueOf(initPart) + finalPart;
            Zone.setZone(view, currentZone);
        }
    }

    public static String setBottom(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return String.valueOf(s) + BOTTOM;
    }

    public static void setBottom(View view) {
        if (view.getEAnnotation(ANNOTATION_KEY) == null) {
            throw new IllegalArgumentException();
        }
        if (!view.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        String currentZone = Zone.getZone(view);
        String zoneToSet = Zone.setBottom(currentZone);
        view.getEAnnotation(ANNOTATION_KEY).getDetails().put((Object)ZONE_KEY, (Object)zoneToSet);
    }

    public static void setBounds(View view, Rectangle bounds) {
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)bounds.x);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)bounds.y);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)bounds.width);
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)bounds.height);
    }

    public static void setHeight(View view, int height) {
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height(), (Object)height);
    }

    public static String setLeft(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return String.valueOf(s) + LEFT;
    }

    public static void setLeft(View view) {
        if (view.getEAnnotation(ANNOTATION_KEY) == null) {
            throw new IllegalArgumentException();
        }
        if (!view.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        String currentZone = Zone.getZone(view);
        String zoneToSet = Zone.setLeft(currentZone);
        view.getEAnnotation(ANNOTATION_KEY).getDetails().put((Object)ZONE_KEY, (Object)zoneToSet);
    }

    public static String setRight(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return String.valueOf(s) + RIGHT;
    }

    public static void setRight(View view) {
        if (view.getEAnnotation(ANNOTATION_KEY) == null) {
            throw new IllegalArgumentException();
        }
        if (!view.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        String currentZone = Zone.getZone(view);
        String zoneToSet = Zone.setRight(currentZone);
        view.getEAnnotation(ANNOTATION_KEY).getDetails().put((Object)ZONE_KEY, (Object)zoneToSet);
    }

    public static String setTop(String s) {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        return String.valueOf(s) + TOP;
    }

    public static void setTop(View view) {
        if (view.getEAnnotation(ANNOTATION_KEY) == null) {
            throw new IllegalArgumentException();
        }
        if (!view.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        String currentZone = Zone.getZone(view);
        String zoneToSet = Zone.setTop(currentZone);
        view.getEAnnotation(ANNOTATION_KEY).getDetails().put((Object)ZONE_KEY, (Object)zoneToSet);
    }

    public static void setWidth(View view, int width) {
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width(), (Object)width);
    }

    public static void setX(View view, int x) {
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X(), (Object)x);
    }

    public static void setY(View view, int y) {
        ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y(), (Object)y);
    }

    public static void setZone(View view, String zone) {
        if (view.getEAnnotation(ANNOTATION_KEY) == null) {
            throw new IllegalArgumentException();
        }
        if (!view.getEAnnotation(ANNOTATION_KEY).getDetails().containsKey((Object)ZONE_KEY)) {
            throw new IllegalArgumentException();
        }
        view.getEAnnotation(ANNOTATION_KEY).getDetails().put((Object)ZONE_KEY, (Object)zone);
    }
}

