/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine;

import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IHintedType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.commands.CreateBehavioredClassifierDiagramCommand;
import org.eclipse.papyrus.uml.diagram.common.commands.SemanticAdapter;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.helpers.Zone;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLDiagramEditorPlugin;
import org.eclipse.papyrus.uml.diagram.statemachine.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.ElementInitializers;
import org.eclipse.papyrus.uml.diagram.statemachine.providers.UMLElementTypes;
import org.eclipse.papyrus.uml.tools.utils.NamedElementUtil;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class CreateStateMachineDiagramCommand
extends CreateBehavioredClassifierDiagramCommand {
    private StateMachine stateMachine = null;
    public static final int defaultX = 30;
    public static final int defaultY = 30;
    public static final int defaultWidth = 700;
    public static final int defaultHeight = 300;
    public static final int defaultHeader = 13;

    protected EClass getBehaviorEClass() {
        return UMLPackage.eINSTANCE.getStateMachine();
    }

    protected String getDefaultDiagramName() {
        return "SmDiagram";
    }

    protected String getDiagramNotationID() {
        return "PapyrusUMLStateMachineDiagram";
    }

    protected PreferencesHint getPreferenceHint() {
        return UMLDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT;
    }

    protected void initializeDiagram(EObject diagram) {
        if (diagram instanceof Diagram) {
            Diagram diag = (Diagram)diagram;
            if (this.stateMachine != null) {
                diag.setElement((EObject)this.stateMachine);
                View stateMachineView = ViewService.getInstance().createView(Node.class, (IAdaptable)new EObjectAdapter((EObject)this.stateMachine), (View)diag, null, -1, true, this.getPreferenceHint());
                Zone.setX(stateMachineView, 30);
                Zone.setY(stateMachineView, 30);
                Zone.setWidth(stateMachineView, 700);
                Zone.setHeight(stateMachineView, 300);
                Node compartmentView = null;
                for (Object next : stateMachineView.getChildren()) {
                    if (!(next instanceof Node)) continue;
                    Node currentNode = (Node)next;
                    if (currentNode.getLayoutConstraint() == null) {
                        currentNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
                    }
                    if (UMLVisualIDRegistry.getVisualID(currentNode.getType()) == 2001) {
                        Zone.setWidth((View)currentNode, 700);
                        Zone.setHeight((View)currentNode, 13);
                        continue;
                    }
                    if (UMLVisualIDRegistry.getVisualID(currentNode.getType()) != 2002) continue;
                    Zone.setY((View)currentNode, 13);
                    Zone.setWidth((View)currentNode, 700);
                    Zone.setHeight((View)currentNode, 287);
                    compartmentView = currentNode;
                }
                Region region = null;
                EList regions = this.stateMachine.getRegions();
                if (regions.isEmpty()) {
                    region = UMLFactory.eINSTANCE.createRegion();
                    regions.add((Object)region);
                    region.setName(NamedElementUtil.getDefaultNameWithIncrement((EObject)region, (Collection)regions));
                } else {
                    region = (Region)this.stateMachine.getRegions().get(0);
                }
                SemanticAdapter regionAdaptable = new SemanticAdapter((EObject)region, null);
                String semanticHint = ((IHintedType)UMLElementTypes.Region_3000).getSemanticHint();
                if (compartmentView != null) {
                    Node regionNode = ViewService.getInstance().createNode((IAdaptable)regionAdaptable, (View)compartmentView, semanticHint, -1, this.getPreferenceHint());
                    if (regionNode.getLayoutConstraint() == null) {
                        regionNode.setLayoutConstraint((LayoutConstraint)NotationFactory.eINSTANCE.createBounds());
                    }
                    Zone.createRegionDefaultAnnotation((View)regionNode);
                    Zone.setWidth((View)regionNode, 700);
                    Zone.setHeight((View)regionNode, 287);
                }
            }
            diag.setName(this.getName());
        }
    }

    protected void initializeModel(EObject owner) {
        if (owner.eClass() == this.getBehaviorEClass()) {
            this.stateMachine = (StateMachine)owner;
        } else {
            this.stateMachine = UMLFactory.eINSTANCE.createStateMachine();
            if (owner instanceof BehavioredClassifier) {
                BehavioredClassifier behaviorClassifier = (BehavioredClassifier)owner;
                behaviorClassifier.getOwnedBehaviors().add((Object)this.stateMachine);
            } else if (owner instanceof Package) {
                Package pack = (Package)owner;
                pack.getPackagedElements().add((Object)this.stateMachine);
            }
            ElementInitializers.getInstance().init_StateMachine_2000(this.stateMachine);
        }
    }
}

