/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.workspace;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.location.ICheckoutSource;
import org.eclipse.emf.cdo.workspace.efs.CDOFS;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CheckoutAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    public IWorkbenchPart getPart() {
        return this.part;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void run(IAction action) {
        Object element;
        if (this.selection instanceof IStructuredSelection && (element = ((IStructuredSelection)this.selection).getFirstElement()) instanceof ICheckoutSource) {
            ICheckoutSource checkoutSource = (ICheckoutSource)element;
            String projectName = checkoutSource.getRepositoryLocation().getRepositoryName();
            this.checkout(checkoutSource, projectName);
        }
    }

    protected void checkout(final ICheckoutSource checkoutSource, final String projectName) {
        new Job("Checking out..."){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    CDOFS.checkout((ICheckoutSource)checkoutSource, (String)projectName, (IProgressMonitor)monitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException ex) {
                    ex.printStackTrace();
                    return ex.getStatus();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    return new Status(4, "org.eclipse.emf.cdo.ui.workspace", ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
        }.schedule();
    }
}

