/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.readonly;

import com.google.common.base.Optional;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.operations.IOperationApprover2;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.gmf.runtime.common.core.internal.command.ICommandWithSettableResult;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.infra.core.resource.IReadOnlyHandler2;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;
import org.eclipse.papyrus.infra.emf.readonly.ReadOnlyManager;
import org.eclipse.papyrus.infra.onefile.model.IPapyrusFile;
import org.eclipse.papyrus.infra.onefile.model.PapyrusModelHelper;
import org.eclipse.papyrus.infra.onefile.utils.OneFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyOneFileApprover
implements IOperationApprover2 {
    public IStatus proceedRedoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        return this.proceedExecuting(operation, history, info);
    }

    public IStatus proceedUndoing(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        return this.proceedExecuting(operation, history, info);
    }

    public IStatus proceedExecuting(IUndoableOperation operation, IOperationHistory history, IAdaptable info) {
        Optional ok;
        HashSet<URI> filesToCheckForLock = new HashSet<URI>();
        Set<IFile> affectedFiles = this.getAffectedFiles(operation);
        if (!affectedFiles.isEmpty()) {
            for (IFile affectedFile : affectedFiles) {
                if (affectedFile == null) continue;
                if (affectedFile.exists()) {
                    IPapyrusFile papFile = PapyrusModelHelper.getPapyrusModelFactory().createIPapyrusFile(affectedFile);
                    IFile[] iFileArray = OneFileUtils.getAssociatedFiles((IPapyrusFile)papFile);
                    int n = iFileArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile f = iFileArray[n2];
                        filesToCheckForLock.add(URI.createPlatformResourceURI((String)f.getFullPath().toString(), (boolean)true));
                        ++n2;
                    }
                    continue;
                }
                IPath path = affectedFile.getRawLocation();
                if (path == null) {
                    if (operation instanceof ICommand) {
                        this.setCommandResult((ICommand)operation, Status.CANCEL_STATUS);
                    }
                    return Status.CANCEL_STATUS;
                }
                File file = path.toFile();
                if (file == null || !file.exists() || file.canWrite()) continue;
                if (operation instanceof ICommand) {
                    this.setCommandResult((ICommand)operation, Status.CANCEL_STATUS);
                }
                return Status.CANCEL_STATUS;
            }
        }
        EditingDomain editingDomain = this.getEditingDomain(operation);
        URI[] filesToCheckForLockArray = filesToCheckForLock.toArray(new URI[filesToCheckForLock.size()]);
        IReadOnlyHandler2 roHandler = ReadOnlyManager.getReadOnlyHandler(editingDomain);
        if (((Boolean)roHandler.anyReadOnly(ReadOnlyAxis.anyAxis(), filesToCheckForLockArray).get()).booleanValue() && !((Boolean)(ok = roHandler.makeWritable(ReadOnlyAxis.anyAxis(), filesToCheckForLockArray)).get()).booleanValue()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected EditingDomain getEditingDomain(IUndoableOperation command) {
        TransactionalEditingDomain editingDomain = null;
        if (command instanceof AbstractEMFOperation) {
            editingDomain = ((AbstractEMFOperation)command).getEditingDomain();
        }
        if (editingDomain == null && command instanceof ICompositeCommand) {
            Iterator it = ((ICompositeCommand)command).iterator();
            while (editingDomain == null && it.hasNext()) {
                IUndoableOperation c = (IUndoableOperation)it.next();
                editingDomain = this.getEditingDomain(c);
            }
        }
        return editingDomain;
    }

    protected void setCommandResult(ICommand command, IStatus status) {
        if (command instanceof ICommandWithSettableResult) {
            ((ICommandWithSettableResult)command).internalSetResult(new CommandResult(status));
        }
    }

    protected Set<IFile> getAffectedFiles(IUndoableOperation operation) {
        Set<IFile> result = this.getAffectedFiles(operation, null);
        return result == null ? Collections.emptySet() : result;
    }

    protected Set<IFile> getAffectedFiles(IUndoableOperation operation, Set<IFile> result) {
        if (operation instanceof ICommand) {
            List files = ((ICommand)operation).getAffectedFiles();
            result = this.appendFiles(result, files);
        } else if (operation instanceof GMFtoEMFCommandWrapper) {
            result = this.getAffectedFiles((IUndoableOperation)((GMFtoEMFCommandWrapper)operation).getGMFCommand(), result);
        } else if (operation instanceof EMFCommandOperation) {
            result = this.getAffectedFiles(((EMFCommandOperation)operation).getCommand(), result);
        }
        return result;
    }

    private Set<IFile> appendFiles(Set<IFile> result, Collection<IFile> files) {
        if (files != null && !files.isEmpty()) {
            if (result == null) {
                result = new HashSet<IFile>(files);
            } else {
                result.addAll(files);
            }
        }
        return result;
    }

    protected Set<IFile> getAffectedFiles(Command command, Set<IFile> result) {
        if (command instanceof CompoundCommand) {
            for (Command next : ((CompoundCommand)command).getCommandList()) {
                result = this.getAffectedFiles(next, result);
            }
        } else if (command instanceof GMFtoEMFCommandWrapper) {
            result = this.getAffectedFiles((IUndoableOperation)((GMFtoEMFCommandWrapper)command).getGMFCommand(), result);
        }
        return result;
    }
}

