/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.modisco.workflow.internal.engine;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.gmt.modisco.workflow.Activator;
import org.eclipse.gmt.modisco.workflow.Messages;
import org.eclipse.gmt.modisco.workflow.WorkflowController;
import org.eclipse.gmt.modisco.workflow.WorkflowModel;
import org.eclipse.gmt.modisco.workflow.internal.engine.Utils;
import org.eclipse.gmt.modisco.workflow.internal.engine.WorkflowModelImpl;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Element;
import org.eclipse.gmt.modisco.workflow.modiscoworkflow.Workflow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class WorkflowControllerImpl
implements WorkflowController {
    @Override
    public String validate(WorkflowModel workflowModel) {
        String message = null;
        String unknownLaunch = this.verifyExistenz(workflowModel.getAllElements());
        if (unknownLaunch != null) {
            message = String.valueOf(Messages.WorkflowControllerImpl_launchConfigurationNotFound) + unknownLaunch;
        }
        if (this.verifyLoops(workflowModel.getAllElements(), workflowModel.getName())) {
            message = Messages.WorkflowControllerImpl_recursionError;
        }
        return message;
    }

    private String verifyExistenz(List<Element> allElements) {
        String unknownLaunch = null;
        for (Element element : allElements) {
            ILaunchConfiguration launch = Utils.getInstance().getLaunchConfigurationFromName(element.getName());
            if (launch != null) continue;
            unknownLaunch = element.getName();
            break;
        }
        return unknownLaunch;
    }

    private boolean verifyLoops(List<Element> elements, String name) {
        boolean loop = false;
        for (Element element : elements) {
            if (!(element instanceof Workflow)) continue;
            if (element.getName().equals(name)) {
                loop = true;
                break;
            }
            WorkflowModelImpl workflowModel = new WorkflowModelImpl();
            ILaunchConfiguration launch = Utils.getInstance().getLaunchConfigurationFromName(element.getName());
            if (launch == null) continue;
            workflowModel.initialization(launch);
            loop = this.verifyLoops(workflowModel.getAllElements(), name);
        }
        return loop;
    }

    @Override
    public boolean hasPotentialRecursion(String rootConfigName, ILaunchConfiguration launch) {
        boolean result = false;
        if (launch.getName().equals(rootConfigName)) {
            result = true;
        } else {
            try {
                String type = launch.getType().getIdentifier();
                if (type.equals("org.eclipse.gmt.modisco.workflow.workflowtransformation")) {
                    WorkflowModelImpl workflowModel = new WorkflowModelImpl();
                    workflowModel.initialization(launch);
                    result = this.verifyLoops(workflowModel.getAllElements(), rootConfigName);
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.gmt.modisco.workflow", Messages.WorkflowControllerImpl_unknownError, (Throwable)e);
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
        return result;
    }
}

