/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ext.swt;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ImageFileFormat {
    public static final ImageFileFormat GIF = new ImageFileFormat("GIF", 2);
    public static final ImageFileFormat JPEG = new ImageFileFormat("JPEG", 4);
    public static final ImageFileFormat JPG = new ImageFileFormat("JPG", 4);
    public static final ImageFileFormat BMP = new ImageFileFormat("BMP", 0);
    public static final ImageFileFormat SVG = new ImageFileFormat("SVG", 100);
    public static final ImageFileFormat PNG = new ImageFileFormat("PNG", 5);
    public static final ImageFileFormat[] VALUES = new ImageFileFormat[]{GIF, BMP, JPEG, JPG, SVG, PNG};
    private String name;

    private ImageFileFormat(String name, int ordinal) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    protected List<ImageFileFormat> getValues() {
        return Collections.unmodifiableList(Arrays.asList(VALUES));
    }

    public static ImageFileFormat getDefaultImageFormat() {
        return GIF;
    }

    public static ImageFileFormat resolveImageFormat(int ordinal) {
        return VALUES[ordinal];
    }

    public static ImageFileFormat resolveImageFormat(String imageFormat) {
        ImageFileFormat[] imageFileFormatArray = VALUES;
        int n = VALUES.length;
        int n2 = 0;
        while (n2 < n) {
            ImageFileFormat element = imageFileFormatArray[n2];
            if (element.getName().toLowerCase().equals(imageFormat.toLowerCase())) {
                return element;
            }
            ++n2;
        }
        return ImageFileFormat.getDefaultImageFormat();
    }
}

