/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.TablePackage;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractHideRevealAction;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;

public class HideRevealColumnsAction
extends AbstractHideRevealAction<DColumn> {
    private static final String ACTION_LABEL = "Hide/Show columns...";
    private static final String DIALOG_TITLE = "Hide/Show table columns";
    private static final String DIALOG_MESSAGE = "Uncheck columns to hide them:";

    public HideRevealColumnsAction(DTable dTable, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(dTable, ACTION_LABEL, DTableViewerManager.getImageRegistry().getDescriptor("table/hideReveal"), editingDomain, tableCommandFactory);
    }

    private ILabelProvider getLabelProvider() {
        return new DColumnLabelProvider();
    }

    private IStructuredContentProvider getContentProvider() {
        return new EListDColumnContentProvider();
    }

    @Override
    protected Collection<DColumn> getInitialVisibleElements() {
        return Collections2.filter(this.getAllElements(), (Predicate)new Predicate<DColumn>(){

            public boolean apply(DColumn input) {
                return input.isVisible();
            }
        });
    }

    @Override
    protected List<DColumn> getAllElements() {
        return this.getTable().getColumns();
    }

    @Override
    protected SelectionDialog createSelectionDialog() {
        return new ListSelectionDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), this.getAllElements(), this.getContentProvider(), this.getLabelProvider(), this.getTitle());
    }

    @Override
    protected String getSetVisibleMethodName() {
        return TablePackage.eINSTANCE.getDColumn_Visible().getName();
    }

    @Override
    protected String getMessage() {
        return DIALOG_MESSAGE;
    }

    @Override
    protected String getTitle() {
        return DIALOG_TITLE;
    }

    @Override
    protected boolean isVisibleElement(DColumn element) {
        return element.isVisible();
    }

    private static final class DColumnLabelProvider
    extends LabelProvider {
        private DColumnLabelProvider() {
        }

        public String getText(Object element) {
            String result = element instanceof DColumn ? ((DColumn)element).getLabel() : super.getText(element);
            return result;
        }
    }

    private static final class EListDColumnContentProvider
    implements IStructuredContentProvider {
        private EListDColumnContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = null;
            if (inputElement instanceof EList) {
                EList elements = (EList)inputElement;
                result = elements.toArray((Object[])new DColumn[elements.size()]);
            }
            return result;
        }
    }
}

