/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.collect.Lists;
import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.table.business.api.query.DLineQuery;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTableElement;
import org.eclipse.sirius.table.metamodel.table.description.DeleteLineTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.command.DeleteElementRecordingCommand;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;

public class DeleteLinesAction
extends Action {
    private static final String DELETE_LINE = "Delete line";
    private static final String DELETE_LINES = "Delete lines";
    private static final String TOOLTIP_LINE = "Delete the target semantic element";
    private static final String TOOLTIP_LINES = "Delete the target semantic elements";
    private final TransactionalEditingDomain editingDomain;
    private final ITableCommandFactory tableCommandFactory;
    private final Collection<DLine> lines = Lists.newArrayList();

    public DeleteLinesAction(TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(DELETE_LINE, DTableViewerManager.getImageRegistry().getDescriptor("table/delete"));
        this.editingDomain = editingDomain;
        this.tableCommandFactory = tableCommandFactory;
    }

    public void run() {
        super.run();
        CompoundCommand cc = new CompoundCommand();
        for (DLine line : this.lines) {
            cc.append((Command)new DeleteElementRecordingCommand(this.getEditingDomain(), this.getText(), this.tableCommandFactory, (DTableElement)line));
        }
        this.getEditingDomain().getCommandStack().execute((Command)cc);
        this.lines.clear();
    }

    private TransactionalEditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void setLines(Collection<DLine> linesToDelete) {
        this.lines.clear();
        if (linesToDelete != null) {
            this.lines.addAll(linesToDelete);
            if (linesToDelete.size() == 1) {
                this.setText(DELETE_LINE);
                this.setToolTipText(TOOLTIP_LINE);
                DeleteTool deleteTool = this.getDeleteTool(linesToDelete.iterator().next());
                if (deleteTool != null) {
                    this.setText(new IdentifiedElementQuery((IdentifiedElement)deleteTool).getLabel());
                    this.setToolTipText(deleteTool.getDocumentation());
                }
            } else if (linesToDelete.size() > 1) {
                this.setText(DELETE_LINES);
                this.setToolTipText(TOOLTIP_LINES);
            }
        }
    }

    public boolean canExecute() {
        boolean canExecute = !this.lines.isEmpty();
        for (DLine lineToDelete : this.lines) {
            boolean bl = canExecute = canExecute && new DLineQuery(lineToDelete).canBeDeleted();
            if (!canExecute) break;
        }
        return canExecute;
    }

    private DeleteTool getDeleteTool(DLine line) {
        DeleteLineTool tool = null;
        if (line != null && line.getOriginMapping() != null) {
            tool = line.getOriginMapping().getDelete();
        }
        return tool;
    }
}

