/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor.action;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractTransactionalTableAction;
import org.eclipse.ui.dialogs.SelectionDialog;

public abstract class AbstractHideRevealAction<T extends EObject>
extends AbstractTransactionalTableAction {
    public AbstractHideRevealAction(DTable dTable, String text, ImageDescriptor image, TransactionalEditingDomain editingDomain, ITableCommandFactory tableCommandFactory) {
        super(dTable, text, image, editingDomain, tableCommandFactory);
    }

    public void run() {
        Collection<T> visibleElements = this.getInitialVisibleElements();
        SelectionDialog dlg = this.createSelectionDialog();
        dlg.setBlockOnOpen(true);
        dlg.setTitle(this.getTitle());
        dlg.setMessage(this.getMessage());
        dlg.setInitialSelections(visibleElements.toArray());
        dlg.setHelpAvailable(false);
        dlg.open();
        if (dlg.getReturnCode() == 0 && dlg.getResult() != null) {
            ArrayList newVisibles = Lists.newArrayList((Object[])dlg.getResult());
            this.getEditingDomain().getCommandStack().execute((Command)new VisibilityChangeRecordingCommand(this.getEditingDomain(), "Set " + this.getSetVisibleMethodName() + " values", newVisibles));
        }
    }

    protected abstract String getSetVisibleMethodName();

    protected abstract Collection<T> getInitialVisibleElements();

    protected abstract String getTitle();

    protected abstract String getMessage();

    protected abstract List<T> getAllElements();

    protected abstract SelectionDialog createSelectionDialog();

    protected abstract boolean isVisibleElement(T var1);

    private class VisibilityChangeRecordingCommand
    extends RecordingCommand {
        private List<Object> newVisibles;

        public VisibilityChangeRecordingCommand(TransactionalEditingDomain domain, String label, List<Object> newVisibles) {
            super(domain, label);
            this.newVisibles = newVisibles;
        }

        protected void doExecute() {
            for (EObject element : AbstractHideRevealAction.this.getAllElements()) {
                boolean visible = this.newVisibles.contains(element);
                if (!(visible ^ AbstractHideRevealAction.this.isVisibleElement(element))) continue;
                AbstractHideRevealAction.this.getTableCommandFactory().buildSetValue(element, AbstractHideRevealAction.this.getSetVisibleMethodName(), (Object)visible).execute();
            }
        }
    }
}

