/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.ui.tools.internal.command.ChangeColumnWidthCommand;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableViewerManager;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableEditorUtil;
import org.eclipse.sirius.table.ui.tools.internal.editor.utils.TreeColumnWidthQuery;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;

public class RefreshAtOpeningActivator
implements IPartListener {
    private AbstractDTableEditor abstractDTableEditor;
    private boolean enablePropertiesRefreshOnNextActivate;
    private Session session;
    private DTable dTable;
    private Tree tree;

    public RefreshAtOpeningActivator(Session session, AbstractDTableEditor abstractDTableEditor) {
        this.session = session;
        this.abstractDTableEditor = abstractDTableEditor;
        this.dTable = abstractDTableEditor.getTableModel();
        this.tree = (Tree)abstractDTableEditor.getControl();
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this.abstractDTableEditor && this.enablePropertiesRefreshOnNextActivate) {
            this.refreshDTableModelFromTreeColumnWidth();
            this.abstractDTableEditor.enablePropertiesUpdate(true);
            this.abstractDTableEditor.forceRefreshProperties();
            this.enablePropertiesRefreshOnNextActivate = false;
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        if (part == this.abstractDTableEditor) {
            this.enablePropertiesRefreshOnNextActivate = true;
        }
    }

    private void refreshDTableModelFromTreeColumnWidth() {
        if (DialectUIManager.INSTANCE.isRefreshActivatedOnRepresentationOpening()) {
            CompoundCommand refreshDTableAtOpeningCmd = new CompoundCommand("refresh table model at opening");
            TreeColumn[] treeColumns = this.tree.getColumns();
            TreeColumn treeColumn = treeColumns[0];
            TreeColumnWidthQuery treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
            Display.getDefault().syncExec((Runnable)((Object)treeColumnWidthQuery));
            int widgetWidth = (Integer)treeColumnWidthQuery.getResult();
            if (this.dTable.getHeaderColumnWidth() != widgetWidth && this.session.getModelAccessor().getPermissionAuthority().canEditInstance((EObject)this.dTable)) {
                ChangeColumnWidthCommand changeColumnWidthCommand = new ChangeColumnWidthCommand(this.session, widgetWidth, this.dTable);
                refreshDTableAtOpeningCmd.append((Command)changeColumnWidthCommand);
            }
            int i = 1;
            while (i < treeColumns.length) {
                treeColumn = treeColumns[i];
                DColumn dColumn = (DColumn)treeColumn.getData("org.eclipse.sirius.table.ui.dTableColumn");
                treeColumnWidthQuery = new TreeColumnWidthQuery(treeColumn);
                Display.getDefault().syncExec((Runnable)((Object)treeColumnWidthQuery));
                widgetWidth = (Integer)treeColumnWidthQuery.getResult();
                if (dColumn.isVisible() && dColumn.getWidth() != widgetWidth && this.session.getModelAccessor().getPermissionAuthority().canEditInstance((EObject)dColumn) && (!DTableViewerManager.IS_GTK_OS || !DTableEditorUtil.isLastColumn(treeColumn))) {
                    ChangeColumnWidthCommand changeColumnWidthCommand = new ChangeColumnWidthCommand(this.session, widgetWidth, dColumn);
                    refreshDTableAtOpeningCmd.append((Command)changeColumnWidthCommand);
                }
                ++i;
            }
            if (refreshDTableAtOpeningCmd.canExecute()) {
                this.session.getTransactionalEditingDomain().getCommandStack().execute((Command)refreshDTableAtOpeningCmd);
            }
        }
    }
}

