/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.table.ui.tools.internal.editor;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.DslCommonPlugin;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.table.business.api.helper.TableHelper;
import org.eclipse.sirius.table.metamodel.table.DColumn;
import org.eclipse.sirius.table.metamodel.table.DFeatureColumn;
import org.eclipse.sirius.table.metamodel.table.DLine;
import org.eclipse.sirius.table.metamodel.table.DTable;
import org.eclipse.sirius.table.metamodel.table.DTargetColumn;
import org.eclipse.sirius.table.metamodel.table.description.CreateTool;
import org.eclipse.sirius.table.metamodel.table.description.CrossTableDescription;
import org.eclipse.sirius.table.metamodel.table.description.DeleteColumnTool;
import org.eclipse.sirius.table.metamodel.table.description.DeleteTool;
import org.eclipse.sirius.table.metamodel.table.description.ElementColumnMapping;
import org.eclipse.sirius.table.metamodel.table.description.LineMapping;
import org.eclipse.sirius.table.metamodel.table.description.TableDescription;
import org.eclipse.sirius.table.metamodel.table.description.TableMapping;
import org.eclipse.sirius.table.metamodel.table.provider.TableUIPlugin;
import org.eclipse.sirius.table.tools.api.command.ITableCommandFactory;
import org.eclipse.sirius.table.ui.tools.internal.editor.AbstractDTableEditor;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableMenuListener;
import org.eclipse.sirius.table.ui.tools.internal.editor.DTableTreeViewer;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.AbstractToolAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateLineAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.CreateTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.DeleteTargetColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.EditorCreateLineMenuAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.EditorCreateTargetColumnMenuAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.action.SortLinesByColumnAction;
import org.eclipse.sirius.table.ui.tools.internal.editor.listeners.DTableViewerListener;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DFeatureColumnEditingSupport;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableColumnHeaderLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableContentProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableDecoratingLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTableLineLabelProvider;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.DTargetColumnEditingSupport;
import org.eclipse.sirius.table.ui.tools.internal.editor.provider.TableUIUpdater;
import org.eclipse.sirius.tools.api.command.ICommandFactory;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTableViewerManager;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeEditor;
import org.eclipse.sirius.ui.tools.internal.editor.AbstractDTreeViewer;
import org.eclipse.sirius.ui.tools.internal.editor.DTableColumnViewerEditorActivationStrategy;
import org.eclipse.sirius.ui.tools.internal.editor.DTableTreeFocusListener;
import org.eclipse.sirius.ui.tools.internal.views.common.navigator.adapters.ModelDragTargetAdapter;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class DTableViewerManager
extends AbstractDTableViewerManager {
    public static final String EXPORT_IMG = "table/export";
    public static final String HIDE_IMG = "table/hide";
    public static final String REVEAL_IMG = "table/reveal";
    public static final String DELETE_IMG = "table/delete";
    public static final String CREATE_LINE = "table/newLine";
    public static final String CREATE_COLUMN = "table/newColumn";
    public static final String REFRESH_IMG = "table/refresh";
    public static final String SHOW_PROPERTIES_VIEW = "table/prop_ps";
    public static final String SORT_BY_LINE = "table/sortByLine";
    public static final String SORT_BY_COLUMN = "table/sortByColumn";
    public static final String HIDE_REVEAL_IMG = "table/hideReveal";
    public static final String TABLE_COLUMN_DATA = "org.eclipse.sirius.table.ui.dTableColumn";
    private static ImageRegistry imageRegistry = new ImageRegistry();
    private DTableViewerListener tableViewerListener;
    private ITableCommandFactory tableCommandFactory;
    private EditorCreateLineMenuAction createLineMenu = new EditorCreateLineMenuAction();
    private EditorCreateTargetColumnMenuAction createTargetColumnMenu = new EditorCreateTargetColumnMenuAction();
    private TableUIUpdater tableUIUpdater;
    private DTableContentProvider dTableContentProvider;
    private DTableMenuListener actualMenuListener;
    private int sortDirection = 0;
    private DColumn sortedBy;

    static {
        imageRegistry.put(HIDE_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(HIDE_IMG))));
        imageRegistry.put(REVEAL_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(REVEAL_IMG))));
        imageRegistry.put(DELETE_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(DELETE_IMG))));
        imageRegistry.put(REFRESH_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(REFRESH_IMG))));
        imageRegistry.put(CREATE_LINE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(CREATE_LINE))));
        imageRegistry.put(CREATE_COLUMN, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(CREATE_COLUMN))));
        imageRegistry.put(SHOW_PROPERTIES_VIEW, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(SHOW_PROPERTIES_VIEW))));
        imageRegistry.put(SORT_BY_LINE, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(SORT_BY_LINE))));
        imageRegistry.put(SORT_BY_COLUMN, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(SORT_BY_COLUMN))));
        imageRegistry.put(HIDE_REVEAL_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(HIDE_REVEAL_IMG))));
        imageRegistry.put(EXPORT_IMG, ImageDescriptor.createFromURL((URL)((URL)TableUIPlugin.INSTANCE.getImage(EXPORT_IMG))));
    }

    public DTableViewerManager(Composite parent, DTable dTable, TransactionalEditingDomain editingDomain, ModelAccessor accessor, ITableCommandFactory tableCommandFactory, AbstractDTableEditor tableEditor) {
        super(parent, (DRepresentation)dTable, editingDomain, accessor, (ICommandFactory)tableCommandFactory, (AbstractDTreeEditor)tableEditor);
        this.tableCommandFactory = tableCommandFactory;
        this.tableViewerListener = new DTableViewerListener(this, this.getSession());
        this.createTreeViewer(parent);
    }

    private Session getSession() {
        return SessionManager.INSTANCE.getSession(((DTable)this.dRepresentation).getTarget());
    }

    public static ImageRegistry getImageRegistry() {
        return imageRegistry;
    }

    protected void createTreeViewer(Composite composite) {
        GridData gridData = new GridData(1808);
        composite.setLayoutData((Object)gridData);
        TreeColumnLayout treeLayout = new TreeColumnLayout();
        composite.setLayout((Layout)treeLayout);
        this.treeViewer = new DTableTreeViewer(composite, 66306, this);
        this.treeViewer.getTree().addFocusListener((FocusListener)new DTableTreeFocusListener(this.tableEditor, this.treeViewer.getTree()));
        this.initializeDragSupport();
        this.sortListener = new SortListener();
        DslCommonPlugin.PROFILER.startWork("Add a column in the SWT table");
        TreeViewerColumn headerTreeColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 0x1000000, 0);
        DslCommonPlugin.PROFILER.startWork("Set the column name in the SWT table");
        headerTreeColumn.getColumn().setText("");
        DslCommonPlugin.PROFILER.stopWork("Set the column name in the SWT table");
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        DTableLineLabelProvider lineheaderColumnLabelProvider = new DTableLineLabelProvider(decorator){

            public Color getBackground(Object element) {
                if (IS_GTK_OS) {
                    return Display.getCurrent().getSystemColor(19);
                }
                return Display.getCurrent().getSystemColor(19);
            }
        };
        headerTreeColumn.setLabelProvider((CellLabelProvider)lineheaderColumnLabelProvider);
        int headerColumnWidth = ((DTable)this.dRepresentation).getHeaderColumnWidth();
        if (headerColumnWidth != 0) {
            treeLayout.setColumnData((Widget)headerTreeColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(headerColumnWidth));
            if (headerTreeColumn.getColumn().getWidth() != headerColumnWidth) {
                headerTreeColumn.getColumn().setWidth(headerColumnWidth);
            }
        } else {
            treeLayout.setColumnData((Widget)headerTreeColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
            if (IS_GTK_OS) {
                headerTreeColumn.getColumn().pack();
            }
        }
        headerTreeColumn.getColumn().addListener(13, this.sortListener);
        DslCommonPlugin.PROFILER.stopWork("Add a column in the SWT table");
        int index = 1;
        for (DColumn column : ((DTable)this.dRepresentation).getColumns()) {
            this.addNewColumn(column, index++);
        }
        this.treeViewer.setUseHashlookup(true);
        this.tableUIUpdater = new TableUIUpdater(this);
        this.dTableContentProvider = new DTableContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)this.dTableContentProvider);
        this.treeViewer.setInput((Object)this.dRepresentation);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.fillMenu();
        this.triggerColumnSelectedColumn();
        this.treeViewer.setExpandedElements(TableHelper.getExpandedLines((DTable)((DTable)this.dRepresentation)).toArray());
        int i = 0;
        while (i < this.treeViewer.getTree().getColumnCount()) {
            Object data = this.treeViewer.getTree().getColumn(i).getData("org.eclipse.jface.LAYOUT_DATA");
            if (data instanceof ColumnWeightData) {
                this.treeViewer.getTree().getColumn(i).pack();
            }
            ++i;
        }
        this.treeViewer.addTreeListener((ITreeViewerListener)this.tableViewerListener);
        this.triggerCustomDrawingTreeItems();
        TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager((TreeViewer)this.treeViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.treeViewer));
        TreeViewerEditor.create((TreeViewer)this.treeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)new DTableColumnViewerEditorActivationStrategy((ColumnViewer)this.treeViewer), (int)58);
        headerTreeColumn.getColumn().addControlListener((ControlListener)this.tableViewerListener);
    }

    protected void initializeDragSupport() {
        int supportedOperations = 6;
        AbstractDTreeViewer selectionProvider = this.treeViewer;
        this.treeViewer.addDragSupport(supportedOperations, (Transfer[])new ByteArrayTransfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ModelDragTargetAdapter((ISelectionProvider)selectionProvider));
    }

    public void fillMenu() {
        if (this.descriptionFileChanged) {
            this.descriptionFileChanged = false;
            HashMap mappingToDeleteActions = Maps.newHashMap();
            HashMap mappingToCreateActions = Maps.newHashMap();
            ArrayList createActionsForTable = Lists.newArrayList();
            this.calculateAvailableMenus(mappingToDeleteActions, mappingToCreateActions, createActionsForTable);
            this.mgr.setRemoveAllWhenShown(true);
            if (this.actualMenuListener != null) {
                this.mgr.removeAll();
                this.actualMenuListener.setMappingToCreateActions(mappingToCreateActions);
                this.actualMenuListener.setMappingToDeleteActions(mappingToDeleteActions);
                this.actualMenuListener.setCreateActionsForTable(createActionsForTable);
            } else {
                this.actualMenuListener = new DTableMenuListener((DTable)this.dRepresentation, this, mappingToCreateActions, mappingToDeleteActions, createActionsForTable);
                this.mgr.addMenuListener((IMenuListener)this.actualMenuListener);
                Menu menu = this.mgr.createContextMenu(this.treeViewer.getControl());
                this.treeViewer.getControl().setMenu(menu);
                this.tableEditor.getSite().registerContextMenu(this.mgr, (ISelectionProvider)this.treeViewer);
            }
            this.getCreateLineMenu().update(createActionsForTable);
            this.getCreateTargetColumnMenu().update(createActionsForTable);
        }
    }

    private void calculateAvailableMenus(Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteActions, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions, List<AbstractToolAction> createActionsForTable) {
        TableDescription tableDescription = ((DTable)this.dRepresentation).getDescription();
        if (tableDescription != null) {
            this.calculateAvailableMenusForLine((EList<LineMapping>)tableDescription.getAllLineMappings(), mappingToCreateActions, new ArrayList<LineMapping>());
            EList createLineTools = tableDescription.getAllCreateLine();
            for (CreateTool createTool : createLineTools) {
                CreateLineAction createLineAction = new CreateLineAction(createTool, this.getEditingDomain(), this.getTableCommandFactory());
                createLineAction.setTable((DTable)this.dRepresentation);
                createActionsForTable.add(createLineAction);
            }
            if (tableDescription instanceof CrossTableDescription) {
                this.calculateAvailableMenusForColumn((EList<ElementColumnMapping>)((CrossTableDescription)tableDescription).getOwnedColumnMappings(), mappingToDeleteActions, mappingToCreateActions);
                EList createColumnsTools = ((CrossTableDescription)tableDescription).getCreateColumn();
                for (CreateTool createTool : createColumnsTools) {
                    CreateTargetColumnAction createTargetColumnAction = new CreateTargetColumnAction(createTool, this.getEditingDomain(), this.getTableCommandFactory());
                    createTargetColumnAction.setTable((DTable)this.dRepresentation);
                    createActionsForTable.add(createTargetColumnAction);
                }
            }
        }
    }

    private void calculateAvailableMenusForColumn(EList<ElementColumnMapping> columnMappings, Map<TableMapping, DeleteTargetColumnAction> mappingToDeleteActions, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions) {
        for (ElementColumnMapping mapping : columnMappings) {
            if (mapping == null || mappingToDeleteActions.keySet().contains(mapping) || mappingToCreateActions.keySet().contains(mapping)) continue;
            DeleteColumnTool deleteTool = mapping.getDelete();
            mappingToDeleteActions.put((TableMapping)mapping, new DeleteTargetColumnAction((DeleteTool)deleteTool, this.getEditingDomain(), this.tableCommandFactory));
            EList createTools = mapping.getCreate();
            List<AbstractToolAction> existingCreateTools = mappingToCreateActions.get(mapping);
            if (existingCreateTools == null) {
                existingCreateTools = new ArrayList<AbstractToolAction>();
            }
            for (CreateTool createTool : createTools) {
                existingCreateTools.add(new CreateTargetColumnAction(createTool, this.getEditingDomain(), this.tableCommandFactory));
            }
            mappingToCreateActions.put((TableMapping)mapping, existingCreateTools);
        }
    }

    private void calculateAvailableMenusForLine(EList<LineMapping> lineMappings, Map<TableMapping, List<AbstractToolAction>> mappingToCreateActions, List<LineMapping> processedLineMappings) {
        for (LineMapping lineMapping : lineMappings) {
            if (lineMapping != null && !mappingToCreateActions.keySet().contains(lineMapping)) {
                EList createTools = lineMapping.getCreate();
                List<AbstractToolAction> existingCreateTools = mappingToCreateActions.get(lineMapping);
                if (existingCreateTools == null) {
                    existingCreateTools = new ArrayList<AbstractToolAction>();
                }
                for (CreateTool createTool : createTools) {
                    existingCreateTools.add(new CreateLineAction(createTool, this.getEditingDomain(), this.getTableCommandFactory()));
                }
                mappingToCreateActions.put((TableMapping)lineMapping, existingCreateTools);
            }
            if (lineMapping == null || processedLineMappings.contains(lineMapping)) continue;
            processedLineMappings.add(lineMapping);
            this.calculateAvailableMenusForLine((EList<LineMapping>)lineMapping.getAllSubLines(), mappingToCreateActions, processedLineMappings);
        }
    }

    private void triggerColumnSelectedColumn() {
        this.treeViewer.getTree().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent event) {
                int x = 0;
                int i = 0;
                while (i < DTableViewerManager.this.treeViewer.getTree().getColumnCount()) {
                    if (event.x <= (x += DTableViewerManager.this.treeViewer.getTree().getColumn(i).getWidth())) {
                        DTableViewerManager.this.activeColumn = i;
                        break;
                    }
                    ++i;
                }
            }
        });
        this.treeViewer.getTree().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000003 && DTableViewerManager.this.activeColumn != 0) {
                    DTableViewerManager dTableViewerManager = DTableViewerManager.this;
                    dTableViewerManager.activeColumn = dTableViewerManager.activeColumn - 1;
                    DTableViewerManager.this.treeViewer.getTree().showColumn(DTableViewerManager.this.treeViewer.getTree().getColumn(DTableViewerManager.this.activeColumn));
                } else if (e.keyCode == 0x1000004 && DTableViewerManager.this.activeColumn != DTableViewerManager.this.treeViewer.getTree().getColumnCount() - 1) {
                    DTableViewerManager dTableViewerManager = DTableViewerManager.this;
                    dTableViewerManager.activeColumn = dTableViewerManager.activeColumn + 1;
                    DTableViewerManager.this.treeViewer.getTree().showColumn(DTableViewerManager.this.treeViewer.getTree().getColumn(DTableViewerManager.this.activeColumn));
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    public Collection<DLine> getSelectedLines() {
        ArrayList result = Lists.newArrayList();
        if (this.treeViewer.getTree().getSelectionCount() > 0) {
            TreeItem[] treeItemArray = this.treeViewer.getTree().getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                Object data = item.getData();
                if (data instanceof DLine) {
                    result.add((DLine)data);
                }
                ++n2;
            }
        }
        return result;
    }

    public ITableCommandFactory getTableCommandFactory() {
        return this.tableCommandFactory;
    }

    private void addNewColumn(DColumn newColumn, int index) {
        this.addNewColumn(newColumn, index, false);
    }

    public void addNewColumn(DColumn newColumn, int index, boolean changeInput) {
        DslCommonPlugin.PROFILER.startWork("Add a column in the SWT table");
        if (this.treeViewer.getTree() != null) {
            TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn tCol = treeColumnArray[n2];
                Object data = tCol.getData(TABLE_COLUMN_DATA);
                if (data != null && data.equals(newColumn)) {
                    return;
                }
                ++n2;
            }
        }
        TreeViewerColumn treeViewerColumn = new TreeViewerColumn((TreeViewer)this.treeViewer, 16384, index);
        if (newColumn.getLabel() != null) {
            DslCommonPlugin.PROFILER.startWork("Set the column name in the SWT table");
            TreeColumn treeColumn = treeViewerColumn.getColumn();
            DTableColumnHeaderLabelProvider dTableColumnHeaderLabelProvider = new DTableColumnHeaderLabelProvider();
            String text = dTableColumnHeaderLabelProvider.getText(newColumn);
            treeColumn.setText(text);
            Image image = dTableColumnHeaderLabelProvider.getImage(newColumn);
            treeColumn.setImage(image);
            DslCommonPlugin.PROFILER.stopWork("Set the column name in the SWT table");
        }
        if (newColumn.isVisible()) {
            if (newColumn.getWidth() != 0) {
                ((TreeColumnLayout)this.treeViewer.getControl().getParent().getLayout()).setColumnData((Widget)treeViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(newColumn.getWidth()));
                if (treeViewerColumn.getColumn().getWidth() != newColumn.getWidth()) {
                    treeViewerColumn.getColumn().setWidth(newColumn.getWidth());
                }
            } else {
                ((TreeColumnLayout)this.treeViewer.getControl().getParent().getLayout()).setColumnData((Widget)treeViewerColumn.getColumn(), (ColumnLayoutData)new ColumnWeightData(1));
                if (IS_GTK_OS) {
                    treeViewerColumn.getColumn().pack();
                }
            }
        } else {
            ((TreeColumnLayout)this.treeViewer.getControl().getParent().getLayout()).setColumnData((Widget)treeViewerColumn.getColumn(), (ColumnLayoutData)new ColumnPixelData(0));
        }
        ILabelDecorator decorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        treeViewerColumn.setLabelProvider((CellLabelProvider)new DTableDecoratingLabelProvider(newColumn, decorator));
        if (newColumn instanceof DFeatureColumn) {
            treeViewerColumn.setEditingSupport((EditingSupport)new DFeatureColumnEditingSupport((ColumnViewer)this.treeViewer, (DFeatureColumn)newColumn, this.getEditingDomain(), this.getAccessor(), this.getTableCommandFactory(), (AbstractDTableEditor)this.tableEditor));
        } else if (newColumn instanceof DTargetColumn) {
            treeViewerColumn.setEditingSupport((EditingSupport)new DTargetColumnEditingSupport((ColumnViewer)this.treeViewer, (DTargetColumn)newColumn, this.getEditingDomain(), this.getAccessor(), this.tableCommandFactory, (AbstractDTableEditor)this.tableEditor));
        }
        treeViewerColumn.getColumn().setData(TABLE_COLUMN_DATA, (Object)newColumn);
        treeViewerColumn.getColumn().addControlListener((ControlListener)this.tableViewerListener);
        treeViewerColumn.getColumn().addListener(13, this.sortListener);
        DslCommonPlugin.PROFILER.stopWork("Add a column in the SWT table");
    }

    public void removeOldColumn(DColumn oldColumn) {
        TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn treeColumn = treeColumnArray[n2];
            DColumn columnData = (DColumn)treeColumn.getData(TABLE_COLUMN_DATA);
            if (columnData != null && columnData.equals(oldColumn)) {
                treeColumn.dispose();
                break;
            }
            ++n2;
        }
    }

    public void removeOldColumn(int position) {
        try {
            TreeColumn treeColumn = this.treeViewer.getTree().getColumn(position);
            treeColumn.dispose();
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public boolean isSameTable(DTable table) {
        return ((DTable)this.dRepresentation).equals(table);
    }

    public void refreshColumns() {
        for (DColumn column : ((DTable)this.dRepresentation).getColumns()) {
            boolean columnFound = false;
            TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn treeColumn = treeColumnArray[n2];
                DColumn columnData = (DColumn)treeColumn.getData(TABLE_COLUMN_DATA);
                if (columnData != null && columnData.equals(column)) {
                    columnFound = true;
                    if (treeColumn.getText() == null || treeColumn.getText().equals(columnData.getLabel()) || columnData.getLabel() == null) break;
                    treeColumn.setText(columnData.getLabel());
                    break;
                }
                ++n2;
            }
            if (columnFound) continue;
            this.addNewColumn(column, -1, true);
        }
        int i = this.treeViewer.getTree().getColumnCount() - 1;
        while (i > 0) {
            TreeColumn treeColumn = this.treeViewer.getTree().getColumn(i);
            DColumn columnData = (DColumn)treeColumn.getData(TABLE_COLUMN_DATA);
            Iterator iterDTableColumns = ((DTable)this.dRepresentation).getColumns().iterator();
            boolean columnFound = false;
            while (iterDTableColumns.hasNext() && !columnFound) {
                DColumn column = (DColumn)iterDTableColumns.next();
                if (columnData == null || !columnData.equals(column)) continue;
                columnFound = true;
            }
            if (!columnFound) {
                treeColumn.dispose();
            }
            --i;
        }
        if (((DTable)this.dRepresentation).getDescription() instanceof CrossTableDescription) {
            int[] order = new int[this.treeViewer.getTree().getColumnCount()];
            order[0] = 0;
            int indexTableColumn = 0;
            while (indexTableColumn < ((DTable)this.dRepresentation).getColumns().size()) {
                DColumn column = (DColumn)((DTable)this.dRepresentation).getColumns().get(indexTableColumn);
                if (column instanceof DTargetColumn) {
                    boolean found = false;
                    int indexSwtTreeColumn = 1;
                    while (indexSwtTreeColumn < this.treeViewer.getTree().getColumnCount() && !found) {
                        TreeColumn treeColumn = this.treeViewer.getTree().getColumn(indexSwtTreeColumn);
                        DColumn columnData = (DColumn)treeColumn.getData(TABLE_COLUMN_DATA);
                        if (columnData != null && columnData.equals(column)) {
                            order[indexTableColumn + 1] = indexSwtTreeColumn;
                            found = true;
                        }
                        ++indexSwtTreeColumn;
                    }
                }
                ++indexTableColumn;
            }
            this.treeViewer.getTree().setColumnOrder(order);
        }
    }

    public AbstractDTableEditor getEditor() {
        return (AbstractDTableEditor)this.tableEditor;
    }

    public EditorCreateLineMenuAction getCreateLineMenu() {
        return this.createLineMenu;
    }

    public EditorCreateTargetColumnMenuAction getCreateTargetColumnMenu() {
        return this.createTargetColumnMenu;
    }

    private void sortLines() {
        SortLinesByColumnAction action = new SortLinesByColumnAction(this.getEditingDomain());
        action.setColumn(this.sortedBy);
        if (this.sortedBy == null) {
            action.setTable((DTable)this.dRepresentation);
        }
        action.run();
    }

    public void dispose() {
        this.treeViewer.removeTreeListener((ITreeViewerListener)this.tableViewerListener);
        this.tableViewerListener = null;
        this.tableUIUpdater.dispose();
        this.tableUIUpdater = null;
        this.dTableContentProvider.dispose();
        this.dTableContentProvider = null;
        super.dispose();
        this.createLineMenu.dispose();
        this.createLineMenu = null;
        this.createTargetColumnMenu.dispose();
        this.createTargetColumnMenu = null;
    }

    private final class SortListener
    implements Listener {
        private SortListener() {
        }

        public void handleEvent(Event e) {
            TreeColumn currentTreeColumn = (TreeColumn)e.widget;
            DColumn currentColumn = (DColumn)currentTreeColumn.getData(DTableViewerManager.TABLE_COLUMN_DATA);
            if (DTableViewerManager.this.sortedBy == null && currentColumn == null || DTableViewerManager.this.sortedBy != null && DTableViewerManager.this.sortedBy.equals(currentColumn)) {
                DTableViewerManager.this.sortDirection = DTableViewerManager.this.sortDirection == 128 ? 1024 : 128;
            } else {
                DTableViewerManager.this.sortDirection = 128;
                DTableViewerManager.this.sortedBy = currentColumn;
            }
            DTableViewerManager.this.sortLines();
        }
    }
}

