/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.papyrus.infra.core.resource.ReadOnlyAxis;

public class TransactionHelper
extends org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.utils.TransactionHelper {
    public static final String TRANSACTION_OPTION_READ_ONLY_AXIS = "papyrus.read_only_axis";
    public static final String TRANSACTION_OPTION_INTERACTIVE = "papyrus.interactive";

    public static boolean isDisposed(TransactionalEditingDomain domain) {
        return domain == null || domain.getCommandStack() == null;
    }

    public static Map<String, Object> mergeReadOnlyAxisOption(Map<String, Object> options, ReadOnlyAxis axis) {
        return TransactionHelper.mergeReadOnlyAxisOption(options, Collections.singleton(axis));
    }

    public static Map<String, Object> mergeReadOnlyAxisOption(Map<String, Object> options, Set<ReadOnlyAxis> axes) {
        options.put(TRANSACTION_OPTION_READ_ONLY_AXIS, axes);
        return options;
    }

    public static Map<String, Object> addReadOnlyAxisOption(Map<String, ?> options, ReadOnlyAxis axis) {
        return TransactionHelper.addReadOnlyAxisOption(options, Collections.singleton(axis));
    }

    public static Map<String, Object> addReadOnlyAxisOption(Map<String, ?> options, Set<ReadOnlyAxis> axes) {
        HashMap result = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
        result.put(TRANSACTION_OPTION_READ_ONLY_AXIS, axes);
        return result;
    }

    public static Map<String, Object> readOnlyAxisOption(ReadOnlyAxis axis) {
        return TransactionHelper.readOnlyAxisOption(Collections.singleton(axis));
    }

    public static Map<String, Object> readOnlyAxisOption(Set<ReadOnlyAxis> axes) {
        return TransactionHelper.addReadOnlyAxisOption(null, axes);
    }

    public static Set<ReadOnlyAxis> getReadOnlyAxisOption(Transaction transaction) {
        Object value = transaction.getOptions().get(TRANSACTION_OPTION_READ_ONLY_AXIS);
        ImmutableSet result = value instanceof Set ? (ImmutableSet)value : (value instanceof Iterable ? Sets.immutableEnumSet((Iterable)((Iterable)value)) : ReadOnlyAxis.anyAxis());
        return result;
    }

    public static Map<String, Object> mergeInteractiveOption(Map<String, Object> options, boolean interactive) {
        options.put(TRANSACTION_OPTION_INTERACTIVE, interactive);
        return options;
    }

    public static Map<String, Object> addInteractiveOption(Map<String, ?> options, boolean interactive) {
        HashMap result = options == null ? Maps.newHashMap() : Maps.newHashMap(options);
        result.put(TRANSACTION_OPTION_INTERACTIVE, interactive);
        return result;
    }

    public static Map<String, Object> interactiveOption(boolean interactive) {
        return TransactionHelper.addInteractiveOption(null, interactive);
    }

    public static boolean isInteractive(Transaction transaction) {
        Object value = transaction.getOptions().get(TRANSACTION_OPTION_INTERACTIVE);
        return value instanceof Boolean ? (Boolean)value : true;
    }

    public static IRunnableWithProgress createPrivilegedRunnableWithProgress(TransactionalEditingDomain domain, final IRunnableWithProgress runnable) {
        final IProgressMonitor[] monitorHolder = new IProgressMonitor[1];
        RunnableWithResult privileged = domain.createPrivilegedRunnable(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run(monitorHolder[0]);
                }
                catch (Exception e) {
                    throw new WrappedException(e);
                }
            }
        });
        return new IRunnableWithProgress((Runnable)privileged){
            private final /* synthetic */ Runnable val$privileged;
            {
                this.val$privileged = runnable;
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitorHolder[0] = monitor;
                try {
                    this.val$privileged.run();
                }
                catch (WrappedException e) {
                    Exception unwrapped = e.exception();
                    if (unwrapped instanceof InvocationTargetException) {
                        throw (InvocationTargetException)unwrapped;
                    }
                    if (unwrapped instanceof InterruptedException) {
                        throw (InterruptedException)unwrapped;
                    }
                    throw e;
                }
            }
        };
    }
}

