/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.core.utils;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.core.Activator;
import org.eclipse.papyrus.infra.core.editor.BackboneException;
import org.eclipse.papyrus.infra.core.editor.CoreMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.core.resource.sasheditor.DiModelUtils;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageManager;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.infra.core.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.infra.core.sasheditor.di.contentprovider.DiSashModelMngr;
import org.eclipse.papyrus.infra.core.sasheditor.editor.IPage;
import org.eclipse.papyrus.infra.core.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.DiResourceSet;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class EditorUtils {
    public static IMultiDiagramEditor[] getMultiDiagramEditors() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        ArrayList<IMultiDiagramEditor> list = new ArrayList<IMultiDiagramEditor>();
        IEditorReference[] iEditorReferenceArray = page.getEditorReferences();
        int n = iEditorReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editorRef = iEditorReferenceArray[n2];
            IEditorPart editorPart = editorRef.getEditor(false);
            if (editorPart instanceof IMultiDiagramEditor) {
                list.add((IMultiDiagramEditor)editorPart);
            }
            ++n2;
        }
        return list.toArray(new IMultiDiagramEditor[list.size()]);
    }

    public static IMultiDiagramEditor[] getRelatedEditors(IFile file) {
        IFile diFile = DiModelUtils.getRelatedDiFile(file);
        if (diFile == null || !diFile.exists()) {
            return new IMultiDiagramEditor[0];
        }
        IMultiDiagramEditor[] openedEditors = EditorUtils.getMultiDiagramEditors();
        if (openedEditors == null) {
            return new IMultiDiagramEditor[0];
        }
        ArrayList<IMultiDiagramEditor> list = new ArrayList<IMultiDiagramEditor>(openedEditors.length);
        IMultiDiagramEditor[] iMultiDiagramEditorArray = openedEditors;
        int n = openedEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IMultiDiagramEditor editorPart = iMultiDiagramEditorArray[n2];
            if (editorPart.getEditorInput() instanceof IFileEditorInput && diFile.equals((Object)((IFileEditorInput)editorPart.getEditorInput()).getFile())) {
                list.add(editorPart);
            }
            ++n2;
        }
        return list.toArray(new IMultiDiagramEditor[list.size()]);
    }

    public static IPageManager getIPageMngr(Resource diResource) {
        return DiSashModelMngr.createIPageMngr((Resource)diResource);
    }

    public static IMultiDiagramEditor getMultiDiagramEditor() {
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow == null) {
            return null;
        }
        IWorkbenchPage page = workbenchWindow.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editor;
        }
        return null;
    }

    @Deprecated
    public static IEditorPart lookupActiveNestedIEditor() {
        ISashWindowsContainer container = EditorUtils.getSashWindowContainer();
        return container == null ? null : container.getActiveEditor();
    }

    @Deprecated
    public static IPage lookupActiveNestedPage() {
        ISashWindowsContainer container = EditorUtils.getSashWindowContainer();
        return container == null ? null : container.getActiveSashWindowsPage();
    }

    private static ISashWindowsContainer getSashWindowContainer() {
        try {
            return EditorUtils.getServiceRegistryChecked().getService(ISashWindowsContainer.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @Deprecated
    public static DiResourceSet getDiResourceSet() {
        try {
            ServicesRegistry registry = EditorUtils.getServiceRegistry();
            return registry == null ? null : registry.getService(DiResourceSet.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
    }

    @Deprecated
    public static TransactionalEditingDomain getTransactionalEditingDomain() {
        try {
            ServicesRegistry registry = EditorUtils.getServiceRegistry();
            return registry == null ? null : registry.getService(TransactionalEditingDomain.class);
        }
        catch (IllegalStateException registry) {
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static TransactionalEditingDomain getTransactionalEditingDomainChecked() throws ServiceException {
        try {
            ServicesRegistry registry = EditorUtils.getServiceRegistryChecked();
            return registry.getService(TransactionalEditingDomain.class);
        }
        catch (IllegalStateException e) {
            throw new ServiceException(e);
        }
        catch (Exception e) {
            throw new ServiceException(e);
        }
    }

    @Deprecated
    public static TransactionalEditingDomain getTransactionalEditingDomain(ServicesRegistry registry) {
        try {
            return registry.getService(TransactionalEditingDomain.class);
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
        return null;
    }

    @Deprecated
    public static TransactionalEditingDomain getTransactionalEditingDomainChecked(ServicesRegistry registry) throws ServiceException {
        return registry.getService(TransactionalEditingDomain.class);
    }

    @Deprecated
    public static ServicesRegistry getServiceRegistry() {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        return editor == null ? null : (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
    }

    @Deprecated
    public static ServicesRegistry getServiceRegistryChecked() throws ServiceException {
        IMultiDiagramEditor editor = EditorUtils.getMultiDiagramEditor();
        if (editor == null) {
            throw new ServiceException("Can't get ServiceRegistry");
        }
        return (ServicesRegistry)editor.getAdapter(ServicesRegistry.class);
    }

    @Deprecated
    public static ISashWindowsContentProvider getISashWindowsContentProvider() {
        try {
            return EditorUtils.getServiceRegistryChecked().getService(ISashWindowsContentProvider.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @Deprecated
    public static IPageMngr getIPageMngr() {
        try {
            return EditorUtils.getServiceRegistryChecked().getService(IPageMngr.class);
        }
        catch (ServiceException e) {
            return null;
        }
    }

    @Deprecated
    protected static IEditorPart getWorkbenchActiveEditor() {
        IMultiDiagramEditor editorPart = EditorUtils.getMultiDiagramEditor();
        if (editorPart instanceof CoreMultiDiagramEditor) {
            return editorPart;
        }
        return null;
    }

    public static IMultiDiagramEditor getMultiDiagramEditorChecked() throws BackboneException {
        IEditorPart editor;
        try {
            editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        }
        catch (NullPointerException e) {
            throw new BackboneException("Can't get the current Eclipse Active Editor: There is no active editor at this time.");
        }
        if (editor instanceof IMultiDiagramEditor) {
            return (IMultiDiagramEditor)editor;
        }
        throw new BackboneException("Can't get an Active Editor instance of IMultiDiagramEditor. (actual type:" + editor.getClass().getName() + ")");
    }

    public static URI getResourceURI(IEditorReference editorRef) {
        try {
            return EditorUtils.getResourceURI(editorRef.getEditorInput());
        }
        catch (PartInitException e) {
            Activator.log.error("Could not obtain editor input from editor reference.", (Throwable)e);
            return null;
        }
    }

    public static URI getResourceURI(IEditorPart editor) {
        return EditorUtils.getResourceURI(editor.getEditorInput());
    }

    public static URI getResourceURI(IEditorInput editorInput) {
        Object adapter;
        URI result = null;
        if (editorInput instanceof IFileEditorInput) {
            result = URI.createPlatformResourceURI((String)((IFileEditorInput)editorInput).getFile().getFullPath().toString(), (boolean)true);
        } else if (editorInput instanceof URIEditorInput) {
            result = ((URIEditorInput)editorInput).getURI();
        } else if (editorInput instanceof IURIEditorInput) {
            result = URI.createURI((String)((IURIEditorInput)editorInput).getURI().toASCIIString(), (boolean)true);
        } else if (editorInput != null && (adapter = editorInput.getAdapter(URI.class)) instanceof URI) {
            result = (URI)adapter;
        }
        return result;
    }
}

